/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.vo.riskResolve;

import cn.hutool.core.convert.Convert;
import cn.smarthse.modules.health.vo.riskResolve.RegionRiskNumInfoVo;
import cn.smarthse.modules.health.vo.riskResolve.RiskCount;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class RiskCalculator {
    public static final BigDecimal LESS_FREE_RATE = Convert.toBigDecimal((Object)0.34).multiply(Convert.toBigDecimal((Object)0.5));
    public static final BigDecimal MOST_FREE_RATE = Convert.toBigDecimal((Object)0.34).multiply(Convert.toBigDecimal((Object)5));
    public static final BigDecimal MID_FREE_RATE = Convert.toBigDecimal((Object)0.34).multiply(Convert.toBigDecimal((Object)2.25));
    public static final BigDecimal TEN_THOUSAND = Convert.toBigDecimal((Object)10000);
    public static final BigDecimal SINGLE_RISK_COEFFICIENT_1 = Convert.toBigDecimal((Object)0.5).multiply(Convert.toBigDecimal((Object)0.3));
    public static final BigDecimal SINGLE_RISK_COEFFICIENT_2 = Convert.toBigDecimal((Object)5).multiply(Convert.toBigDecimal((Object)0.31));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_2 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.32));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_3 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.33));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_4 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.34));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_5 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.35));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_6 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.36));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_7 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.37));
    public static final BigDecimal MULTIPLE_RISK_COEFFICIENT_8 = Convert.toBigDecimal((Object)5.5).multiply(Convert.toBigDecimal((Object)0.38));
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyyMM");
    public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final String CURRENT_YEAR_MONTH = LocalDate.now().format(YYYY_MM);
    public static final YearMonth YEAR_MONTH = YearMonth.parse(CURRENT_YEAR_MONTH, YYYY_MM);
    public static final int CURRENT_YEAR = YEAR_MONTH.getYear();
    public static final int CURRENT_MONTH = YEAR_MONTH.getMonthValue();

    public static BigDecimal calculateEconomicForSingle(RegionRiskNumInfoVo r) {
        return RiskCalculator.calculate(RiskCount.from(r));
    }

    public static BigDecimal calculateEconomicForList(List<RegionRiskNumInfoVo> riskList) {
        return RiskCalculator.calculate(RiskCount.sum(riskList));
    }

    private static BigDecimal calculate(RiskCount cnt) {
        return RiskCalculator.toBigDecimalSafe(cnt.singleResolvePxNum()).multiply(SINGLE_RISK_COEFFICIENT_1).add(RiskCalculator.toBigDecimalSafe(cnt.singleResolveTjNum()).multiply(SINGLE_RISK_COEFFICIENT_2)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve2Num()).multiply(MULTIPLE_RISK_COEFFICIENT_2)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve3Num()).multiply(MULTIPLE_RISK_COEFFICIENT_3)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve4Num()).multiply(MULTIPLE_RISK_COEFFICIENT_4)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve5Num()).multiply(MULTIPLE_RISK_COEFFICIENT_5)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve6Num()).multiply(MULTIPLE_RISK_COEFFICIENT_6)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve7Num()).multiply(MULTIPLE_RISK_COEFFICIENT_7)).add(RiskCalculator.toBigDecimalSafe(cnt.multipleResolve8Num()).multiply(MULTIPLE_RISK_COEFFICIENT_8)).setScale(4, RoundingMode.HALF_UP);
    }

    private static BigDecimal toBigDecimalSafe(long value) {
        return BigDecimal.valueOf(value);
    }
}

