/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.vo.archive;

import cn.smarthse.modules.health.vo.archive.HcCheckPlanSystemName;
import cn.smarthse.modules.health.vo.archive.LimitValueTable;
import cn.smarthse.modules.health.vo.archive.ResultAttributeName;
import java.util.ArrayList;
import java.util.List;

public enum ResultCollectType {
    CHEMICAL(1, "\u5316\u5b66\u7269\u8d28 ", false, 1, "colellectchemical", "colellectchemicaltr", "colellectchemicaledit", "colellectchemicalstaff", null, LimitValueTable.l_08_2_occupational_risk_factors_hx_sw),
    DUST(2, "\u7c89\u5c18", false, 1, "colellectdust", "colellectdusttr", "colellectdustedit", "colellectduststaff", null, LimitValueTable.l_08_3_occupational_risk_factors_fc),
    BIOLOGICAL(3, "\u751f\u7269\u56e0\u7d20", false, 1, "colellectbiological", "colellectbiologicaltr", "colellectbiologicaledit", "colellectbiologicalstaff", null, LimitValueTable.l_08_2_occupational_risk_factors_hx_sw),
    NOISE(4, "\u566a\u58f0 ", false, 2, "collectnoise", "collectnoisetr", "collectnoiseedit", "collectnoisestaff", "WL1", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    HIGHFREQUENCY(5, "\u9ad8\u9891\u7535\u78c1\u573a", false, 2, "collecthighfrequency", "collecthighfrequencytr", "collecthighfrequencyedit", "collecthighfrequencystaff", "WL13", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    IONIZINGRADIATION(6, "\u7535\u79bb\u8f90\u5c04", false, 2, "collectionizingradiation", "collectionizingradiationtr", "collectionizingradiationedit", "collectionizingradiationstaff", null, LimitValueTable.L_08_4_occupational_risk_factors_fs),
    ULTRAHIGHFREQUENCYRADIATION(7, "\u8d85\u9ad8\u9891\u8f90\u5c04 ", false, 2, "collectultrahighfrequencyradiation", "collectultrahighfrequencyradiationtr", "collectultrahighfrequencyradiationedit", "collectultrahighfrequencyradiationstaff", "WL14", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    HANDTRANSMITTED(8, "\u624b\u4f20\u632f\u52a8", false, 2, "collecthandtransmitted", "collecthandtransmittedtr", "collecthandtransmittededit", "collecthandtransmittedstaff", "WL6", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    MICROWAVERADIATION(9, "\u5fae\u6ce2\u8f90\u5c04", false, 2, "collectmicrowaveradiation", "collectmicrowaveradiationtr", "collectmicrowaveradiationedit", "collectmicrowaveradiationstaff", "WL9", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    ULTRAVIOLETLIGHT(10, "\u7d2b\u5916\u8f90\u5c04", false, 2, "collectultravioletlight", "collectultravioletlighttr", "collectultravioletlightedit", "collectultravioletlightstaff", "WL10", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    POWERFREQUENCY(11, "\u5de5\u9891\u7535\u573a", false, 2, "collectpowerfrequency", "collectpowerfrequencytr", "collectpowerfrequencyedit", "collectpowerfrequencystaff", "WL12", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    HIGHTEMPERATURE(12, "\u9ad8\u6e29", false, 2, "collecthightemperature", "collecthightemperaturetr", "collecthightemperatureedit", "collecthightemperaturestaff", "WL2", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    LASERRADIATION(13, "\u6fc0\u5149\u8f90\u5c04", false, 2, "collectlaserradiation", "collectlaserradiationtr", "collectlaserradiationedit", "collectlaserradiationstaff", "WL7", LimitValueTable.l_08_4_occupational_risk_factors_wl),
    ILLUMINANCY(14, "\u7167\u5ea6", false, 3, "collectilluminancy", "collectilluminancytr", "collectilluminancyedit", "collectilluminancystaff", null, null),
    MICROCLIMATE(15, "\u5fae\u5c0f\u6c14\u5019", false, 3, "collectmicroclimate", "collectmicroclimatetr", "collectmicroclimateedit", "collectmicroclimatestaff", null, null),
    WINDSPEED(16, "\u98ce\u901f", false, 3, "collectwindspeed", "collectwindspeedtr", "collectwindspeededit", "collectwindspeedstaff", null, null),
    FRESHAIRRATE(17, "\u65b0\u98ce\u91cf", false, 3, "collectfreshairrate", "collectfreshairratetr", "collectfreshairrateedit", "collectfreshairratestaff", null, null);

    private Integer code;
    private String name;
    private Boolean selected;
    private Integer groupId;
    private String page;
    private String pageEdit;
    private String trPage;
    private String staffPage;
    private String paramCode;
    private LimitValueTable limitValueTable;

    private ResultCollectType(Integer code, String name, Boolean selected, Integer groupId, String page, String trPage, String pageEdit, String staffPage, String paramCode, LimitValueTable limitValueTable) {
        this.code = code;
        this.name = name;
        this.selected = selected;
        this.groupId = groupId;
        this.page = page;
        this.pageEdit = pageEdit;
        this.trPage = trPage;
        this.staffPage = staffPage;
        this.paramCode = paramCode;
        this.limitValueTable = limitValueTable;
    }

    public static ResultCollectType getResultTypeByCode(Integer code) {
        for (ResultCollectType c : ResultCollectType.values()) {
            if (code.intValue() != c.getCode().intValue()) continue;
            return c;
        }
        return null;
    }

    public static List<ResultAttributeName> getResultAttributeNameListByCode(Integer ResultCollectTypeCode, HcCheckPlanSystemName systemName) {
        if (ResultCollectTypeCode == null || systemName == null) {
            return null;
        }
        boolean isArea = false;
        boolean isPost = false;
        if (HcCheckPlanSystemName.area.ordinal() == systemName.ordinal()) {
            isArea = true;
        } else if (HcCheckPlanSystemName.post.ordinal() == systemName.ordinal()) {
            isPost = true;
        }
        ArrayList<ResultAttributeName> list = new ArrayList<ResultAttributeName>();
        for (ResultAttributeName resultAttributeName : ResultAttributeName.values()) {
            if (!ResultCollectTypeCode.equals(resultAttributeName.getType().getCode())) continue;
            if (resultAttributeName.getIsArea().booleanValue() && isArea) {
                list.add(resultAttributeName);
                continue;
            }
            if (!resultAttributeName.getIsPost().booleanValue() || !isPost) continue;
            list.add(resultAttributeName);
        }
        return list;
    }

    public static String getCodeByName(String name) {
        for (ResultCollectType r : ResultCollectType.values()) {
            if (!r.getName().equals(name)) continue;
        }
        return "";
    }

    public static String getNameByCode(Integer code) {
        String name = "";
        for (ResultCollectType r : ResultCollectType.values()) {
            if (r.getCode() != code) continue;
            name = r.getName();
        }
        return name;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public String getPage() {
        return this.page;
    }

    public String getPageEdit() {
        return this.pageEdit;
    }

    public String getTrPage() {
        return this.trPage;
    }

    public String getStaffPage() {
        return this.staffPage;
    }

    public String getParamCode() {
        return this.paramCode;
    }

    public void setParamCode(String paramCode) {
        this.paramCode = paramCode;
    }

    public LimitValueTable getLimitValueTable() {
        return this.limitValueTable;
    }

    public void setLimitValueTable(LimitValueTable limitValueTable) {
        this.limitValueTable = limitValueTable;
    }

    public static String getParamCodeByCode(String code) {
        ResultCollectType[] values;
        String paramCode = "";
        for (ResultCollectType r : values = ResultCollectType.values()) {
            if (!("" + r.code).equals(code)) continue;
            paramCode = r.paramCode;
            break;
        }
        return paramCode;
    }

    public static Integer getCodeByParamCode(Integer paramCode) {
        ResultCollectType[] values;
        Integer code = null;
        for (ResultCollectType r : values = ResultCollectType.values()) {
            if (!paramCode.equals(r.getParamCode())) continue;
            code = r.getCode();
            break;
        }
        return code;
    }
}

