/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.util;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.litearchive.LiteArchiveFileItem;
import cn.smarthse.modules.health.enums.archive.ArchiveFilteItemDataStateEnum;
import cn.smarthse.modules.health.enums.archive.LiteArchiveRequiredEnum;
import cn.smarthse.modules.health.vo.litearchive.LiteArchiveFileDetailVo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LiteArchiveUtils {
    public static BinaryOperator<LiteArchiveFileItem> filteItemMergeFunction = (item1, item2) -> {
        HashSet filesIdSet = new HashSet();
        if (!Objects.equals(item1.getFileIds(), item1.getReferFileIds())) {
            filesIdSet.addAll(CommonUtil.str2LongSet((String)item1.getFileIds(), (String)","));
        }
        if (!Objects.equals(item2.getFileIds(), item2.getReferFileIds())) {
            filesIdSet.addAll(CommonUtil.str2LongSet((String)item2.getFileIds(), (String)","));
        }
        LiteArchiveFileItem merged = LiteArchiveUtils.selectItemByRules(item1, item2);
        if (CollectionUtils.isNotEmpty(filesIdSet)) {
            merged.setFileIds(StringUtils.join(filesIdSet, (String)","));
        }
        return merged;
    };

    private static LiteArchiveFileItem selectItemByRules(LiteArchiveFileItem item1, LiteArchiveFileItem item2) {
        if (item1.getUpdateDate() != null && item2.getUpdateDate() != null) {
            return item2.getUpdateDate().after(item1.getUpdateDate()) ? item2 : item1;
        }
        if (item2.getUpdateDate() != null) {
            return item2;
        }
        if (item1.getUpdateDate() != null) {
            return item1;
        }
        return item2.getCreateDate().after(item1.getCreateDate()) ? item2 : item1;
    }

    public static List<Integer> getHgArchiveYear() {
        int thisYear = DateUtils.getThisYear();
        if (thisYear == 2024) {
            return Arrays.asList(2023);
        }
        return Arrays.asList(thisYear - 2, thisYear - 1);
    }

    public static LiteArchiveFileItem appendFileItem(Long archiveId, Long fileNameId, String fileIds, String referFileIds, Consumer<LiteArchiveFileItem> consumer) {
        LiteArchiveFileItem item = new LiteArchiveFileItem();
        item.setLiteArchiveId(archiveId);
        item.setFileNameId(fileNameId);
        item.setFileIds(fileIds);
        item.setReferFileIds(referFileIds);
        if (consumer != null) {
            consumer.accept(item);
        }
        return item;
    }

    public static List<LiteArchiveFileDetailVo> getHgRequiredListVo(List<LiteArchiveFileDetailVo> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                List fileIdList;
                if (archive.getHgIsRequired() == null || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getFileIds(), (String)",");
                    archive.setFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getReferFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getReferFileIds(), (String)",");
                    archive.setReferFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (Objects.equals(isfinish, true)) {
                    return Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                if (Objects.equals(isfinish, false)) {
                    return Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && !Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                return true;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<LiteArchiveFileDetailVo> getCommonRequiredListVo(List<LiteArchiveFileDetailVo> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                List fileIdList;
                if (archive.getIsRequired() == null || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getFileIds(), (String)",");
                    archive.setFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getReferFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getReferFileIds(), (String)",");
                    archive.setReferFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (Objects.equals(isfinish, true)) {
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        return StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || StringUtils.isNotBlank((CharSequence)archive.getStorageLocation());
                    }
                    return Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                if (Objects.equals(isfinish, false)) {
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        return StringUtils.isBlank((CharSequence)archive.getFileIds()) && StringUtils.isBlank((CharSequence)archive.getStorageLocation());
                    }
                    return Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && !Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                return true;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<LiteArchiveFileItem> getHgRequiredList(List<LiteArchiveFileItem> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                List fileIdList;
                if (Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getFileIds(), (String)",");
                    archive.setFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getReferFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getReferFileIds(), (String)",");
                    archive.setReferFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (Objects.equals(isfinish, true)) {
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        return StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || StringUtils.isNotBlank((CharSequence)archive.getStorageLocation());
                    }
                    return Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                if (Objects.equals(isfinish, false)) {
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        return StringUtils.isBlank((CharSequence)archive.getFileIds()) && StringUtils.isBlank((CharSequence)archive.getStorageLocation());
                    }
                    return Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && !Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getHgDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()) || Objects.equals(archive.getHgIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                return true;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<LiteArchiveFileItem> getCommonRequiredList(List<LiteArchiveFileItem> archiveList, Boolean isfinish) {
        if (CollectionUtils.isNotEmpty(archiveList)) {
            return archiveList.stream().filter(archive -> {
                List fileIdList;
                if (Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.NO.getCode())) {
                    return false;
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getFileIds(), (String)",");
                    archive.setFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (StringUtils.isNotBlank((CharSequence)archive.getReferFileIds())) {
                    fileIdList = CommonUtil.str2LongList((String)archive.getReferFileIds(), (String)",");
                    archive.setReferFileIds(StringUtils.join((Iterable)fileIdList, (String)","));
                }
                if (Objects.equals(isfinish, true)) {
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        return StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || StringUtils.isNotBlank((CharSequence)archive.getStorageLocation());
                    }
                    return Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                if (Objects.equals(isfinish, false)) {
                    if (Objects.equals(archive.getFileNameId(), 212L)) {
                        return StringUtils.isBlank((CharSequence)archive.getFileIds()) && StringUtils.isBlank((CharSequence)archive.getStorageLocation());
                    }
                    return Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOAD.getCode()) && StringUtils.isBlank((CharSequence)archive.getFileIds()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.UPLOADANDDATA.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getFileIds()) && !Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.FULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.DATA.getCode()) && Objects.equals(archive.getDataState(), ArchiveFilteItemDataStateEnum.UNFULL.getValue()) || Objects.equals(archive.getIsRequired(), LiteArchiveRequiredEnum.REFER.getCode()) && !StringUtils.isNotBlank((CharSequence)archive.getReferFileIds());
                }
                return true;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

