/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.enums.selfjudge;

import java.util.Arrays;
import java.util.Optional;

public enum JudgeResultLevelEnum {
    A(1, "A", 90L, 100L),
    B(2, "B", 70L, 90L),
    C(3, "C", 0L, 70L);

    private Integer code;
    private String name;
    private Long minScore;
    private Long maxScore;

    private JudgeResultLevelEnum(Integer code, String name, Long minScore, Long maxScore) {
        this.code = code;
        this.name = name;
        this.minScore = minScore;
        this.maxScore = maxScore;
    }

    public static JudgeResultLevelEnum getThisEnumByScore(Double score) {
        if (score == null) {
            return C;
        }
        if ((double)JudgeResultLevelEnum.A.minScore.longValue() <= score && score <= (double)JudgeResultLevelEnum.A.maxScore.longValue()) {
            return A;
        }
        if ((double)JudgeResultLevelEnum.B.minScore.longValue() <= score && score < (double)JudgeResultLevelEnum.B.maxScore.longValue()) {
            return B;
        }
        return C;
    }

    public static JudgeResultLevelEnum getThisEnumByCode(Integer code) {
        return Arrays.stream(JudgeResultLevelEnum.values()).filter(s -> s.getCode().equals(code)).findFirst().orElse(C);
    }

    public static String getNameByCode(Integer code) {
        Optional<JudgeResultLevelEnum> judgeResultLevelEnum = Arrays.stream(JudgeResultLevelEnum.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (judgeResultLevelEnum.isPresent()) {
            return judgeResultLevelEnum.get().getName();
        }
        return "\u672a\u8bc4\u5b9a";
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Long getMinScore() {
        return this.minScore;
    }

    public Long getMaxScore() {
        return this.maxScore;
    }
}

