/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.enums.selfjudge;

import cn.smarthse.modules.health.enums.selfjudge.HarmNatureStandardEnum;
import java.util.Arrays;
import java.util.Optional;

public enum HazardsExposureRiskLevelEnum {
    lowRisk(1, "\u2160\u7ea7"),
    middleRisk(2, "\u2161\u7ea7"),
    heightRisk(3, "\u2162\u7ea7");

    private Integer code;
    private String name;

    private HazardsExposureRiskLevelEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private static HazardsExposureRiskLevelEnum getThisEnumByStandardEnumAndStaffCount(HarmNatureStandardEnum standard, int staffCount) {
        if (standard != null) {
            if (HarmNatureStandardEnum.generalNotOver.equals((Object)standard)) {
                return lowRisk;
            }
            if (HarmNatureStandardEnum.generalOver.equals((Object)standard)) {
                if (staffCount <= 9) {
                    return lowRisk;
                }
                if (staffCount <= 49) {
                    return middleRisk;
                }
                return heightRisk;
            }
            if (HarmNatureStandardEnum.seriousNotOver.equals((Object)standard)) {
                if (staffCount <= 0) {
                    return lowRisk;
                }
                if (staffCount <= 49) {
                    return middleRisk;
                }
                return heightRisk;
            }
            if (HarmNatureStandardEnum.seriousOver.equals((Object)standard)) {
                if (staffCount <= 9) {
                    return middleRisk;
                }
                return heightRisk;
            }
        }
        return null;
    }

    public static HazardsExposureRiskLevelEnum getFinalThisEnumByStaffCount(int generalOverStaffCount, int generalTotalStaffCount, int seriousOverStaffCount, int seriousOverTotalStaffCount) {
        HarmNatureStandardEnum general = HarmNatureStandardEnum.getThisGeneralEnumByStaffCount(generalOverStaffCount);
        HarmNatureStandardEnum serious = HarmNatureStandardEnum.getThisSeriousEnumByStaffCount(seriousOverStaffCount);
        HazardsExposureRiskLevelEnum generalLevel = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCount(general, generalTotalStaffCount);
        HazardsExposureRiskLevelEnum seriousLevel = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCount(serious, seriousOverTotalStaffCount);
        if (generalLevel == null && seriousLevel == null) {
            return null;
        }
        if (generalLevel == null && seriousLevel != null) {
            return seriousLevel;
        }
        if (generalLevel != null && seriousLevel == null) {
            return generalLevel;
        }
        Integer code = generalLevel.getCode();
        return code > seriousLevel.getCode() ? generalLevel : seriousLevel;
    }

    public static HazardsExposureRiskLevelEnum getThisEnumByCode(Integer code) {
        return Arrays.stream(HazardsExposureRiskLevelEnum.values()).filter(s -> s.getCode().equals(code)).findFirst().orElse(null);
    }

    public static String getNameByCode(Integer code) {
        Optional<HazardsExposureRiskLevelEnum> judgeResultLevelEnum = Arrays.stream(HazardsExposureRiskLevelEnum.values()).filter(s -> s.getCode().equals(code)).findFirst();
        if (judgeResultLevelEnum.isPresent()) {
            return judgeResultLevelEnum.get().getName();
        }
        return "\u672a\u8bc4\u5b9a";
    }
}

