/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.enums.scene;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.StringUtils;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum InspectionTypeEnum {
    comprehensive("\u7efc\u5408\u6027\u68c0\u67e5", 6),
    professional("\u4e13\u9879\u68c0\u67e5", 7),
    superiorsInspect("\u4e0a\u7ea7\u76d1\u7763\u68c0\u67e5", 17),
    superviseSuperiorsInspect("\u4e0a\u7ea7\u76d1\u7763\u68c0\u67e5", 18),
    dailyInspection("\u65e5\u5e38\u68c0\u67e5", 5),
    accidentAnalogy("\u4e8b\u6545\u7c7b\u6bd4\u68c0\u67e5", 16),
    majorHazard("\u91cd\u5927\u5371\u9669\u6e90\u68c0\u67e5", 8),
    holidayAround("\u8282\u5047\u65e5\u524d\u540e\u68c0\u67e5", 9),
    seasonality("\u5b63\u8282\u6027\u68c0\u67e5", 10),
    agency("\u4e2d\u4ecb\u673a\u6784\u68c0\u67e5", 12),
    other("\u5176\u4ed6\u7c7b\u68c0\u67e5", 13);

    private String name;
    private Byte value;

    private InspectionTypeEnum(String name, byte value) {
        this.name = name;
        this.value = value;
    }

    public static String getNameByValue(Byte value) {
        if (value == null) {
            return "";
        }
        for (InspectionTypeEnum type : InspectionTypeEnum.values()) {
            if (!type.getValue().equals(value)) continue;
            return type.getName();
        }
        return "";
    }

    public static boolean isSuperiorsType(Byte type) {
        if (type == null) {
            return false;
        }
        return type.equals(superiorsInspect.getValue());
    }

    public static Byte getTypeByString(String typeStr) {
        if (StringUtils.isEmpty((CharSequence)typeStr)) {
            return null;
        }
        for (InspectionTypeEnum type : InspectionTypeEnum.values()) {
            if (!("" + type.getValue()).equals(typeStr)) continue;
            return type.getValue();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getValue() {
        return this.value;
    }

    public void setValue(Byte value) {
        this.value = value;
    }
}

