/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.enums.company;

import cn.smarthse.common.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum CompanySizeEnum {
    Large("\u5927\u578b\u4f01\u4e1a", (byte)1),
    Medium("\u4e2d\u578b\u4f01\u4e1a", (byte)2),
    Small("\u5c0f\u578b\u4f01\u4e1a", (byte)3),
    Micro("\u5fae\u578b\u4f01\u4e1a", (byte)4),
    Undivided("\u672a\u5212\u5206", (byte)5);

    private String name;
    private Byte code;

    private CompanySizeEnum(String name, Byte code) {
        this.name = name;
        this.code = code;
    }

    public static String getName(Byte code) {
        if (code == null) {
            return null;
        }
        for (CompanySizeEnum c : CompanySizeEnum.values()) {
            if (!c.getCode().equals(code)) continue;
            return c.name;
        }
        return null;
    }

    public static Byte getCodeByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (CompanySizeEnum c : CompanySizeEnum.values()) {
            if (!c.getName().equals(name)) continue;
            return c.getCode();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getCode() {
        return this.code;
    }

    public void setCode(Byte code) {
        this.code = code;
    }

    public String getShortName() {
        String[] strings = this.name.split("\u4f01\u4e1a");
        if (StringUtils.isNotEmpty((String)strings[0])) {
            return strings[0];
        }
        return this.name;
    }
}

