/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.entity.work.train;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.train.TrainAttend;
import cn.smarthse.modules.health.entity.work.train.TrainBook;
import cn.smarthse.modules.health.entity.work.train.TrainExam;
import cn.smarthse.modules.health.entity.work.train.TrainPaperFile;
import cn.smarthse.modules.health.enums.train.TrainHsTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainOnLineEnum;
import cn.smarthse.modules.health.enums.train.TrainWayEnum;
import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.Generated;

@Table(name="train_plan")
public class TrainPlan
implements Serializable {
    private static final long serialVersionUID = 6708162357947035630L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="select RIGHT(uuid_short(), 19)")
    private Long id;
    private Long cid;
    private String no;
    private String name;
    @Column(name="hs_type")
    private String hsType;
    private String type;
    private Byte way;
    @Column(name="on_line")
    private Byte onLine;
    @Column(name="way_desc")
    private String wayDesc;
    @Column(name="organize_dept")
    private String organizeDept;
    @Column(name="coordination_dept")
    private String coordinationDept;
    private Long teacher;
    @Column(name="teacher_name")
    private String teacherName;
    @Column(name="teacher_dept")
    private String teacherDept;
    @Column(name="class_count")
    private String classCount;
    @Column(name="register_time")
    private Date registerTime;
    @Column(name="create_date")
    private Date createDate;
    @Column(name="update_date")
    private Date updateDate;
    @Column(name="create_by")
    private Long createBy;
    @Column(name="update_by")
    private Long updateBy;
    @Column(name="is_valid")
    private Boolean isValid;
    @Column(name="is_finish")
    private Boolean isFinish;
    @Column(name="status")
    private Byte status;
    @Column(name="train_attend")
    private String trainAttend;
    @Transient
    @EncryptField(dataProcessingMethodsType=DataProcessingMethodsType.ACCURATE)
    private String createName;
    @Transient
    private String compName;
    @Column(name="from_type")
    private Byte fromType;
    @Column(name="from_id")
    private Long fromId;
    @Column(name="org_id")
    private String orgId;
    @Column(name="third_org_id")
    private Long thirdOrgId;
    @Column(name="data_source")
    private Byte dataSource;
    private String registrant;
    @Column(name="report_id")
    private Long reportId;
    @Column(name="need_online_train")
    private Boolean needOnlineTrain;
    @Column(name="online_train")
    private Boolean onlineTrain;
    @Column(name="online_test")
    private Boolean onlineTest;
    @Column(name="train_materials_ids")
    private String trainMaterialsIds;
    @Column(name="exam_setup_id")
    private Long examSetupId;
    @Column(name="train_content")
    private String trainContent;
    @Column(name="key_person_status")
    private Byte keyPersonStatus;
    @Column(name="manage_person_status")
    private Byte managePersonStatus;
    @Transient
    private List<TrainBook> videos;
    @Transient
    private List<TrainAttend> attends;
    @Transient
    private String attendNames;
    @Transient
    private List<TrainPaperFile> signFiles;
    @Transient
    private List<TrainPaperFile> scoreFiles;
    @Transient
    private List<TrainPaperFile> medioFiles;
    @Transient
    private List<TrainPaperFile> otherFiles;
    @Transient
    private List<TrainPaperFile> books;
    @Transient
    private List<TrainPaperFile> exams;
    @Transient
    private List<TrainBook> trainBooks;
    @Transient
    private List<TrainExam> trainExams;
    @Transient
    private String typeName;
    @Transient
    private String attendDepts;
    @Transient
    private String fileName;
    @Transient
    private String statusName;
    @Transient
    private List<SysFileModel> btFiles;
    @Transient
    private List<String> trainTypes;
    @Transient
    private List<Long> coordDeptIds;
    @Transient
    private Integer year;
    @Transient
    private Integer trainNumber;
    @Transient
    private Integer noTrainNum;
    @Transient
    private Integer trainingNum;
    @Transient
    private Integer trainedNum;
    @Transient
    private Integer notTestCount;
    @Transient
    private Integer noPassCount;
    @Transient
    private Integer passCount;
    @Transient
    private Boolean isOverYear;
    @Transient
    private Integer thisYear;
    @Transient
    private String attendOrgNames;
    @Transient
    private Integer staffTestStatus;
    @Transient
    private Boolean isHasBack;
    @Transient
    private String hsTypeName;
    @Transient
    private String wayAndOnLine;
    @Transient
    private String[] colums;

    public void setHsTypeName(String hsType) {
        StringBuilder hsTypeName2 = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)hsType)) {
            List types = StringUtils.parseToIntegerList((String)hsType, (String)",");
            for (int i = 0; i < types.size(); ++i) {
                hsTypeName2.append(TrainHsTypeEnum.getName((Integer)types.get(i)));
                if (i >= types.size() - 1) continue;
                hsTypeName2.append(" | ");
            }
        }
        this.hsTypeName = hsTypeName2.toString();
    }

    public void setWayAndOnLine(Byte way, Byte onLine) {
        this.wayAndOnLine = TrainWayEnum.getName(way) + "\u3001" + TrainOnLineEnum.getName(onLine);
    }

    @Generated
    public TrainPlan() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCid() {
        return this.cid;
    }

    @Generated
    public String getNo() {
        return this.no;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHsType() {
        return this.hsType;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Byte getWay() {
        return this.way;
    }

    @Generated
    public Byte getOnLine() {
        return this.onLine;
    }

    @Generated
    public String getWayDesc() {
        return this.wayDesc;
    }

    @Generated
    public String getOrganizeDept() {
        return this.organizeDept;
    }

    @Generated
    public String getCoordinationDept() {
        return this.coordinationDept;
    }

    @Generated
    public Long getTeacher() {
        return this.teacher;
    }

    @Generated
    public String getTeacherName() {
        return this.teacherName;
    }

    @Generated
    public String getTeacherDept() {
        return this.teacherDept;
    }

    @Generated
    public String getClassCount() {
        return this.classCount;
    }

    @Generated
    public Date getRegisterTime() {
        return this.registerTime;
    }

    @Generated
    public Date getCreateDate() {
        return this.createDate;
    }

    @Generated
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Generated
    public Long getCreateBy() {
        return this.createBy;
    }

    @Generated
    public Long getUpdateBy() {
        return this.updateBy;
    }

    @Generated
    public Boolean getIsValid() {
        return this.isValid;
    }

    @Generated
    public Boolean getIsFinish() {
        return this.isFinish;
    }

    @Generated
    public Byte getStatus() {
        return this.status;
    }

    @Generated
    public String getTrainAttend() {
        return this.trainAttend;
    }

    @Generated
    public String getCreateName() {
        return this.createName;
    }

    @Generated
    public String getCompName() {
        return this.compName;
    }

    @Generated
    public Byte getFromType() {
        return this.fromType;
    }

    @Generated
    public Long getFromId() {
        return this.fromId;
    }

    @Generated
    public String getOrgId() {
        return this.orgId;
    }

    @Generated
    public Long getThirdOrgId() {
        return this.thirdOrgId;
    }

    @Generated
    public Byte getDataSource() {
        return this.dataSource;
    }

    @Generated
    public String getRegistrant() {
        return this.registrant;
    }

    @Generated
    public Long getReportId() {
        return this.reportId;
    }

    @Generated
    public Boolean getNeedOnlineTrain() {
        return this.needOnlineTrain;
    }

    @Generated
    public Boolean getOnlineTrain() {
        return this.onlineTrain;
    }

    @Generated
    public Boolean getOnlineTest() {
        return this.onlineTest;
    }

    @Generated
    public String getTrainMaterialsIds() {
        return this.trainMaterialsIds;
    }

    @Generated
    public Long getExamSetupId() {
        return this.examSetupId;
    }

    @Generated
    public String getTrainContent() {
        return this.trainContent;
    }

    @Generated
    public Byte getKeyPersonStatus() {
        return this.keyPersonStatus;
    }

    @Generated
    public Byte getManagePersonStatus() {
        return this.managePersonStatus;
    }

    @Generated
    public List<TrainBook> getVideos() {
        return this.videos;
    }

    @Generated
    public List<TrainAttend> getAttends() {
        return this.attends;
    }

    @Generated
    public String getAttendNames() {
        return this.attendNames;
    }

    @Generated
    public List<TrainPaperFile> getSignFiles() {
        return this.signFiles;
    }

    @Generated
    public List<TrainPaperFile> getScoreFiles() {
        return this.scoreFiles;
    }

    @Generated
    public List<TrainPaperFile> getMedioFiles() {
        return this.medioFiles;
    }

    @Generated
    public List<TrainPaperFile> getOtherFiles() {
        return this.otherFiles;
    }

    @Generated
    public List<TrainPaperFile> getBooks() {
        return this.books;
    }

    @Generated
    public List<TrainPaperFile> getExams() {
        return this.exams;
    }

    @Generated
    public List<TrainBook> getTrainBooks() {
        return this.trainBooks;
    }

    @Generated
    public List<TrainExam> getTrainExams() {
        return this.trainExams;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getAttendDepts() {
        return this.attendDepts;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getStatusName() {
        return this.statusName;
    }

    @Generated
    public List<SysFileModel> getBtFiles() {
        return this.btFiles;
    }

    @Generated
    public List<String> getTrainTypes() {
        return this.trainTypes;
    }

    @Generated
    public List<Long> getCoordDeptIds() {
        return this.coordDeptIds;
    }

    @Generated
    public Integer getYear() {
        return this.year;
    }

    @Generated
    public Integer getTrainNumber() {
        return this.trainNumber;
    }

    @Generated
    public Integer getNoTrainNum() {
        return this.noTrainNum;
    }

    @Generated
    public Integer getTrainingNum() {
        return this.trainingNum;
    }

    @Generated
    public Integer getTrainedNum() {
        return this.trainedNum;
    }

    @Generated
    public Integer getNotTestCount() {
        return this.notTestCount;
    }

    @Generated
    public Integer getNoPassCount() {
        return this.noPassCount;
    }

    @Generated
    public Integer getPassCount() {
        return this.passCount;
    }

    @Generated
    public Boolean getIsOverYear() {
        return this.isOverYear;
    }

    @Generated
    public Integer getThisYear() {
        return this.thisYear;
    }

    @Generated
    public String getAttendOrgNames() {
        return this.attendOrgNames;
    }

    @Generated
    public Integer getStaffTestStatus() {
        return this.staffTestStatus;
    }

    @Generated
    public Boolean getIsHasBack() {
        return this.isHasBack;
    }

    @Generated
    public String getHsTypeName() {
        return this.hsTypeName;
    }

    @Generated
    public String getWayAndOnLine() {
        return this.wayAndOnLine;
    }

    @Generated
    public String[] getColums() {
        return this.colums;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCid(Long cid) {
        this.cid = cid;
    }

    @Generated
    public void setNo(String no) {
        this.no = no;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setHsType(String hsType) {
        this.hsType = hsType;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setWay(Byte way) {
        this.way = way;
    }

    @Generated
    public void setOnLine(Byte onLine) {
        this.onLine = onLine;
    }

    @Generated
    public void setWayDesc(String wayDesc) {
        this.wayDesc = wayDesc;
    }

    @Generated
    public void setOrganizeDept(String organizeDept) {
        this.organizeDept = organizeDept;
    }

    @Generated
    public void setCoordinationDept(String coordinationDept) {
        this.coordinationDept = coordinationDept;
    }

    @Generated
    public void setTeacher(Long teacher) {
        this.teacher = teacher;
    }

    @Generated
    public void setTeacherName(String teacherName) {
        this.teacherName = teacherName;
    }

    @Generated
    public void setTeacherDept(String teacherDept) {
        this.teacherDept = teacherDept;
    }

    @Generated
    public void setClassCount(String classCount) {
        this.classCount = classCount;
    }

    @Generated
    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    @Generated
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Generated
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Generated
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Generated
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Generated
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    @Generated
    public void setIsFinish(Boolean isFinish) {
        this.isFinish = isFinish;
    }

    @Generated
    public void setStatus(Byte status) {
        this.status = status;
    }

    @Generated
    public void setTrainAttend(String trainAttend) {
        this.trainAttend = trainAttend;
    }

    @Generated
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    @Generated
    public void setCompName(String compName) {
        this.compName = compName;
    }

    @Generated
    public void setFromType(Byte fromType) {
        this.fromType = fromType;
    }

    @Generated
    public void setFromId(Long fromId) {
        this.fromId = fromId;
    }

    @Generated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Generated
    public void setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
    }

    @Generated
    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    @Generated
    public void setRegistrant(String registrant) {
        this.registrant = registrant;
    }

    @Generated
    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    @Generated
    public void setNeedOnlineTrain(Boolean needOnlineTrain) {
        this.needOnlineTrain = needOnlineTrain;
    }

    @Generated
    public void setOnlineTrain(Boolean onlineTrain) {
        this.onlineTrain = onlineTrain;
    }

    @Generated
    public void setOnlineTest(Boolean onlineTest) {
        this.onlineTest = onlineTest;
    }

    @Generated
    public void setTrainMaterialsIds(String trainMaterialsIds) {
        this.trainMaterialsIds = trainMaterialsIds;
    }

    @Generated
    public void setExamSetupId(Long examSetupId) {
        this.examSetupId = examSetupId;
    }

    @Generated
    public void setTrainContent(String trainContent) {
        this.trainContent = trainContent;
    }

    @Generated
    public void setKeyPersonStatus(Byte keyPersonStatus) {
        this.keyPersonStatus = keyPersonStatus;
    }

    @Generated
    public void setManagePersonStatus(Byte managePersonStatus) {
        this.managePersonStatus = managePersonStatus;
    }

    @Generated
    public void setVideos(List<TrainBook> videos) {
        this.videos = videos;
    }

    @Generated
    public void setAttends(List<TrainAttend> attends) {
        this.attends = attends;
    }

    @Generated
    public void setAttendNames(String attendNames) {
        this.attendNames = attendNames;
    }

    @Generated
    public void setSignFiles(List<TrainPaperFile> signFiles) {
        this.signFiles = signFiles;
    }

    @Generated
    public void setScoreFiles(List<TrainPaperFile> scoreFiles) {
        this.scoreFiles = scoreFiles;
    }

    @Generated
    public void setMedioFiles(List<TrainPaperFile> medioFiles) {
        this.medioFiles = medioFiles;
    }

    @Generated
    public void setOtherFiles(List<TrainPaperFile> otherFiles) {
        this.otherFiles = otherFiles;
    }

    @Generated
    public void setBooks(List<TrainPaperFile> books) {
        this.books = books;
    }

    @Generated
    public void setExams(List<TrainPaperFile> exams) {
        this.exams = exams;
    }

    @Generated
    public void setTrainBooks(List<TrainBook> trainBooks) {
        this.trainBooks = trainBooks;
    }

    @Generated
    public void setTrainExams(List<TrainExam> trainExams) {
        this.trainExams = trainExams;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setAttendDepts(String attendDepts) {
        this.attendDepts = attendDepts;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    @Generated
    public void setBtFiles(List<SysFileModel> btFiles) {
        this.btFiles = btFiles;
    }

    @Generated
    public void setTrainTypes(List<String> trainTypes) {
        this.trainTypes = trainTypes;
    }

    @Generated
    public void setCoordDeptIds(List<Long> coordDeptIds) {
        this.coordDeptIds = coordDeptIds;
    }

    @Generated
    public void setYear(Integer year) {
        this.year = year;
    }

    @Generated
    public void setTrainNumber(Integer trainNumber) {
        this.trainNumber = trainNumber;
    }

    @Generated
    public void setNoTrainNum(Integer noTrainNum) {
        this.noTrainNum = noTrainNum;
    }

    @Generated
    public void setTrainingNum(Integer trainingNum) {
        this.trainingNum = trainingNum;
    }

    @Generated
    public void setTrainedNum(Integer trainedNum) {
        this.trainedNum = trainedNum;
    }

    @Generated
    public void setNotTestCount(Integer notTestCount) {
        this.notTestCount = notTestCount;
    }

    @Generated
    public void setNoPassCount(Integer noPassCount) {
        this.noPassCount = noPassCount;
    }

    @Generated
    public void setPassCount(Integer passCount) {
        this.passCount = passCount;
    }

    @Generated
    public void setIsOverYear(Boolean isOverYear) {
        this.isOverYear = isOverYear;
    }

    @Generated
    public void setThisYear(Integer thisYear) {
        this.thisYear = thisYear;
    }

    @Generated
    public void setAttendOrgNames(String attendOrgNames) {
        this.attendOrgNames = attendOrgNames;
    }

    @Generated
    public void setStaffTestStatus(Integer staffTestStatus) {
        this.staffTestStatus = staffTestStatus;
    }

    @Generated
    public void setIsHasBack(Boolean isHasBack) {
        this.isHasBack = isHasBack;
    }

    @Generated
    public void setWayAndOnLine(String wayAndOnLine) {
        this.wayAndOnLine = wayAndOnLine;
    }

    @Generated
    public void setColums(String[] colums) {
        this.colums = colums;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrainPlan)) {
            return false;
        }
        TrainPlan other = (TrainPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$cid = this.getCid();
        Long other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !((Object)this$cid).equals(other$cid)) {
            return false;
        }
        Byte this$way = this.getWay();
        Byte other$way = other.getWay();
        if (this$way == null ? other$way != null : !((Object)this$way).equals(other$way)) {
            return false;
        }
        Byte this$onLine = this.getOnLine();
        Byte other$onLine = other.getOnLine();
        if (this$onLine == null ? other$onLine != null : !((Object)this$onLine).equals(other$onLine)) {
            return false;
        }
        Long this$teacher = this.getTeacher();
        Long other$teacher = other.getTeacher();
        if (this$teacher == null ? other$teacher != null : !((Object)this$teacher).equals(other$teacher)) {
            return false;
        }
        Long this$createBy = this.getCreateBy();
        Long other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !((Object)this$createBy).equals(other$createBy)) {
            return false;
        }
        Long this$updateBy = this.getUpdateBy();
        Long other$updateBy = other.getUpdateBy();
        if (this$updateBy == null ? other$updateBy != null : !((Object)this$updateBy).equals(other$updateBy)) {
            return false;
        }
        Boolean this$isValid = this.getIsValid();
        Boolean other$isValid = other.getIsValid();
        if (this$isValid == null ? other$isValid != null : !((Object)this$isValid).equals(other$isValid)) {
            return false;
        }
        Boolean this$isFinish = this.getIsFinish();
        Boolean other$isFinish = other.getIsFinish();
        if (this$isFinish == null ? other$isFinish != null : !((Object)this$isFinish).equals(other$isFinish)) {
            return false;
        }
        Byte this$status = this.getStatus();
        Byte other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Byte this$fromType = this.getFromType();
        Byte other$fromType = other.getFromType();
        if (this$fromType == null ? other$fromType != null : !((Object)this$fromType).equals(other$fromType)) {
            return false;
        }
        Long this$fromId = this.getFromId();
        Long other$fromId = other.getFromId();
        if (this$fromId == null ? other$fromId != null : !((Object)this$fromId).equals(other$fromId)) {
            return false;
        }
        Long this$thirdOrgId = this.getThirdOrgId();
        Long other$thirdOrgId = other.getThirdOrgId();
        if (this$thirdOrgId == null ? other$thirdOrgId != null : !((Object)this$thirdOrgId).equals(other$thirdOrgId)) {
            return false;
        }
        Byte this$dataSource = this.getDataSource();
        Byte other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        Long this$reportId = this.getReportId();
        Long other$reportId = other.getReportId();
        if (this$reportId == null ? other$reportId != null : !((Object)this$reportId).equals(other$reportId)) {
            return false;
        }
        Boolean this$needOnlineTrain = this.getNeedOnlineTrain();
        Boolean other$needOnlineTrain = other.getNeedOnlineTrain();
        if (this$needOnlineTrain == null ? other$needOnlineTrain != null : !((Object)this$needOnlineTrain).equals(other$needOnlineTrain)) {
            return false;
        }
        Boolean this$onlineTrain = this.getOnlineTrain();
        Boolean other$onlineTrain = other.getOnlineTrain();
        if (this$onlineTrain == null ? other$onlineTrain != null : !((Object)this$onlineTrain).equals(other$onlineTrain)) {
            return false;
        }
        Boolean this$onlineTest = this.getOnlineTest();
        Boolean other$onlineTest = other.getOnlineTest();
        if (this$onlineTest == null ? other$onlineTest != null : !((Object)this$onlineTest).equals(other$onlineTest)) {
            return false;
        }
        Long this$examSetupId = this.getExamSetupId();
        Long other$examSetupId = other.getExamSetupId();
        if (this$examSetupId == null ? other$examSetupId != null : !((Object)this$examSetupId).equals(other$examSetupId)) {
            return false;
        }
        Byte this$keyPersonStatus = this.getKeyPersonStatus();
        Byte other$keyPersonStatus = other.getKeyPersonStatus();
        if (this$keyPersonStatus == null ? other$keyPersonStatus != null : !((Object)this$keyPersonStatus).equals(other$keyPersonStatus)) {
            return false;
        }
        Byte this$managePersonStatus = this.getManagePersonStatus();
        Byte other$managePersonStatus = other.getManagePersonStatus();
        if (this$managePersonStatus == null ? other$managePersonStatus != null : !((Object)this$managePersonStatus).equals(other$managePersonStatus)) {
            return false;
        }
        Integer this$year = this.getYear();
        Integer other$year = other.getYear();
        if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
            return false;
        }
        Integer this$trainNumber = this.getTrainNumber();
        Integer other$trainNumber = other.getTrainNumber();
        if (this$trainNumber == null ? other$trainNumber != null : !((Object)this$trainNumber).equals(other$trainNumber)) {
            return false;
        }
        Integer this$noTrainNum = this.getNoTrainNum();
        Integer other$noTrainNum = other.getNoTrainNum();
        if (this$noTrainNum == null ? other$noTrainNum != null : !((Object)this$noTrainNum).equals(other$noTrainNum)) {
            return false;
        }
        Integer this$trainingNum = this.getTrainingNum();
        Integer other$trainingNum = other.getTrainingNum();
        if (this$trainingNum == null ? other$trainingNum != null : !((Object)this$trainingNum).equals(other$trainingNum)) {
            return false;
        }
        Integer this$trainedNum = this.getTrainedNum();
        Integer other$trainedNum = other.getTrainedNum();
        if (this$trainedNum == null ? other$trainedNum != null : !((Object)this$trainedNum).equals(other$trainedNum)) {
            return false;
        }
        Integer this$notTestCount = this.getNotTestCount();
        Integer other$notTestCount = other.getNotTestCount();
        if (this$notTestCount == null ? other$notTestCount != null : !((Object)this$notTestCount).equals(other$notTestCount)) {
            return false;
        }
        Integer this$noPassCount = this.getNoPassCount();
        Integer other$noPassCount = other.getNoPassCount();
        if (this$noPassCount == null ? other$noPassCount != null : !((Object)this$noPassCount).equals(other$noPassCount)) {
            return false;
        }
        Integer this$passCount = this.getPassCount();
        Integer other$passCount = other.getPassCount();
        if (this$passCount == null ? other$passCount != null : !((Object)this$passCount).equals(other$passCount)) {
            return false;
        }
        Boolean this$isOverYear = this.getIsOverYear();
        Boolean other$isOverYear = other.getIsOverYear();
        if (this$isOverYear == null ? other$isOverYear != null : !((Object)this$isOverYear).equals(other$isOverYear)) {
            return false;
        }
        Integer this$thisYear = this.getThisYear();
        Integer other$thisYear = other.getThisYear();
        if (this$thisYear == null ? other$thisYear != null : !((Object)this$thisYear).equals(other$thisYear)) {
            return false;
        }
        Integer this$staffTestStatus = this.getStaffTestStatus();
        Integer other$staffTestStatus = other.getStaffTestStatus();
        if (this$staffTestStatus == null ? other$staffTestStatus != null : !((Object)this$staffTestStatus).equals(other$staffTestStatus)) {
            return false;
        }
        Boolean this$isHasBack = this.getIsHasBack();
        Boolean other$isHasBack = other.getIsHasBack();
        if (this$isHasBack == null ? other$isHasBack != null : !((Object)this$isHasBack).equals(other$isHasBack)) {
            return false;
        }
        String this$no = this.getNo();
        String other$no = other.getNo();
        if (this$no == null ? other$no != null : !this$no.equals(other$no)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$hsType = this.getHsType();
        String other$hsType = other.getHsType();
        if (this$hsType == null ? other$hsType != null : !this$hsType.equals(other$hsType)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$wayDesc = this.getWayDesc();
        String other$wayDesc = other.getWayDesc();
        if (this$wayDesc == null ? other$wayDesc != null : !this$wayDesc.equals(other$wayDesc)) {
            return false;
        }
        String this$organizeDept = this.getOrganizeDept();
        String other$organizeDept = other.getOrganizeDept();
        if (this$organizeDept == null ? other$organizeDept != null : !this$organizeDept.equals(other$organizeDept)) {
            return false;
        }
        String this$coordinationDept = this.getCoordinationDept();
        String other$coordinationDept = other.getCoordinationDept();
        if (this$coordinationDept == null ? other$coordinationDept != null : !this$coordinationDept.equals(other$coordinationDept)) {
            return false;
        }
        String this$teacherName = this.getTeacherName();
        String other$teacherName = other.getTeacherName();
        if (this$teacherName == null ? other$teacherName != null : !this$teacherName.equals(other$teacherName)) {
            return false;
        }
        String this$teacherDept = this.getTeacherDept();
        String other$teacherDept = other.getTeacherDept();
        if (this$teacherDept == null ? other$teacherDept != null : !this$teacherDept.equals(other$teacherDept)) {
            return false;
        }
        String this$classCount = this.getClassCount();
        String other$classCount = other.getClassCount();
        if (this$classCount == null ? other$classCount != null : !this$classCount.equals(other$classCount)) {
            return false;
        }
        Date this$registerTime = this.getRegisterTime();
        Date other$registerTime = other.getRegisterTime();
        if (this$registerTime == null ? other$registerTime != null : !((Object)this$registerTime).equals(other$registerTime)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Date this$updateDate = this.getUpdateDate();
        Date other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$trainAttend = this.getTrainAttend();
        String other$trainAttend = other.getTrainAttend();
        if (this$trainAttend == null ? other$trainAttend != null : !this$trainAttend.equals(other$trainAttend)) {
            return false;
        }
        String this$createName = this.getCreateName();
        String other$createName = other.getCreateName();
        if (this$createName == null ? other$createName != null : !this$createName.equals(other$createName)) {
            return false;
        }
        String this$compName = this.getCompName();
        String other$compName = other.getCompName();
        if (this$compName == null ? other$compName != null : !this$compName.equals(other$compName)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$registrant = this.getRegistrant();
        String other$registrant = other.getRegistrant();
        if (this$registrant == null ? other$registrant != null : !this$registrant.equals(other$registrant)) {
            return false;
        }
        String this$trainMaterialsIds = this.getTrainMaterialsIds();
        String other$trainMaterialsIds = other.getTrainMaterialsIds();
        if (this$trainMaterialsIds == null ? other$trainMaterialsIds != null : !this$trainMaterialsIds.equals(other$trainMaterialsIds)) {
            return false;
        }
        String this$trainContent = this.getTrainContent();
        String other$trainContent = other.getTrainContent();
        if (this$trainContent == null ? other$trainContent != null : !this$trainContent.equals(other$trainContent)) {
            return false;
        }
        List<TrainBook> this$videos = this.getVideos();
        List<TrainBook> other$videos = other.getVideos();
        if (this$videos == null ? other$videos != null : !((Object)this$videos).equals(other$videos)) {
            return false;
        }
        List<TrainAttend> this$attends = this.getAttends();
        List<TrainAttend> other$attends = other.getAttends();
        if (this$attends == null ? other$attends != null : !((Object)this$attends).equals(other$attends)) {
            return false;
        }
        String this$attendNames = this.getAttendNames();
        String other$attendNames = other.getAttendNames();
        if (this$attendNames == null ? other$attendNames != null : !this$attendNames.equals(other$attendNames)) {
            return false;
        }
        List<TrainPaperFile> this$signFiles = this.getSignFiles();
        List<TrainPaperFile> other$signFiles = other.getSignFiles();
        if (this$signFiles == null ? other$signFiles != null : !((Object)this$signFiles).equals(other$signFiles)) {
            return false;
        }
        List<TrainPaperFile> this$scoreFiles = this.getScoreFiles();
        List<TrainPaperFile> other$scoreFiles = other.getScoreFiles();
        if (this$scoreFiles == null ? other$scoreFiles != null : !((Object)this$scoreFiles).equals(other$scoreFiles)) {
            return false;
        }
        List<TrainPaperFile> this$medioFiles = this.getMedioFiles();
        List<TrainPaperFile> other$medioFiles = other.getMedioFiles();
        if (this$medioFiles == null ? other$medioFiles != null : !((Object)this$medioFiles).equals(other$medioFiles)) {
            return false;
        }
        List<TrainPaperFile> this$otherFiles = this.getOtherFiles();
        List<TrainPaperFile> other$otherFiles = other.getOtherFiles();
        if (this$otherFiles == null ? other$otherFiles != null : !((Object)this$otherFiles).equals(other$otherFiles)) {
            return false;
        }
        List<TrainPaperFile> this$books = this.getBooks();
        List<TrainPaperFile> other$books = other.getBooks();
        if (this$books == null ? other$books != null : !((Object)this$books).equals(other$books)) {
            return false;
        }
        List<TrainPaperFile> this$exams = this.getExams();
        List<TrainPaperFile> other$exams = other.getExams();
        if (this$exams == null ? other$exams != null : !((Object)this$exams).equals(other$exams)) {
            return false;
        }
        List<TrainBook> this$trainBooks = this.getTrainBooks();
        List<TrainBook> other$trainBooks = other.getTrainBooks();
        if (this$trainBooks == null ? other$trainBooks != null : !((Object)this$trainBooks).equals(other$trainBooks)) {
            return false;
        }
        List<TrainExam> this$trainExams = this.getTrainExams();
        List<TrainExam> other$trainExams = other.getTrainExams();
        if (this$trainExams == null ? other$trainExams != null : !((Object)this$trainExams).equals(other$trainExams)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$attendDepts = this.getAttendDepts();
        String other$attendDepts = other.getAttendDepts();
        if (this$attendDepts == null ? other$attendDepts != null : !this$attendDepts.equals(other$attendDepts)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$statusName = this.getStatusName();
        String other$statusName = other.getStatusName();
        if (this$statusName == null ? other$statusName != null : !this$statusName.equals(other$statusName)) {
            return false;
        }
        List<SysFileModel> this$btFiles = this.getBtFiles();
        List<SysFileModel> other$btFiles = other.getBtFiles();
        if (this$btFiles == null ? other$btFiles != null : !((Object)this$btFiles).equals(other$btFiles)) {
            return false;
        }
        List<String> this$trainTypes = this.getTrainTypes();
        List<String> other$trainTypes = other.getTrainTypes();
        if (this$trainTypes == null ? other$trainTypes != null : !((Object)this$trainTypes).equals(other$trainTypes)) {
            return false;
        }
        List<Long> this$coordDeptIds = this.getCoordDeptIds();
        List<Long> other$coordDeptIds = other.getCoordDeptIds();
        if (this$coordDeptIds == null ? other$coordDeptIds != null : !((Object)this$coordDeptIds).equals(other$coordDeptIds)) {
            return false;
        }
        String this$attendOrgNames = this.getAttendOrgNames();
        String other$attendOrgNames = other.getAttendOrgNames();
        if (this$attendOrgNames == null ? other$attendOrgNames != null : !this$attendOrgNames.equals(other$attendOrgNames)) {
            return false;
        }
        String this$hsTypeName = this.getHsTypeName();
        String other$hsTypeName = other.getHsTypeName();
        if (this$hsTypeName == null ? other$hsTypeName != null : !this$hsTypeName.equals(other$hsTypeName)) {
            return false;
        }
        String this$wayAndOnLine = this.getWayAndOnLine();
        String other$wayAndOnLine = other.getWayAndOnLine();
        if (this$wayAndOnLine == null ? other$wayAndOnLine != null : !this$wayAndOnLine.equals(other$wayAndOnLine)) {
            return false;
        }
        return Arrays.deepEquals(this.getColums(), other.getColums());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrainPlan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : ((Object)$cid).hashCode());
        Byte $way = this.getWay();
        result = result * 59 + ($way == null ? 43 : ((Object)$way).hashCode());
        Byte $onLine = this.getOnLine();
        result = result * 59 + ($onLine == null ? 43 : ((Object)$onLine).hashCode());
        Long $teacher = this.getTeacher();
        result = result * 59 + ($teacher == null ? 43 : ((Object)$teacher).hashCode());
        Long $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : ((Object)$createBy).hashCode());
        Long $updateBy = this.getUpdateBy();
        result = result * 59 + ($updateBy == null ? 43 : ((Object)$updateBy).hashCode());
        Boolean $isValid = this.getIsValid();
        result = result * 59 + ($isValid == null ? 43 : ((Object)$isValid).hashCode());
        Boolean $isFinish = this.getIsFinish();
        result = result * 59 + ($isFinish == null ? 43 : ((Object)$isFinish).hashCode());
        Byte $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Byte $fromType = this.getFromType();
        result = result * 59 + ($fromType == null ? 43 : ((Object)$fromType).hashCode());
        Long $fromId = this.getFromId();
        result = result * 59 + ($fromId == null ? 43 : ((Object)$fromId).hashCode());
        Long $thirdOrgId = this.getThirdOrgId();
        result = result * 59 + ($thirdOrgId == null ? 43 : ((Object)$thirdOrgId).hashCode());
        Byte $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        Long $reportId = this.getReportId();
        result = result * 59 + ($reportId == null ? 43 : ((Object)$reportId).hashCode());
        Boolean $needOnlineTrain = this.getNeedOnlineTrain();
        result = result * 59 + ($needOnlineTrain == null ? 43 : ((Object)$needOnlineTrain).hashCode());
        Boolean $onlineTrain = this.getOnlineTrain();
        result = result * 59 + ($onlineTrain == null ? 43 : ((Object)$onlineTrain).hashCode());
        Boolean $onlineTest = this.getOnlineTest();
        result = result * 59 + ($onlineTest == null ? 43 : ((Object)$onlineTest).hashCode());
        Long $examSetupId = this.getExamSetupId();
        result = result * 59 + ($examSetupId == null ? 43 : ((Object)$examSetupId).hashCode());
        Byte $keyPersonStatus = this.getKeyPersonStatus();
        result = result * 59 + ($keyPersonStatus == null ? 43 : ((Object)$keyPersonStatus).hashCode());
        Byte $managePersonStatus = this.getManagePersonStatus();
        result = result * 59 + ($managePersonStatus == null ? 43 : ((Object)$managePersonStatus).hashCode());
        Integer $year = this.getYear();
        result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
        Integer $trainNumber = this.getTrainNumber();
        result = result * 59 + ($trainNumber == null ? 43 : ((Object)$trainNumber).hashCode());
        Integer $noTrainNum = this.getNoTrainNum();
        result = result * 59 + ($noTrainNum == null ? 43 : ((Object)$noTrainNum).hashCode());
        Integer $trainingNum = this.getTrainingNum();
        result = result * 59 + ($trainingNum == null ? 43 : ((Object)$trainingNum).hashCode());
        Integer $trainedNum = this.getTrainedNum();
        result = result * 59 + ($trainedNum == null ? 43 : ((Object)$trainedNum).hashCode());
        Integer $notTestCount = this.getNotTestCount();
        result = result * 59 + ($notTestCount == null ? 43 : ((Object)$notTestCount).hashCode());
        Integer $noPassCount = this.getNoPassCount();
        result = result * 59 + ($noPassCount == null ? 43 : ((Object)$noPassCount).hashCode());
        Integer $passCount = this.getPassCount();
        result = result * 59 + ($passCount == null ? 43 : ((Object)$passCount).hashCode());
        Boolean $isOverYear = this.getIsOverYear();
        result = result * 59 + ($isOverYear == null ? 43 : ((Object)$isOverYear).hashCode());
        Integer $thisYear = this.getThisYear();
        result = result * 59 + ($thisYear == null ? 43 : ((Object)$thisYear).hashCode());
        Integer $staffTestStatus = this.getStaffTestStatus();
        result = result * 59 + ($staffTestStatus == null ? 43 : ((Object)$staffTestStatus).hashCode());
        Boolean $isHasBack = this.getIsHasBack();
        result = result * 59 + ($isHasBack == null ? 43 : ((Object)$isHasBack).hashCode());
        String $no = this.getNo();
        result = result * 59 + ($no == null ? 43 : $no.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $hsType = this.getHsType();
        result = result * 59 + ($hsType == null ? 43 : $hsType.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $wayDesc = this.getWayDesc();
        result = result * 59 + ($wayDesc == null ? 43 : $wayDesc.hashCode());
        String $organizeDept = this.getOrganizeDept();
        result = result * 59 + ($organizeDept == null ? 43 : $organizeDept.hashCode());
        String $coordinationDept = this.getCoordinationDept();
        result = result * 59 + ($coordinationDept == null ? 43 : $coordinationDept.hashCode());
        String $teacherName = this.getTeacherName();
        result = result * 59 + ($teacherName == null ? 43 : $teacherName.hashCode());
        String $teacherDept = this.getTeacherDept();
        result = result * 59 + ($teacherDept == null ? 43 : $teacherDept.hashCode());
        String $classCount = this.getClassCount();
        result = result * 59 + ($classCount == null ? 43 : $classCount.hashCode());
        Date $registerTime = this.getRegisterTime();
        result = result * 59 + ($registerTime == null ? 43 : ((Object)$registerTime).hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        Date $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $trainAttend = this.getTrainAttend();
        result = result * 59 + ($trainAttend == null ? 43 : $trainAttend.hashCode());
        String $createName = this.getCreateName();
        result = result * 59 + ($createName == null ? 43 : $createName.hashCode());
        String $compName = this.getCompName();
        result = result * 59 + ($compName == null ? 43 : $compName.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $registrant = this.getRegistrant();
        result = result * 59 + ($registrant == null ? 43 : $registrant.hashCode());
        String $trainMaterialsIds = this.getTrainMaterialsIds();
        result = result * 59 + ($trainMaterialsIds == null ? 43 : $trainMaterialsIds.hashCode());
        String $trainContent = this.getTrainContent();
        result = result * 59 + ($trainContent == null ? 43 : $trainContent.hashCode());
        List<TrainBook> $videos = this.getVideos();
        result = result * 59 + ($videos == null ? 43 : ((Object)$videos).hashCode());
        List<TrainAttend> $attends = this.getAttends();
        result = result * 59 + ($attends == null ? 43 : ((Object)$attends).hashCode());
        String $attendNames = this.getAttendNames();
        result = result * 59 + ($attendNames == null ? 43 : $attendNames.hashCode());
        List<TrainPaperFile> $signFiles = this.getSignFiles();
        result = result * 59 + ($signFiles == null ? 43 : ((Object)$signFiles).hashCode());
        List<TrainPaperFile> $scoreFiles = this.getScoreFiles();
        result = result * 59 + ($scoreFiles == null ? 43 : ((Object)$scoreFiles).hashCode());
        List<TrainPaperFile> $medioFiles = this.getMedioFiles();
        result = result * 59 + ($medioFiles == null ? 43 : ((Object)$medioFiles).hashCode());
        List<TrainPaperFile> $otherFiles = this.getOtherFiles();
        result = result * 59 + ($otherFiles == null ? 43 : ((Object)$otherFiles).hashCode());
        List<TrainPaperFile> $books = this.getBooks();
        result = result * 59 + ($books == null ? 43 : ((Object)$books).hashCode());
        List<TrainPaperFile> $exams = this.getExams();
        result = result * 59 + ($exams == null ? 43 : ((Object)$exams).hashCode());
        List<TrainBook> $trainBooks = this.getTrainBooks();
        result = result * 59 + ($trainBooks == null ? 43 : ((Object)$trainBooks).hashCode());
        List<TrainExam> $trainExams = this.getTrainExams();
        result = result * 59 + ($trainExams == null ? 43 : ((Object)$trainExams).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $attendDepts = this.getAttendDepts();
        result = result * 59 + ($attendDepts == null ? 43 : $attendDepts.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $statusName = this.getStatusName();
        result = result * 59 + ($statusName == null ? 43 : $statusName.hashCode());
        List<SysFileModel> $btFiles = this.getBtFiles();
        result = result * 59 + ($btFiles == null ? 43 : ((Object)$btFiles).hashCode());
        List<String> $trainTypes = this.getTrainTypes();
        result = result * 59 + ($trainTypes == null ? 43 : ((Object)$trainTypes).hashCode());
        List<Long> $coordDeptIds = this.getCoordDeptIds();
        result = result * 59 + ($coordDeptIds == null ? 43 : ((Object)$coordDeptIds).hashCode());
        String $attendOrgNames = this.getAttendOrgNames();
        result = result * 59 + ($attendOrgNames == null ? 43 : $attendOrgNames.hashCode());
        String $hsTypeName = this.getHsTypeName();
        result = result * 59 + ($hsTypeName == null ? 43 : $hsTypeName.hashCode());
        String $wayAndOnLine = this.getWayAndOnLine();
        result = result * 59 + ($wayAndOnLine == null ? 43 : $wayAndOnLine.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColums());
        return result;
    }

    @Generated
    public String toString() {
        return "TrainPlan(id=" + this.getId() + ", cid=" + this.getCid() + ", no=" + this.getNo() + ", name=" + this.getName() + ", hsType=" + this.getHsType() + ", type=" + this.getType() + ", way=" + this.getWay() + ", onLine=" + this.getOnLine() + ", wayDesc=" + this.getWayDesc() + ", organizeDept=" + this.getOrganizeDept() + ", coordinationDept=" + this.getCoordinationDept() + ", teacher=" + this.getTeacher() + ", teacherName=" + this.getTeacherName() + ", teacherDept=" + this.getTeacherDept() + ", classCount=" + this.getClassCount() + ", registerTime=" + String.valueOf(this.getRegisterTime()) + ", createDate=" + String.valueOf(this.getCreateDate()) + ", updateDate=" + String.valueOf(this.getUpdateDate()) + ", createBy=" + this.getCreateBy() + ", updateBy=" + this.getUpdateBy() + ", isValid=" + this.getIsValid() + ", isFinish=" + this.getIsFinish() + ", status=" + this.getStatus() + ", trainAttend=" + this.getTrainAttend() + ", createName=" + this.getCreateName() + ", compName=" + this.getCompName() + ", fromType=" + this.getFromType() + ", fromId=" + this.getFromId() + ", orgId=" + this.getOrgId() + ", thirdOrgId=" + this.getThirdOrgId() + ", dataSource=" + this.getDataSource() + ", registrant=" + this.getRegistrant() + ", reportId=" + this.getReportId() + ", needOnlineTrain=" + this.getNeedOnlineTrain() + ", onlineTrain=" + this.getOnlineTrain() + ", onlineTest=" + this.getOnlineTest() + ", trainMaterialsIds=" + this.getTrainMaterialsIds() + ", examSetupId=" + this.getExamSetupId() + ", trainContent=" + this.getTrainContent() + ", keyPersonStatus=" + this.getKeyPersonStatus() + ", managePersonStatus=" + this.getManagePersonStatus() + ", videos=" + String.valueOf(this.getVideos()) + ", attends=" + String.valueOf(this.getAttends()) + ", attendNames=" + this.getAttendNames() + ", signFiles=" + String.valueOf(this.getSignFiles()) + ", scoreFiles=" + String.valueOf(this.getScoreFiles()) + ", medioFiles=" + String.valueOf(this.getMedioFiles()) + ", otherFiles=" + String.valueOf(this.getOtherFiles()) + ", books=" + String.valueOf(this.getBooks()) + ", exams=" + String.valueOf(this.getExams()) + ", trainBooks=" + String.valueOf(this.getTrainBooks()) + ", trainExams=" + String.valueOf(this.getTrainExams()) + ", typeName=" + this.getTypeName() + ", attendDepts=" + this.getAttendDepts() + ", fileName=" + this.getFileName() + ", statusName=" + this.getStatusName() + ", btFiles=" + String.valueOf(this.getBtFiles()) + ", trainTypes=" + String.valueOf(this.getTrainTypes()) + ", coordDeptIds=" + String.valueOf(this.getCoordDeptIds()) + ", year=" + this.getYear() + ", trainNumber=" + this.getTrainNumber() + ", noTrainNum=" + this.getNoTrainNum() + ", trainingNum=" + this.getTrainingNum() + ", trainedNum=" + this.getTrainedNum() + ", notTestCount=" + this.getNotTestCount() + ", noPassCount=" + this.getNoPassCount() + ", passCount=" + this.getPassCount() + ", isOverYear=" + this.getIsOverYear() + ", thisYear=" + this.getThisYear() + ", attendOrgNames=" + this.getAttendOrgNames() + ", staffTestStatus=" + this.getStaffTestStatus() + ", isHasBack=" + this.getIsHasBack() + ", hsTypeName=" + this.getHsTypeName() + ", wayAndOnLine=" + this.getWayAndOnLine() + ", colums=" + Arrays.deepToString(this.getColums()) + ")";
    }
}

