/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.entity.work.reform;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;

public class ReformItemSource
implements Serializable {
    private static final long serialVersionUID = -41409671529980941L;
    @Id
    @Column(name="id")
    private Long id;
    @Column(name="reform_item_id")
    private Long reformItemId;
    @Column(name="cid")
    private Long cid;
    @Column(name="third_org_id")
    private Long thirdOrgId;
    @Column(name="finder_name")
    @Desensitization(type=DesensitizationType.NAME)
    private String finderName;
    @Transient
    private boolean isSysFinder;
    @Transient
    private String sysFinderName;
    @Column(name="find_time")
    private Date findTime;
    @Column(name="find_time_year")
    private Integer findTimeYear;
    @Column(name="name")
    private String name;
    @Column(name="reform_item_source")
    private Byte reformItemSource;
    @Column(name="reform_item_source_id")
    private Long reformItemSourceId;
    @Column(name="tj_business_id")
    private String tjBusinessId;
    @Column(name="generation_source")
    private Byte generationSource;
    @Column(name="reform_item_source_type")
    private Byte reformItemSourceType;
    @Column(name="description")
    private String description;
    @Column(name="reform_item_files")
    private String reformItemFiles;
    @Column(name="require_acceptance_time")
    private Date requireAcceptanceTime;
    @Column(name="status")
    private Byte status;
    @Column(name="law_status")
    private Byte lawStatus;
    @Column(name="area_id")
    private Long areaId;
    @Column(name="area_id1")
    private Long areaId1;
    @Column(name="area_id2")
    private Long areaId2;
    @Column(name="area_id3")
    private Long areaId3;
    @Column(name="area_id4")
    private Long areaId4;
    @Column(name="actual_finish_time")
    private Date actualFinishTime;
    @Column(name="reform_director_name")
    @Desensitization(type=DesensitizationType.NAME)
    private String reformDirectorName;
    @Column(name="acceptance_date")
    private Date acceptanceDate;
    @Column(name="acceptance_director_name")
    @Desensitization(type=DesensitizationType.NAME)
    private String acceptanceDirectorName;
    @Column(name="data_source")
    private Byte dataSource;
    @Column(name="batch_num")
    private Integer batchNum = 1;
    @Column(name="is_show_in_reform_modular")
    private Boolean isShowInReformModular = true;
    @Column(name="create_by")
    private Long createBy;
    @Column(name="create_date")
    private Date createDate;
    @Column(name="update_by")
    private Long updateBy;
    @Column(name="update_date")
    private Date updateDate;
    @Column(name="is_valid")
    private Boolean isValid;
    @Transient
    private Integer workYear;
    @Transient
    private String outpackName;
    @Transient
    private LocalDate remindDate;
    @Transient
    private String companyName;
    @Transient
    private Integer companyRadioactivityType;
    @Transient
    private ReformItemAcceptanceRecord acceptance;
    @Transient
    private List<ReformItemAcceptanceRecord> aceptanceList = new ArrayList<ReformItemAcceptanceRecord>();
    @Transient
    private String reformMeasures;
    @Transient
    private Byte warningState;
    @Transient
    private String findTimeStr;
    @Transient
    private String createDateStr;
    @Transient
    private String generationSourceStr;
    @Transient
    private List<SysFileModel> finishFileList;
    @Transient
    private List<SysFileModel> reformItemFileList;
    @Transient
    private List<SysFileModel> acceptanceFileList;
    @Column(name="finder")
    private Long finder;
    @Column(name="pid")
    private Long pid;
    @Column(name="org_id")
    private Long orgId;
    @Column(name="reform_item_position")
    private Long reformItemPosition;
    @Column(name="reform_item_position_name")
    private String reformItemPositionName;
    @Column(name="reform_item_level")
    private Byte reformItemLevel;
    @Column(name="reform_item_type")
    private Byte reformItemType;
    @Column(name="business_status")
    private Byte businessStatus;
    @Column(name="harm_factor_status")
    private Byte harmFactorStatus;
    @Column(name="reform_item_sn")
    private String reformItemSn;
    @Column(name="reform_notification")
    private String reformNotification;
    @Column(name="editor")
    private Long editor;
    @Column(name="is_auto_generation")
    private Boolean isAutoGeneration;
    @Column(name="back_reason")
    private String backReason;
    @Column(name="acceptance_object")
    private Byte acceptanceObject;
    @Column(name="is_show_in_reform_xzxg")
    private Boolean isShowInReformXzxg;

    public void setFindTime(Date findTime) {
        if (findTime == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.findTimeStr = format.format(findTime);
        this.findTime = findTime;
    }

    public void setCreateDate(Date createDate) {
        if (createDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.createDateStr = format.format(createDate);
        }
        this.createDate = createDate;
    }

    public ReformItemAcceptanceRecord getAcceptance() {
        if (this.acceptance != null) {
            return this.acceptance;
        }
        if (this.aceptanceList != null && !this.aceptanceList.isEmpty() && this.aceptanceList.size() > 0) {
            return this.getAceptanceList().get(0);
        }
        return this.acceptance;
    }

    public void setGenerationSource(Byte generationSource) {
        String name = ReformGenerationSourceEnum.getNameByValue(generationSource);
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "\u5176\u4ed6";
        }
        this.generationSourceStr = name;
        this.generationSource = generationSource;
    }

    public boolean isSysFinder() {
        return this.isSysFinder;
    }

    public void setSysFinder(boolean sysFinder) {
        this.isSysFinder = sysFinder;
    }

    @Generated
    public ReformItemSource() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getReformItemId() {
        return this.reformItemId;
    }

    @Generated
    public Long getCid() {
        return this.cid;
    }

    @Generated
    public Long getThirdOrgId() {
        return this.thirdOrgId;
    }

    @Generated
    public String getFinderName() {
        return this.finderName;
    }

    @Generated
    public String getSysFinderName() {
        return this.sysFinderName;
    }

    @Generated
    public Date getFindTime() {
        return this.findTime;
    }

    @Generated
    public Integer getFindTimeYear() {
        return this.findTimeYear;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Byte getReformItemSource() {
        return this.reformItemSource;
    }

    @Generated
    public Long getReformItemSourceId() {
        return this.reformItemSourceId;
    }

    @Generated
    public String getTjBusinessId() {
        return this.tjBusinessId;
    }

    @Generated
    public Byte getGenerationSource() {
        return this.generationSource;
    }

    @Generated
    public Byte getReformItemSourceType() {
        return this.reformItemSourceType;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getReformItemFiles() {
        return this.reformItemFiles;
    }

    @Generated
    public Date getRequireAcceptanceTime() {
        return this.requireAcceptanceTime;
    }

    @Generated
    public Byte getStatus() {
        return this.status;
    }

    @Generated
    public Byte getLawStatus() {
        return this.lawStatus;
    }

    @Generated
    public Long getAreaId() {
        return this.areaId;
    }

    @Generated
    public Long getAreaId1() {
        return this.areaId1;
    }

    @Generated
    public Long getAreaId2() {
        return this.areaId2;
    }

    @Generated
    public Long getAreaId3() {
        return this.areaId3;
    }

    @Generated
    public Long getAreaId4() {
        return this.areaId4;
    }

    @Generated
    public Date getActualFinishTime() {
        return this.actualFinishTime;
    }

    @Generated
    public String getReformDirectorName() {
        return this.reformDirectorName;
    }

    @Generated
    public Date getAcceptanceDate() {
        return this.acceptanceDate;
    }

    @Generated
    public String getAcceptanceDirectorName() {
        return this.acceptanceDirectorName;
    }

    @Generated
    public Byte getDataSource() {
        return this.dataSource;
    }

    @Generated
    public Integer getBatchNum() {
        return this.batchNum;
    }

    @Generated
    public Boolean getIsShowInReformModular() {
        return this.isShowInReformModular;
    }

    @Generated
    public Long getCreateBy() {
        return this.createBy;
    }

    @Generated
    public Date getCreateDate() {
        return this.createDate;
    }

    @Generated
    public Long getUpdateBy() {
        return this.updateBy;
    }

    @Generated
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Generated
    public Boolean getIsValid() {
        return this.isValid;
    }

    @Generated
    public Integer getWorkYear() {
        return this.workYear;
    }

    @Generated
    public String getOutpackName() {
        return this.outpackName;
    }

    @Generated
    public LocalDate getRemindDate() {
        return this.remindDate;
    }

    @Generated
    public String getCompanyName() {
        return this.companyName;
    }

    @Generated
    public Integer getCompanyRadioactivityType() {
        return this.companyRadioactivityType;
    }

    @Generated
    public List<ReformItemAcceptanceRecord> getAceptanceList() {
        return this.aceptanceList;
    }

    @Generated
    public String getReformMeasures() {
        return this.reformMeasures;
    }

    @Generated
    public Byte getWarningState() {
        return this.warningState;
    }

    @Generated
    public String getFindTimeStr() {
        return this.findTimeStr;
    }

    @Generated
    public String getCreateDateStr() {
        return this.createDateStr;
    }

    @Generated
    public String getGenerationSourceStr() {
        return this.generationSourceStr;
    }

    @Generated
    public List<SysFileModel> getFinishFileList() {
        return this.finishFileList;
    }

    @Generated
    public List<SysFileModel> getReformItemFileList() {
        return this.reformItemFileList;
    }

    @Generated
    public List<SysFileModel> getAcceptanceFileList() {
        return this.acceptanceFileList;
    }

    @Generated
    public Long getFinder() {
        return this.finder;
    }

    @Generated
    public Long getPid() {
        return this.pid;
    }

    @Generated
    public Long getOrgId() {
        return this.orgId;
    }

    @Generated
    public Long getReformItemPosition() {
        return this.reformItemPosition;
    }

    @Generated
    public String getReformItemPositionName() {
        return this.reformItemPositionName;
    }

    @Generated
    public Byte getReformItemLevel() {
        return this.reformItemLevel;
    }

    @Generated
    public Byte getReformItemType() {
        return this.reformItemType;
    }

    @Generated
    public Byte getBusinessStatus() {
        return this.businessStatus;
    }

    @Generated
    public Byte getHarmFactorStatus() {
        return this.harmFactorStatus;
    }

    @Generated
    public String getReformItemSn() {
        return this.reformItemSn;
    }

    @Generated
    public String getReformNotification() {
        return this.reformNotification;
    }

    @Generated
    public Long getEditor() {
        return this.editor;
    }

    @Generated
    public Boolean getIsAutoGeneration() {
        return this.isAutoGeneration;
    }

    @Generated
    public String getBackReason() {
        return this.backReason;
    }

    @Generated
    public Byte getAcceptanceObject() {
        return this.acceptanceObject;
    }

    @Generated
    public Boolean getIsShowInReformXzxg() {
        return this.isShowInReformXzxg;
    }

    @Generated
    public ReformItemSource setId(Long id) {
        this.id = id;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemId(Long reformItemId) {
        this.reformItemId = reformItemId;
        return this;
    }

    @Generated
    public ReformItemSource setCid(Long cid) {
        this.cid = cid;
        return this;
    }

    @Generated
    public ReformItemSource setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
        return this;
    }

    @Generated
    public ReformItemSource setFinderName(String finderName) {
        this.finderName = finderName;
        return this;
    }

    @Generated
    public ReformItemSource setSysFinderName(String sysFinderName) {
        this.sysFinderName = sysFinderName;
        return this;
    }

    @Generated
    public ReformItemSource setFindTimeYear(Integer findTimeYear) {
        this.findTimeYear = findTimeYear;
        return this;
    }

    @Generated
    public ReformItemSource setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemSource(Byte reformItemSource) {
        this.reformItemSource = reformItemSource;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemSourceId(Long reformItemSourceId) {
        this.reformItemSourceId = reformItemSourceId;
        return this;
    }

    @Generated
    public ReformItemSource setTjBusinessId(String tjBusinessId) {
        this.tjBusinessId = tjBusinessId;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemSourceType(Byte reformItemSourceType) {
        this.reformItemSourceType = reformItemSourceType;
        return this;
    }

    @Generated
    public ReformItemSource setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemFiles(String reformItemFiles) {
        this.reformItemFiles = reformItemFiles;
        return this;
    }

    @Generated
    public ReformItemSource setRequireAcceptanceTime(Date requireAcceptanceTime) {
        this.requireAcceptanceTime = requireAcceptanceTime;
        return this;
    }

    @Generated
    public ReformItemSource setStatus(Byte status) {
        this.status = status;
        return this;
    }

    @Generated
    public ReformItemSource setLawStatus(Byte lawStatus) {
        this.lawStatus = lawStatus;
        return this;
    }

    @Generated
    public ReformItemSource setAreaId(Long areaId) {
        this.areaId = areaId;
        return this;
    }

    @Generated
    public ReformItemSource setAreaId1(Long areaId1) {
        this.areaId1 = areaId1;
        return this;
    }

    @Generated
    public ReformItemSource setAreaId2(Long areaId2) {
        this.areaId2 = areaId2;
        return this;
    }

    @Generated
    public ReformItemSource setAreaId3(Long areaId3) {
        this.areaId3 = areaId3;
        return this;
    }

    @Generated
    public ReformItemSource setAreaId4(Long areaId4) {
        this.areaId4 = areaId4;
        return this;
    }

    @Generated
    public ReformItemSource setActualFinishTime(Date actualFinishTime) {
        this.actualFinishTime = actualFinishTime;
        return this;
    }

    @Generated
    public ReformItemSource setReformDirectorName(String reformDirectorName) {
        this.reformDirectorName = reformDirectorName;
        return this;
    }

    @Generated
    public ReformItemSource setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
        return this;
    }

    @Generated
    public ReformItemSource setAcceptanceDirectorName(String acceptanceDirectorName) {
        this.acceptanceDirectorName = acceptanceDirectorName;
        return this;
    }

    @Generated
    public ReformItemSource setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Generated
    public ReformItemSource setBatchNum(Integer batchNum) {
        this.batchNum = batchNum;
        return this;
    }

    @Generated
    public ReformItemSource setIsShowInReformModular(Boolean isShowInReformModular) {
        this.isShowInReformModular = isShowInReformModular;
        return this;
    }

    @Generated
    public ReformItemSource setCreateBy(Long createBy) {
        this.createBy = createBy;
        return this;
    }

    @Generated
    public ReformItemSource setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
        return this;
    }

    @Generated
    public ReformItemSource setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
        return this;
    }

    @Generated
    public ReformItemSource setIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @Generated
    public ReformItemSource setWorkYear(Integer workYear) {
        this.workYear = workYear;
        return this;
    }

    @Generated
    public ReformItemSource setOutpackName(String outpackName) {
        this.outpackName = outpackName;
        return this;
    }

    @Generated
    public ReformItemSource setRemindDate(LocalDate remindDate) {
        this.remindDate = remindDate;
        return this;
    }

    @Generated
    public ReformItemSource setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Generated
    public ReformItemSource setCompanyRadioactivityType(Integer companyRadioactivityType) {
        this.companyRadioactivityType = companyRadioactivityType;
        return this;
    }

    @Generated
    public ReformItemSource setAcceptance(ReformItemAcceptanceRecord acceptance) {
        this.acceptance = acceptance;
        return this;
    }

    @Generated
    public ReformItemSource setAceptanceList(List<ReformItemAcceptanceRecord> aceptanceList) {
        this.aceptanceList = aceptanceList;
        return this;
    }

    @Generated
    public ReformItemSource setReformMeasures(String reformMeasures) {
        this.reformMeasures = reformMeasures;
        return this;
    }

    @Generated
    public ReformItemSource setWarningState(Byte warningState) {
        this.warningState = warningState;
        return this;
    }

    @Generated
    public ReformItemSource setFindTimeStr(String findTimeStr) {
        this.findTimeStr = findTimeStr;
        return this;
    }

    @Generated
    public ReformItemSource setCreateDateStr(String createDateStr) {
        this.createDateStr = createDateStr;
        return this;
    }

    @Generated
    public ReformItemSource setGenerationSourceStr(String generationSourceStr) {
        this.generationSourceStr = generationSourceStr;
        return this;
    }

    @Generated
    public ReformItemSource setFinishFileList(List<SysFileModel> finishFileList) {
        this.finishFileList = finishFileList;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemFileList(List<SysFileModel> reformItemFileList) {
        this.reformItemFileList = reformItemFileList;
        return this;
    }

    @Generated
    public ReformItemSource setAcceptanceFileList(List<SysFileModel> acceptanceFileList) {
        this.acceptanceFileList = acceptanceFileList;
        return this;
    }

    @Generated
    public ReformItemSource setFinder(Long finder) {
        this.finder = finder;
        return this;
    }

    @Generated
    public ReformItemSource setPid(Long pid) {
        this.pid = pid;
        return this;
    }

    @Generated
    public ReformItemSource setOrgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemPosition(Long reformItemPosition) {
        this.reformItemPosition = reformItemPosition;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemPositionName(String reformItemPositionName) {
        this.reformItemPositionName = reformItemPositionName;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemLevel(Byte reformItemLevel) {
        this.reformItemLevel = reformItemLevel;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemType(Byte reformItemType) {
        this.reformItemType = reformItemType;
        return this;
    }

    @Generated
    public ReformItemSource setBusinessStatus(Byte businessStatus) {
        this.businessStatus = businessStatus;
        return this;
    }

    @Generated
    public ReformItemSource setHarmFactorStatus(Byte harmFactorStatus) {
        this.harmFactorStatus = harmFactorStatus;
        return this;
    }

    @Generated
    public ReformItemSource setReformItemSn(String reformItemSn) {
        this.reformItemSn = reformItemSn;
        return this;
    }

    @Generated
    public ReformItemSource setReformNotification(String reformNotification) {
        this.reformNotification = reformNotification;
        return this;
    }

    @Generated
    public ReformItemSource setEditor(Long editor) {
        this.editor = editor;
        return this;
    }

    @Generated
    public ReformItemSource setIsAutoGeneration(Boolean isAutoGeneration) {
        this.isAutoGeneration = isAutoGeneration;
        return this;
    }

    @Generated
    public ReformItemSource setBackReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    @Generated
    public ReformItemSource setAcceptanceObject(Byte acceptanceObject) {
        this.acceptanceObject = acceptanceObject;
        return this;
    }

    @Generated
    public ReformItemSource setIsShowInReformXzxg(Boolean isShowInReformXzxg) {
        this.isShowInReformXzxg = isShowInReformXzxg;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReformItemSource)) {
            return false;
        }
        ReformItemSource other = (ReformItemSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSysFinder() != other.isSysFinder()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$reformItemId = this.getReformItemId();
        Long other$reformItemId = other.getReformItemId();
        if (this$reformItemId == null ? other$reformItemId != null : !((Object)this$reformItemId).equals(other$reformItemId)) {
            return false;
        }
        Long this$cid = this.getCid();
        Long other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !((Object)this$cid).equals(other$cid)) {
            return false;
        }
        Long this$thirdOrgId = this.getThirdOrgId();
        Long other$thirdOrgId = other.getThirdOrgId();
        if (this$thirdOrgId == null ? other$thirdOrgId != null : !((Object)this$thirdOrgId).equals(other$thirdOrgId)) {
            return false;
        }
        Integer this$findTimeYear = this.getFindTimeYear();
        Integer other$findTimeYear = other.getFindTimeYear();
        if (this$findTimeYear == null ? other$findTimeYear != null : !((Object)this$findTimeYear).equals(other$findTimeYear)) {
            return false;
        }
        Byte this$reformItemSource = this.getReformItemSource();
        Byte other$reformItemSource = other.getReformItemSource();
        if (this$reformItemSource == null ? other$reformItemSource != null : !((Object)this$reformItemSource).equals(other$reformItemSource)) {
            return false;
        }
        Long this$reformItemSourceId = this.getReformItemSourceId();
        Long other$reformItemSourceId = other.getReformItemSourceId();
        if (this$reformItemSourceId == null ? other$reformItemSourceId != null : !((Object)this$reformItemSourceId).equals(other$reformItemSourceId)) {
            return false;
        }
        Byte this$generationSource = this.getGenerationSource();
        Byte other$generationSource = other.getGenerationSource();
        if (this$generationSource == null ? other$generationSource != null : !((Object)this$generationSource).equals(other$generationSource)) {
            return false;
        }
        Byte this$reformItemSourceType = this.getReformItemSourceType();
        Byte other$reformItemSourceType = other.getReformItemSourceType();
        if (this$reformItemSourceType == null ? other$reformItemSourceType != null : !((Object)this$reformItemSourceType).equals(other$reformItemSourceType)) {
            return false;
        }
        Byte this$status = this.getStatus();
        Byte other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Byte this$lawStatus = this.getLawStatus();
        Byte other$lawStatus = other.getLawStatus();
        if (this$lawStatus == null ? other$lawStatus != null : !((Object)this$lawStatus).equals(other$lawStatus)) {
            return false;
        }
        Long this$areaId = this.getAreaId();
        Long other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !((Object)this$areaId).equals(other$areaId)) {
            return false;
        }
        Long this$areaId1 = this.getAreaId1();
        Long other$areaId1 = other.getAreaId1();
        if (this$areaId1 == null ? other$areaId1 != null : !((Object)this$areaId1).equals(other$areaId1)) {
            return false;
        }
        Long this$areaId2 = this.getAreaId2();
        Long other$areaId2 = other.getAreaId2();
        if (this$areaId2 == null ? other$areaId2 != null : !((Object)this$areaId2).equals(other$areaId2)) {
            return false;
        }
        Long this$areaId3 = this.getAreaId3();
        Long other$areaId3 = other.getAreaId3();
        if (this$areaId3 == null ? other$areaId3 != null : !((Object)this$areaId3).equals(other$areaId3)) {
            return false;
        }
        Long this$areaId4 = this.getAreaId4();
        Long other$areaId4 = other.getAreaId4();
        if (this$areaId4 == null ? other$areaId4 != null : !((Object)this$areaId4).equals(other$areaId4)) {
            return false;
        }
        Byte this$dataSource = this.getDataSource();
        Byte other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        Integer this$batchNum = this.getBatchNum();
        Integer other$batchNum = other.getBatchNum();
        if (this$batchNum == null ? other$batchNum != null : !((Object)this$batchNum).equals(other$batchNum)) {
            return false;
        }
        Boolean this$isShowInReformModular = this.getIsShowInReformModular();
        Boolean other$isShowInReformModular = other.getIsShowInReformModular();
        if (this$isShowInReformModular == null ? other$isShowInReformModular != null : !((Object)this$isShowInReformModular).equals(other$isShowInReformModular)) {
            return false;
        }
        Long this$createBy = this.getCreateBy();
        Long other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !((Object)this$createBy).equals(other$createBy)) {
            return false;
        }
        Long this$updateBy = this.getUpdateBy();
        Long other$updateBy = other.getUpdateBy();
        if (this$updateBy == null ? other$updateBy != null : !((Object)this$updateBy).equals(other$updateBy)) {
            return false;
        }
        Boolean this$isValid = this.getIsValid();
        Boolean other$isValid = other.getIsValid();
        if (this$isValid == null ? other$isValid != null : !((Object)this$isValid).equals(other$isValid)) {
            return false;
        }
        Integer this$workYear = this.getWorkYear();
        Integer other$workYear = other.getWorkYear();
        if (this$workYear == null ? other$workYear != null : !((Object)this$workYear).equals(other$workYear)) {
            return false;
        }
        Integer this$companyRadioactivityType = this.getCompanyRadioactivityType();
        Integer other$companyRadioactivityType = other.getCompanyRadioactivityType();
        if (this$companyRadioactivityType == null ? other$companyRadioactivityType != null : !((Object)this$companyRadioactivityType).equals(other$companyRadioactivityType)) {
            return false;
        }
        Byte this$warningState = this.getWarningState();
        Byte other$warningState = other.getWarningState();
        if (this$warningState == null ? other$warningState != null : !((Object)this$warningState).equals(other$warningState)) {
            return false;
        }
        Long this$finder = this.getFinder();
        Long other$finder = other.getFinder();
        if (this$finder == null ? other$finder != null : !((Object)this$finder).equals(other$finder)) {
            return false;
        }
        Long this$pid = this.getPid();
        Long other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$reformItemPosition = this.getReformItemPosition();
        Long other$reformItemPosition = other.getReformItemPosition();
        if (this$reformItemPosition == null ? other$reformItemPosition != null : !((Object)this$reformItemPosition).equals(other$reformItemPosition)) {
            return false;
        }
        Byte this$reformItemLevel = this.getReformItemLevel();
        Byte other$reformItemLevel = other.getReformItemLevel();
        if (this$reformItemLevel == null ? other$reformItemLevel != null : !((Object)this$reformItemLevel).equals(other$reformItemLevel)) {
            return false;
        }
        Byte this$reformItemType = this.getReformItemType();
        Byte other$reformItemType = other.getReformItemType();
        if (this$reformItemType == null ? other$reformItemType != null : !((Object)this$reformItemType).equals(other$reformItemType)) {
            return false;
        }
        Byte this$businessStatus = this.getBusinessStatus();
        Byte other$businessStatus = other.getBusinessStatus();
        if (this$businessStatus == null ? other$businessStatus != null : !((Object)this$businessStatus).equals(other$businessStatus)) {
            return false;
        }
        Byte this$harmFactorStatus = this.getHarmFactorStatus();
        Byte other$harmFactorStatus = other.getHarmFactorStatus();
        if (this$harmFactorStatus == null ? other$harmFactorStatus != null : !((Object)this$harmFactorStatus).equals(other$harmFactorStatus)) {
            return false;
        }
        Long this$editor = this.getEditor();
        Long other$editor = other.getEditor();
        if (this$editor == null ? other$editor != null : !((Object)this$editor).equals(other$editor)) {
            return false;
        }
        Boolean this$isAutoGeneration = this.getIsAutoGeneration();
        Boolean other$isAutoGeneration = other.getIsAutoGeneration();
        if (this$isAutoGeneration == null ? other$isAutoGeneration != null : !((Object)this$isAutoGeneration).equals(other$isAutoGeneration)) {
            return false;
        }
        Byte this$acceptanceObject = this.getAcceptanceObject();
        Byte other$acceptanceObject = other.getAcceptanceObject();
        if (this$acceptanceObject == null ? other$acceptanceObject != null : !((Object)this$acceptanceObject).equals(other$acceptanceObject)) {
            return false;
        }
        Boolean this$isShowInReformXzxg = this.getIsShowInReformXzxg();
        Boolean other$isShowInReformXzxg = other.getIsShowInReformXzxg();
        if (this$isShowInReformXzxg == null ? other$isShowInReformXzxg != null : !((Object)this$isShowInReformXzxg).equals(other$isShowInReformXzxg)) {
            return false;
        }
        String this$finderName = this.getFinderName();
        String other$finderName = other.getFinderName();
        if (this$finderName == null ? other$finderName != null : !this$finderName.equals(other$finderName)) {
            return false;
        }
        String this$sysFinderName = this.getSysFinderName();
        String other$sysFinderName = other.getSysFinderName();
        if (this$sysFinderName == null ? other$sysFinderName != null : !this$sysFinderName.equals(other$sysFinderName)) {
            return false;
        }
        Date this$findTime = this.getFindTime();
        Date other$findTime = other.getFindTime();
        if (this$findTime == null ? other$findTime != null : !((Object)this$findTime).equals(other$findTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tjBusinessId = this.getTjBusinessId();
        String other$tjBusinessId = other.getTjBusinessId();
        if (this$tjBusinessId == null ? other$tjBusinessId != null : !this$tjBusinessId.equals(other$tjBusinessId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$reformItemFiles = this.getReformItemFiles();
        String other$reformItemFiles = other.getReformItemFiles();
        if (this$reformItemFiles == null ? other$reformItemFiles != null : !this$reformItemFiles.equals(other$reformItemFiles)) {
            return false;
        }
        Date this$requireAcceptanceTime = this.getRequireAcceptanceTime();
        Date other$requireAcceptanceTime = other.getRequireAcceptanceTime();
        if (this$requireAcceptanceTime == null ? other$requireAcceptanceTime != null : !((Object)this$requireAcceptanceTime).equals(other$requireAcceptanceTime)) {
            return false;
        }
        Date this$actualFinishTime = this.getActualFinishTime();
        Date other$actualFinishTime = other.getActualFinishTime();
        if (this$actualFinishTime == null ? other$actualFinishTime != null : !((Object)this$actualFinishTime).equals(other$actualFinishTime)) {
            return false;
        }
        String this$reformDirectorName = this.getReformDirectorName();
        String other$reformDirectorName = other.getReformDirectorName();
        if (this$reformDirectorName == null ? other$reformDirectorName != null : !this$reformDirectorName.equals(other$reformDirectorName)) {
            return false;
        }
        Date this$acceptanceDate = this.getAcceptanceDate();
        Date other$acceptanceDate = other.getAcceptanceDate();
        if (this$acceptanceDate == null ? other$acceptanceDate != null : !((Object)this$acceptanceDate).equals(other$acceptanceDate)) {
            return false;
        }
        String this$acceptanceDirectorName = this.getAcceptanceDirectorName();
        String other$acceptanceDirectorName = other.getAcceptanceDirectorName();
        if (this$acceptanceDirectorName == null ? other$acceptanceDirectorName != null : !this$acceptanceDirectorName.equals(other$acceptanceDirectorName)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Date this$updateDate = this.getUpdateDate();
        Date other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$outpackName = this.getOutpackName();
        String other$outpackName = other.getOutpackName();
        if (this$outpackName == null ? other$outpackName != null : !this$outpackName.equals(other$outpackName)) {
            return false;
        }
        LocalDate this$remindDate = this.getRemindDate();
        LocalDate other$remindDate = other.getRemindDate();
        if (this$remindDate == null ? other$remindDate != null : !((Object)this$remindDate).equals(other$remindDate)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        ReformItemAcceptanceRecord this$acceptance = this.getAcceptance();
        ReformItemAcceptanceRecord other$acceptance = other.getAcceptance();
        if (this$acceptance == null ? other$acceptance != null : !((Object)this$acceptance).equals(other$acceptance)) {
            return false;
        }
        List<ReformItemAcceptanceRecord> this$aceptanceList = this.getAceptanceList();
        List<ReformItemAcceptanceRecord> other$aceptanceList = other.getAceptanceList();
        if (this$aceptanceList == null ? other$aceptanceList != null : !((Object)this$aceptanceList).equals(other$aceptanceList)) {
            return false;
        }
        String this$reformMeasures = this.getReformMeasures();
        String other$reformMeasures = other.getReformMeasures();
        if (this$reformMeasures == null ? other$reformMeasures != null : !this$reformMeasures.equals(other$reformMeasures)) {
            return false;
        }
        String this$findTimeStr = this.getFindTimeStr();
        String other$findTimeStr = other.getFindTimeStr();
        if (this$findTimeStr == null ? other$findTimeStr != null : !this$findTimeStr.equals(other$findTimeStr)) {
            return false;
        }
        String this$createDateStr = this.getCreateDateStr();
        String other$createDateStr = other.getCreateDateStr();
        if (this$createDateStr == null ? other$createDateStr != null : !this$createDateStr.equals(other$createDateStr)) {
            return false;
        }
        String this$generationSourceStr = this.getGenerationSourceStr();
        String other$generationSourceStr = other.getGenerationSourceStr();
        if (this$generationSourceStr == null ? other$generationSourceStr != null : !this$generationSourceStr.equals(other$generationSourceStr)) {
            return false;
        }
        List<SysFileModel> this$finishFileList = this.getFinishFileList();
        List<SysFileModel> other$finishFileList = other.getFinishFileList();
        if (this$finishFileList == null ? other$finishFileList != null : !((Object)this$finishFileList).equals(other$finishFileList)) {
            return false;
        }
        List<SysFileModel> this$reformItemFileList = this.getReformItemFileList();
        List<SysFileModel> other$reformItemFileList = other.getReformItemFileList();
        if (this$reformItemFileList == null ? other$reformItemFileList != null : !((Object)this$reformItemFileList).equals(other$reformItemFileList)) {
            return false;
        }
        List<SysFileModel> this$acceptanceFileList = this.getAcceptanceFileList();
        List<SysFileModel> other$acceptanceFileList = other.getAcceptanceFileList();
        if (this$acceptanceFileList == null ? other$acceptanceFileList != null : !((Object)this$acceptanceFileList).equals(other$acceptanceFileList)) {
            return false;
        }
        String this$reformItemPositionName = this.getReformItemPositionName();
        String other$reformItemPositionName = other.getReformItemPositionName();
        if (this$reformItemPositionName == null ? other$reformItemPositionName != null : !this$reformItemPositionName.equals(other$reformItemPositionName)) {
            return false;
        }
        String this$reformItemSn = this.getReformItemSn();
        String other$reformItemSn = other.getReformItemSn();
        if (this$reformItemSn == null ? other$reformItemSn != null : !this$reformItemSn.equals(other$reformItemSn)) {
            return false;
        }
        String this$reformNotification = this.getReformNotification();
        String other$reformNotification = other.getReformNotification();
        if (this$reformNotification == null ? other$reformNotification != null : !this$reformNotification.equals(other$reformNotification)) {
            return false;
        }
        String this$backReason = this.getBackReason();
        String other$backReason = other.getBackReason();
        return !(this$backReason == null ? other$backReason != null : !this$backReason.equals(other$backReason));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReformItemSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSysFinder() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $reformItemId = this.getReformItemId();
        result = result * 59 + ($reformItemId == null ? 43 : ((Object)$reformItemId).hashCode());
        Long $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : ((Object)$cid).hashCode());
        Long $thirdOrgId = this.getThirdOrgId();
        result = result * 59 + ($thirdOrgId == null ? 43 : ((Object)$thirdOrgId).hashCode());
        Integer $findTimeYear = this.getFindTimeYear();
        result = result * 59 + ($findTimeYear == null ? 43 : ((Object)$findTimeYear).hashCode());
        Byte $reformItemSource = this.getReformItemSource();
        result = result * 59 + ($reformItemSource == null ? 43 : ((Object)$reformItemSource).hashCode());
        Long $reformItemSourceId = this.getReformItemSourceId();
        result = result * 59 + ($reformItemSourceId == null ? 43 : ((Object)$reformItemSourceId).hashCode());
        Byte $generationSource = this.getGenerationSource();
        result = result * 59 + ($generationSource == null ? 43 : ((Object)$generationSource).hashCode());
        Byte $reformItemSourceType = this.getReformItemSourceType();
        result = result * 59 + ($reformItemSourceType == null ? 43 : ((Object)$reformItemSourceType).hashCode());
        Byte $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Byte $lawStatus = this.getLawStatus();
        result = result * 59 + ($lawStatus == null ? 43 : ((Object)$lawStatus).hashCode());
        Long $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : ((Object)$areaId).hashCode());
        Long $areaId1 = this.getAreaId1();
        result = result * 59 + ($areaId1 == null ? 43 : ((Object)$areaId1).hashCode());
        Long $areaId2 = this.getAreaId2();
        result = result * 59 + ($areaId2 == null ? 43 : ((Object)$areaId2).hashCode());
        Long $areaId3 = this.getAreaId3();
        result = result * 59 + ($areaId3 == null ? 43 : ((Object)$areaId3).hashCode());
        Long $areaId4 = this.getAreaId4();
        result = result * 59 + ($areaId4 == null ? 43 : ((Object)$areaId4).hashCode());
        Byte $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        Integer $batchNum = this.getBatchNum();
        result = result * 59 + ($batchNum == null ? 43 : ((Object)$batchNum).hashCode());
        Boolean $isShowInReformModular = this.getIsShowInReformModular();
        result = result * 59 + ($isShowInReformModular == null ? 43 : ((Object)$isShowInReformModular).hashCode());
        Long $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : ((Object)$createBy).hashCode());
        Long $updateBy = this.getUpdateBy();
        result = result * 59 + ($updateBy == null ? 43 : ((Object)$updateBy).hashCode());
        Boolean $isValid = this.getIsValid();
        result = result * 59 + ($isValid == null ? 43 : ((Object)$isValid).hashCode());
        Integer $workYear = this.getWorkYear();
        result = result * 59 + ($workYear == null ? 43 : ((Object)$workYear).hashCode());
        Integer $companyRadioactivityType = this.getCompanyRadioactivityType();
        result = result * 59 + ($companyRadioactivityType == null ? 43 : ((Object)$companyRadioactivityType).hashCode());
        Byte $warningState = this.getWarningState();
        result = result * 59 + ($warningState == null ? 43 : ((Object)$warningState).hashCode());
        Long $finder = this.getFinder();
        result = result * 59 + ($finder == null ? 43 : ((Object)$finder).hashCode());
        Long $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $reformItemPosition = this.getReformItemPosition();
        result = result * 59 + ($reformItemPosition == null ? 43 : ((Object)$reformItemPosition).hashCode());
        Byte $reformItemLevel = this.getReformItemLevel();
        result = result * 59 + ($reformItemLevel == null ? 43 : ((Object)$reformItemLevel).hashCode());
        Byte $reformItemType = this.getReformItemType();
        result = result * 59 + ($reformItemType == null ? 43 : ((Object)$reformItemType).hashCode());
        Byte $businessStatus = this.getBusinessStatus();
        result = result * 59 + ($businessStatus == null ? 43 : ((Object)$businessStatus).hashCode());
        Byte $harmFactorStatus = this.getHarmFactorStatus();
        result = result * 59 + ($harmFactorStatus == null ? 43 : ((Object)$harmFactorStatus).hashCode());
        Long $editor = this.getEditor();
        result = result * 59 + ($editor == null ? 43 : ((Object)$editor).hashCode());
        Boolean $isAutoGeneration = this.getIsAutoGeneration();
        result = result * 59 + ($isAutoGeneration == null ? 43 : ((Object)$isAutoGeneration).hashCode());
        Byte $acceptanceObject = this.getAcceptanceObject();
        result = result * 59 + ($acceptanceObject == null ? 43 : ((Object)$acceptanceObject).hashCode());
        Boolean $isShowInReformXzxg = this.getIsShowInReformXzxg();
        result = result * 59 + ($isShowInReformXzxg == null ? 43 : ((Object)$isShowInReformXzxg).hashCode());
        String $finderName = this.getFinderName();
        result = result * 59 + ($finderName == null ? 43 : $finderName.hashCode());
        String $sysFinderName = this.getSysFinderName();
        result = result * 59 + ($sysFinderName == null ? 43 : $sysFinderName.hashCode());
        Date $findTime = this.getFindTime();
        result = result * 59 + ($findTime == null ? 43 : ((Object)$findTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tjBusinessId = this.getTjBusinessId();
        result = result * 59 + ($tjBusinessId == null ? 43 : $tjBusinessId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $reformItemFiles = this.getReformItemFiles();
        result = result * 59 + ($reformItemFiles == null ? 43 : $reformItemFiles.hashCode());
        Date $requireAcceptanceTime = this.getRequireAcceptanceTime();
        result = result * 59 + ($requireAcceptanceTime == null ? 43 : ((Object)$requireAcceptanceTime).hashCode());
        Date $actualFinishTime = this.getActualFinishTime();
        result = result * 59 + ($actualFinishTime == null ? 43 : ((Object)$actualFinishTime).hashCode());
        String $reformDirectorName = this.getReformDirectorName();
        result = result * 59 + ($reformDirectorName == null ? 43 : $reformDirectorName.hashCode());
        Date $acceptanceDate = this.getAcceptanceDate();
        result = result * 59 + ($acceptanceDate == null ? 43 : ((Object)$acceptanceDate).hashCode());
        String $acceptanceDirectorName = this.getAcceptanceDirectorName();
        result = result * 59 + ($acceptanceDirectorName == null ? 43 : $acceptanceDirectorName.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        Date $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $outpackName = this.getOutpackName();
        result = result * 59 + ($outpackName == null ? 43 : $outpackName.hashCode());
        LocalDate $remindDate = this.getRemindDate();
        result = result * 59 + ($remindDate == null ? 43 : ((Object)$remindDate).hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        ReformItemAcceptanceRecord $acceptance = this.getAcceptance();
        result = result * 59 + ($acceptance == null ? 43 : ((Object)$acceptance).hashCode());
        List<ReformItemAcceptanceRecord> $aceptanceList = this.getAceptanceList();
        result = result * 59 + ($aceptanceList == null ? 43 : ((Object)$aceptanceList).hashCode());
        String $reformMeasures = this.getReformMeasures();
        result = result * 59 + ($reformMeasures == null ? 43 : $reformMeasures.hashCode());
        String $findTimeStr = this.getFindTimeStr();
        result = result * 59 + ($findTimeStr == null ? 43 : $findTimeStr.hashCode());
        String $createDateStr = this.getCreateDateStr();
        result = result * 59 + ($createDateStr == null ? 43 : $createDateStr.hashCode());
        String $generationSourceStr = this.getGenerationSourceStr();
        result = result * 59 + ($generationSourceStr == null ? 43 : $generationSourceStr.hashCode());
        List<SysFileModel> $finishFileList = this.getFinishFileList();
        result = result * 59 + ($finishFileList == null ? 43 : ((Object)$finishFileList).hashCode());
        List<SysFileModel> $reformItemFileList = this.getReformItemFileList();
        result = result * 59 + ($reformItemFileList == null ? 43 : ((Object)$reformItemFileList).hashCode());
        List<SysFileModel> $acceptanceFileList = this.getAcceptanceFileList();
        result = result * 59 + ($acceptanceFileList == null ? 43 : ((Object)$acceptanceFileList).hashCode());
        String $reformItemPositionName = this.getReformItemPositionName();
        result = result * 59 + ($reformItemPositionName == null ? 43 : $reformItemPositionName.hashCode());
        String $reformItemSn = this.getReformItemSn();
        result = result * 59 + ($reformItemSn == null ? 43 : $reformItemSn.hashCode());
        String $reformNotification = this.getReformNotification();
        result = result * 59 + ($reformNotification == null ? 43 : $reformNotification.hashCode());
        String $backReason = this.getBackReason();
        result = result * 59 + ($backReason == null ? 43 : $backReason.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReformItemSource(id=" + this.getId() + ", reformItemId=" + this.getReformItemId() + ", cid=" + this.getCid() + ", thirdOrgId=" + this.getThirdOrgId() + ", finderName=" + this.getFinderName() + ", isSysFinder=" + this.isSysFinder() + ", sysFinderName=" + this.getSysFinderName() + ", findTime=" + String.valueOf(this.getFindTime()) + ", findTimeYear=" + this.getFindTimeYear() + ", name=" + this.getName() + ", reformItemSource=" + this.getReformItemSource() + ", reformItemSourceId=" + this.getReformItemSourceId() + ", tjBusinessId=" + this.getTjBusinessId() + ", generationSource=" + this.getGenerationSource() + ", reformItemSourceType=" + this.getReformItemSourceType() + ", description=" + this.getDescription() + ", reformItemFiles=" + this.getReformItemFiles() + ", requireAcceptanceTime=" + String.valueOf(this.getRequireAcceptanceTime()) + ", status=" + this.getStatus() + ", lawStatus=" + this.getLawStatus() + ", areaId=" + this.getAreaId() + ", areaId1=" + this.getAreaId1() + ", areaId2=" + this.getAreaId2() + ", areaId3=" + this.getAreaId3() + ", areaId4=" + this.getAreaId4() + ", actualFinishTime=" + String.valueOf(this.getActualFinishTime()) + ", reformDirectorName=" + this.getReformDirectorName() + ", acceptanceDate=" + String.valueOf(this.getAcceptanceDate()) + ", acceptanceDirectorName=" + this.getAcceptanceDirectorName() + ", dataSource=" + this.getDataSource() + ", batchNum=" + this.getBatchNum() + ", isShowInReformModular=" + this.getIsShowInReformModular() + ", createBy=" + this.getCreateBy() + ", createDate=" + String.valueOf(this.getCreateDate()) + ", updateBy=" + this.getUpdateBy() + ", updateDate=" + String.valueOf(this.getUpdateDate()) + ", isValid=" + this.getIsValid() + ", workYear=" + this.getWorkYear() + ", outpackName=" + this.getOutpackName() + ", remindDate=" + String.valueOf(this.getRemindDate()) + ", companyName=" + this.getCompanyName() + ", companyRadioactivityType=" + this.getCompanyRadioactivityType() + ", acceptance=" + String.valueOf(this.getAcceptance()) + ", aceptanceList=" + String.valueOf(this.getAceptanceList()) + ", reformMeasures=" + this.getReformMeasures() + ", warningState=" + this.getWarningState() + ", findTimeStr=" + this.getFindTimeStr() + ", createDateStr=" + this.getCreateDateStr() + ", generationSourceStr=" + this.getGenerationSourceStr() + ", finishFileList=" + String.valueOf(this.getFinishFileList()) + ", reformItemFileList=" + String.valueOf(this.getReformItemFileList()) + ", acceptanceFileList=" + String.valueOf(this.getAcceptanceFileList()) + ", finder=" + this.getFinder() + ", pid=" + this.getPid() + ", orgId=" + this.getOrgId() + ", reformItemPosition=" + this.getReformItemPosition() + ", reformItemPositionName=" + this.getReformItemPositionName() + ", reformItemLevel=" + this.getReformItemLevel() + ", reformItemType=" + this.getReformItemType() + ", businessStatus=" + this.getBusinessStatus() + ", harmFactorStatus=" + this.getHarmFactorStatus() + ", reformItemSn=" + this.getReformItemSn() + ", reformNotification=" + this.getReformNotification() + ", editor=" + this.getEditor() + ", isAutoGeneration=" + this.getIsAutoGeneration() + ", backReason=" + this.getBackReason() + ", acceptanceObject=" + this.getAcceptanceObject() + ", isShowInReformXzxg=" + this.getIsShowInReformXzxg() + ")";
    }
}

