/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.entity.work.check;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckThirdInfo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckType;
import cn.smarthse.modules.health.entity.work.check.vo.count.CheckTypeCount;
import cn.smarthse.modules.health.enums.sys.SimpleStatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(value={"handler"})
@Table(name="phc_physical_check")
public class PhcPhysicalCheck
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="select RIGHT(uuid_short(), 19)")
    private Long id;
    private Long cid;
    private String no;
    @Column(name="work_name")
    private String workName;
    @Column(name="begin_time")
    private Date beginTime;
    @Column(name="end_time")
    private Date endTime;
    private Long manager;
    private Long hospital;
    @Column(name="files_storage_location")
    private String filesStorageLocation;
    private Byte status;
    @Transient
    private String statusName;
    @Transient
    private Integer bodyCheckType;
    @Column(name="is_valid")
    private Boolean isValid;
    @Column(name="create_by")
    private Long createBy;
    @Column(name="create_date")
    private Date createDate;
    @Column(name="update_by")
    private Long updateBy;
    @Column(name="update_date")
    private Date updateDate;
    @Column(name="is_recheck")
    private Boolean isRecheck;
    @Column(name="is_replenish")
    private Boolean isReplenish;
    @Column(name="from_type")
    private Byte fromType;
    @Column(name="from_id")
    private Long fromId;
    @Transient
    private String employerId;
    @Column(name="source")
    private Byte source;
    @Transient
    private String hospitalName;
    @Transient
    private String managerName;
    @Transient
    private List<PhcPhysicalCheckType> checkTypes;
    @Transient
    private List<PhcPhysicalCheckFile> reportFiles = new ArrayList<PhcPhysicalCheckFile>();
    @Transient
    private String checkTime;
    @Transient
    private String checkDate;
    @Transient
    private String checkTypeNames;
    @Transient
    private List<PhcPhysicalCheckData> datas;
    @Transient
    private PhcPhysicalCheckThirdInfo thirdInfo;
    @Transient
    private String thirdOrgName;
    @Transient
    private String companyName;
    @Transient
    private Integer checkYear;
    @Transient
    private List<CheckTypeCount> checkTypeCounts;
    @Transient
    private Integer notViewNum;
    @Transient
    private Integer unconfirmedNum;
    @Transient
    private Integer signedNum;
    @Transient
    private String feedBackContent;
    private static final long serialVersionUID = 1L;
    @Column(name="org_id")
    private String orgId;
    @Column(name="data_source")
    private Byte dataSource;

    public String getFeedBackContent() {
        return this.feedBackContent;
    }

    public void setFeedBackContent(String feedBackContent) {
        this.feedBackContent = feedBackContent;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return this.cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no == null ? null : no.trim();
    }

    public String getWorkName() {
        return this.workName;
    }

    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getManager() {
        return this.manager;
    }

    public void setManager(Long manager) {
        this.manager = manager;
    }

    public Long getHospital() {
        return this.hospital;
    }

    public void setHospital(Long hospital) {
        this.hospital = hospital;
    }

    public String getFilesStorageLocation() {
        return this.filesStorageLocation;
    }

    public void setFilesStorageLocation(String filesStorageLocation) {
        this.filesStorageLocation = filesStorageLocation == null ? null : filesStorageLocation.trim();
    }

    public Byte getStatus() {
        return this.status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Boolean getIsRecheck() {
        return this.isRecheck;
    }

    public void setIsRecheck(Boolean isRecheck) {
        this.isRecheck = isRecheck;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public String getHospitalName() {
        return this.hospitalName;
    }

    public void setHospitalName(String hospitalName) {
        this.hospitalName = hospitalName;
    }

    public List<PhcPhysicalCheckType> getCheckTypes() {
        return this.checkTypes;
    }

    public void setCheckTypes(List<PhcPhysicalCheckType> checkTypes) {
        this.checkTypes = checkTypes;
    }

    public List<PhcPhysicalCheckFile> getReportFiles() {
        return this.reportFiles;
    }

    public void setReportFiles(List<PhcPhysicalCheckFile> reportFiles) {
        this.reportFiles = reportFiles;
    }

    public String getCheckTime() {
        if (this.beginTime == null || this.endTime == null) {
            return this.checkTime;
        }
        String pattern = "yyyy-MM-dd HH:mm:ss";
        this.checkTime = DateUtils.format((Date)this.beginTime, (String)pattern) + " \u81f3 " + DateUtils.format((Date)this.endTime, (String)pattern);
        return this.checkTime;
    }

    public void setCheckTime(String checkTime) {
        this.checkTime = checkTime;
    }

    public String getCheckDate() {
        if (this.beginTime == null || this.endTime == null) {
            return this.checkDate;
        }
        String pattern = "yyyy-MM-dd";
        this.checkDate = DateUtils.format((Date)this.beginTime, (String)pattern) + " \u81f3 " + DateUtils.format((Date)this.endTime, (String)pattern);
        return this.checkDate;
    }

    public void setCheckDate(String checkDate) {
        this.checkDate = checkDate;
    }

    public String getCheckTypeNames() {
        if (this.checkTypes == null) {
            return this.checkTypeNames;
        }
        Object types = "";
        for (PhcPhysicalCheckType checkType : this.checkTypes) {
            types = (String)types + checkType.getCheckTypeName() + " ";
        }
        this.checkTypeNames = types;
        return this.checkTypeNames;
    }

    public void setCheckTypeNames(String checkTypeNames) {
        this.checkTypeNames = checkTypeNames;
    }

    public List<PhcPhysicalCheckData> getDatas() {
        return this.datas;
    }

    public void setDatas(List<PhcPhysicalCheckData> datas) {
        this.datas = datas;
    }

    public Byte getFromType() {
        return this.fromType;
    }

    public void setFromType(Byte fromType) {
        this.fromType = fromType;
    }

    public Long getFromId() {
        return this.fromId;
    }

    public void setFromId(Long fromId) {
        this.fromId = fromId;
    }

    public String getStatusName() {
        this.statusName = SimpleStatusEnum.getNameByValue(this.status);
        return this.statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public Boolean getRecheck() {
        return this.isRecheck;
    }

    public void setRecheck(Boolean recheck) {
        this.isRecheck = recheck;
    }

    public Byte getSource() {
        return this.source;
    }

    public void setSource(Byte source) {
        this.source = source;
    }

    public PhcPhysicalCheckThirdInfo getThirdInfo() {
        return this.thirdInfo;
    }

    public void setThirdInfo(PhcPhysicalCheckThirdInfo thirdInfo) {
        this.thirdInfo = thirdInfo;
    }

    public String getThirdOrgName() {
        return this.thirdOrgName;
    }

    public void setThirdOrgName(String thirdOrgName) {
        this.thirdOrgName = thirdOrgName;
    }

    public Integer getCheckYear() {
        return this.checkYear;
    }

    public void setCheckYear(Integer checkYear) {
        this.checkYear = checkYear;
    }

    public List<CheckTypeCount> getCheckTypeCounts() {
        return this.checkTypeCounts;
    }

    public void setCheckTypeCounts(List<CheckTypeCount> checkTypeCounts) {
        this.checkTypeCounts = checkTypeCounts;
    }

    public Boolean getIsReplenish() {
        return this.isReplenish;
    }

    public void setIsReplenish(Boolean isReplenish) {
        this.isReplenish = isReplenish;
    }

    public Integer getNotViewNum() {
        return this.notViewNum;
    }

    public void setNotViewNum(Integer notViewNum) {
        this.notViewNum = notViewNum;
    }

    public Integer getUnconfirmedNum() {
        return this.unconfirmedNum;
    }

    public void setUnconfirmedNum(Integer unconfirmedNum) {
        this.unconfirmedNum = unconfirmedNum;
    }

    public Integer getSignedNum() {
        return this.signedNum;
    }

    public void setSignedNum(Integer signedNum) {
        this.signedNum = signedNum;
    }

    public Byte getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Integer getBodyCheckType() {
        return this.bodyCheckType;
    }

    public void setBodyCheckType(Integer bodyCheckType) {
        this.bodyCheckType = bodyCheckType;
    }
}

