/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.vo.archive;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.vo.archive.ResultAttributeName;
import java.io.Serializable;
import java.math.BigDecimal;

public class Doc6WorkPlaceHarmFactorResultValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal max;
    private BigDecimal min;
    private String minStr;
    private String maxStr;
    private String minPower;
    private String maxPower;
    private String maxBeforChar;
    private String minBeforChar;
    private String reault;
    private String unit;
    private ResultAttributeName attribute;

    public ResultAttributeName getAttribute() {
        return this.attribute;
    }

    public void setAttribute(ResultAttributeName attribute) {
        this.attribute = attribute;
    }

    public String getReault() {
        StringBuffer resultStr = new StringBuffer();
        if (this.attribute == null || this.attribute.getName().startsWith("cmac") || this.attribute.getName().startsWith("ctwa")) {
            if (this.max == null) {
                return this.reault;
            }
            if (this.maxBeforChar != null) {
                resultStr.append(this.maxBeforChar);
            }
            resultStr.append(this.max.toString());
            return resultStr.toString();
        }
        if (this.min == null) {
            if (this.max == null) {
                return this.reault;
            }
            if (this.maxBeforChar != null) {
                resultStr.append(this.maxBeforChar);
            }
            resultStr.append(this.max.toString());
            return resultStr.toString();
        }
        if (this.minBeforChar != null) {
            resultStr.append(this.minBeforChar);
        }
        resultStr.append(this.min.toString());
        if (this.max == null || this.min.compareTo(this.max) == 0) {
            return resultStr.toString();
        }
        resultStr.append("~");
        if (this.maxBeforChar != null) {
            resultStr.append(this.maxBeforChar);
        }
        resultStr.append(this.max.toString());
        return resultStr.toString();
    }

    public void setReault(String reault) {
        this.reault = reault;
    }

    public void setResultNumber(BigDecimal result, String beforChar) {
        if (result == null) {
            return;
        }
        if (this.min == null || this.min.compareTo(result) > 0) {
            this.min = result;
            this.setMinBeforChar(beforChar);
        }
        if (this.max == null || this.max.compareTo(result) < 0) {
            this.max = result;
            this.setMaxBeforChar(beforChar);
        }
    }

    public void setLaserRadiationResultNumber(String valueStr, String powerStr) {
        if (!StringUtils.isNumber((String)powerStr)) {
            return;
        }
        BigDecimal value = new BigDecimal(valueStr);
        Integer power = Integer.valueOf(powerStr);
        BigDecimal result = null;
        result = power > 0 ? value.multiply(new BigDecimal(10).pow(power)) : value.multiply(new BigDecimal("0.1").pow(Math.abs(power)));
        if (this.min == null || this.min.compareTo(result) > 0) {
            this.min = result;
            this.minStr = valueStr;
            this.minPower = powerStr;
        }
        if (this.max == null || this.max.compareTo(result) < 0) {
            this.max = result;
            this.maxStr = valueStr;
            this.maxPower = powerStr;
        }
    }

    public void setRealNumberResult(String resultStr, String beforChar) {
        if (resultStr == null) {
            return;
        }
        if (beforChar == null) {
            beforChar = "";
        }
        if (StringUtils.isEmpty((CharSequence)(resultStr = resultStr.trim()))) {
            return;
        }
        if (resultStr.length() > 1) {
            String firstChar = resultStr.substring(0, 1);
            if (StringUtils.isNumber((String)firstChar)) {
                BigDecimal numberData = new BigDecimal(resultStr);
                this.setResultNumber(numberData, beforChar);
            } else {
                beforChar = StringUtils.isBlank((CharSequence)beforChar) ? firstChar : beforChar + firstChar;
                this.setRealNumberResult(resultStr.substring(1), beforChar);
            }
        }
    }

    public void merge(Doc6WorkPlaceHarmFactorResultValue oldValue) {
        if (oldValue.getMin() != null) {
            if (this.min == null || this.min.compareTo(oldValue.getMin()) > 0) {
                this.min = oldValue.getMin();
                this.minBeforChar = oldValue.getMinBeforChar();
                if (ResultAttributeName.laserRadiation_exposure1.name().equals(this.getAttribute().name()) || ResultAttributeName.laserRadiation_irradiance1.name().equals(this.getAttribute().name())) {
                    this.minStr = oldValue.getMinStr();
                    this.minPower = oldValue.getMinPower();
                }
            }
            if (this.max == null || this.max.compareTo(oldValue.getMax()) < 0) {
                this.max = oldValue.getMax();
                this.maxBeforChar = oldValue.getMaxBeforChar();
                if (ResultAttributeName.laserRadiation_exposure1.name().equals(this.getAttribute().name()) || ResultAttributeName.laserRadiation_irradiance1.name().equals(this.getAttribute().name())) {
                    this.maxStr = oldValue.getMaxStr();
                    this.maxPower = oldValue.getMaxPower();
                }
            }
        }
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public String getMinStr() {
        return this.minStr;
    }

    public String getMaxStr() {
        return this.maxStr;
    }

    public String getMinPower() {
        return this.minPower;
    }

    public String getMaxPower() {
        return this.maxPower;
    }

    public String getMaxBeforChar() {
        return this.maxBeforChar;
    }

    public String getMinBeforChar() {
        return this.minBeforChar;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public void setMin(BigDecimal min) {
        this.min = min;
    }

    public void setMinStr(String minStr) {
        this.minStr = minStr;
    }

    public void setMaxStr(String maxStr) {
        this.maxStr = maxStr;
    }

    public void setMinPower(String minPower) {
        this.minPower = minPower;
    }

    public void setMaxPower(String maxPower) {
        this.maxPower = maxPower;
    }

    public void setMaxBeforChar(String maxBeforChar) {
        this.maxBeforChar = maxBeforChar;
    }

    public void setMinBeforChar(String minBeforChar) {
        this.minBeforChar = minBeforChar;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Doc6WorkPlaceHarmFactorResultValue)) {
            return false;
        }
        Doc6WorkPlaceHarmFactorResultValue other = (Doc6WorkPlaceHarmFactorResultValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$max = this.getMax();
        BigDecimal other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        BigDecimal this$min = this.getMin();
        BigDecimal other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        String this$minStr = this.getMinStr();
        String other$minStr = other.getMinStr();
        if (this$minStr == null ? other$minStr != null : !this$minStr.equals(other$minStr)) {
            return false;
        }
        String this$maxStr = this.getMaxStr();
        String other$maxStr = other.getMaxStr();
        if (this$maxStr == null ? other$maxStr != null : !this$maxStr.equals(other$maxStr)) {
            return false;
        }
        String this$minPower = this.getMinPower();
        String other$minPower = other.getMinPower();
        if (this$minPower == null ? other$minPower != null : !this$minPower.equals(other$minPower)) {
            return false;
        }
        String this$maxPower = this.getMaxPower();
        String other$maxPower = other.getMaxPower();
        if (this$maxPower == null ? other$maxPower != null : !this$maxPower.equals(other$maxPower)) {
            return false;
        }
        String this$maxBeforChar = this.getMaxBeforChar();
        String other$maxBeforChar = other.getMaxBeforChar();
        if (this$maxBeforChar == null ? other$maxBeforChar != null : !this$maxBeforChar.equals(other$maxBeforChar)) {
            return false;
        }
        String this$minBeforChar = this.getMinBeforChar();
        String other$minBeforChar = other.getMinBeforChar();
        if (this$minBeforChar == null ? other$minBeforChar != null : !this$minBeforChar.equals(other$minBeforChar)) {
            return false;
        }
        String this$reault = this.getReault();
        String other$reault = other.getReault();
        if (this$reault == null ? other$reault != null : !this$reault.equals(other$reault)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        ResultAttributeName this$attribute = this.getAttribute();
        ResultAttributeName other$attribute = other.getAttribute();
        return !(this$attribute == null ? other$attribute != null : !((Object)((Object)this$attribute)).equals((Object)other$attribute));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Doc6WorkPlaceHarmFactorResultValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        BigDecimal $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        String $minStr = this.getMinStr();
        result = result * 59 + ($minStr == null ? 43 : $minStr.hashCode());
        String $maxStr = this.getMaxStr();
        result = result * 59 + ($maxStr == null ? 43 : $maxStr.hashCode());
        String $minPower = this.getMinPower();
        result = result * 59 + ($minPower == null ? 43 : $minPower.hashCode());
        String $maxPower = this.getMaxPower();
        result = result * 59 + ($maxPower == null ? 43 : $maxPower.hashCode());
        String $maxBeforChar = this.getMaxBeforChar();
        result = result * 59 + ($maxBeforChar == null ? 43 : $maxBeforChar.hashCode());
        String $minBeforChar = this.getMinBeforChar();
        result = result * 59 + ($minBeforChar == null ? 43 : $minBeforChar.hashCode());
        String $reault = this.getReault();
        result = result * 59 + ($reault == null ? 43 : $reault.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        ResultAttributeName $attribute = this.getAttribute();
        result = result * 59 + ($attribute == null ? 43 : ((Object)((Object)$attribute)).hashCode());
        return result;
    }

    public String toString() {
        return "Doc6WorkPlaceHarmFactorResultValue(max=" + this.getMax() + ", min=" + this.getMin() + ", minStr=" + this.getMinStr() + ", maxStr=" + this.getMaxStr() + ", minPower=" + this.getMinPower() + ", maxPower=" + this.getMaxPower() + ", maxBeforChar=" + this.getMaxBeforChar() + ", minBeforChar=" + this.getMinBeforChar() + ", reault=" + this.getReault() + ", unit=" + this.getUnit() + ", attribute=" + (Object)((Object)this.getAttribute()) + ")";
    }
}

