/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.entity.work.reform;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.work.operate.WorkOperateLog;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformProgramme;
import cn.smarthse.modules.health.enums.reform.AcceptanceResultEnum;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name="reform_item_basic")
public class ReformItemBasic
implements Serializable {
    private static final long serialVersionUID = -41409671529980942L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="select RIGHT(uuid_short(), 19)")
    @Column(name="id")
    private Long id;
    @Column(name="cid")
    private Long cid;
    @Column(name="third_org_id")
    private Long thirdOrgId;
    @Column(name="finder_name")
    private String finderName;
    @Column(name="find_time")
    private Date findTime;
    @Column(name="name")
    private String name;
    @Column(name="reform_item_source")
    private Byte reformItemSource;
    @Column(name="reform_item_source_id")
    private Long reformItemSourceId;
    @Column(name="reform_item_source_mult")
    private String reformItemSourceMult;
    @Column(name="tj_business_id")
    private String tjBusinessId;
    @Column(name="generation_source")
    private Byte generationSource;
    @Column(name="reform_item_source_type")
    private Byte reformItemSourceType;
    @Column(name="description")
    private String description;
    @Column(name="reform_item_files")
    private String reformItemFiles;
    @Column(name="require_acceptance_time")
    private Date requireAcceptanceTime;
    @Column(name="status")
    private Byte status;
    @Column(name="law_status")
    private Byte lawStatus;
    @Column(name="area_id")
    private Long areaId;
    @Column(name="area_id1")
    private Long areaId1;
    @Column(name="area_id2")
    private Long areaId2;
    @Column(name="area_id3")
    private Long areaId3;
    @Column(name="area_id4")
    private Long areaId4;
    @Column(name="actual_finish_time")
    private Date actualFinishTime;
    @Column(name="reform_director_name")
    private String reformDirectorName;
    @Column(name="acceptance_date")
    private Date acceptanceDate;
    @Column(name="acceptance_director_name")
    private String acceptanceDirectorName;
    @Column(name="data_source")
    private Byte dataSource;
    @Column(name="batch_num")
    private Integer batchNum = 1;
    @Column(name="is_show_in_reform_modular")
    private Boolean isShowInReformModular = true;
    @Column(name="create_by")
    private Long createBy;
    @Column(name="create_date")
    private Date createDate;
    @Column(name="update_by")
    private Long updateBy;
    @Column(name="update_date")
    private Date updateDate;
    @Column(name="is_valid")
    private Boolean isValid;
    @Transient
    private String companyName;
    @Transient
    private Long riskExposeEvaluateId;
    @Transient
    private Long accLastId;
    @Transient
    private ReformItemAcceptanceRecord acceptance;
    @Transient
    private List<ReformItemAcceptanceRecord> aceptanceList = new ArrayList<ReformItemAcceptanceRecord>();
    @Transient
    private String reformMeasures;
    @Transient
    private Byte warningState;
    @Transient
    private String findTimeStr;
    @Transient
    private String createDateStr;
    @Transient
    private String generationSourceStr;
    @Transient
    private List<SysFileModel> finishFileList;
    @Transient
    private List<SysFileModel> reformItemFileList;
    @Transient
    private List<SysFileModel> acceptanceFileList;
    @Column(name="finder")
    private Long finder;
    @Column(name="pid")
    private Long pid;
    @Column(name="org_id")
    private Long orgId;
    @Column(name="reform_item_position")
    private Long reformItemPosition;
    @Column(name="reform_item_position_name")
    private String reformItemPositionName;
    @Column(name="reform_item_level")
    private Byte reformItemLevel;
    @Column(name="reform_item_type")
    private Byte reformItemType;
    @Column(name="business_status")
    private Byte businessStatus;
    @Column(name="harm_factor_status")
    private Byte harmFactorStatus;
    @Column(name="reform_item_sn")
    private String reformItemSn;
    @Column(name="reform_notification")
    private String reformNotification;
    @Column(name="editor")
    private Long editor;
    @Column(name="is_auto_generation")
    private Boolean isAutoGeneration;
    @Column(name="back_reason")
    private String backReason;
    @Column(name="acceptance_object")
    private Byte acceptanceObject;
    @Column(name="is_show_in_reform_xzxg")
    private Boolean isShowInReformXzxg;
    @Transient
    private String reformItemLevelName;
    @Transient
    private Boolean isValidateBySource;
    @Transient
    private String finishInfo;
    @Transient
    private Boolean isProcess;
    @Transient
    private Message message;
    @Transient
    private Date lastUpdate;
    @Transient
    private List<ReformProgramme> programmeList;
    @Transient
    private String sourceName;
    @Transient
    private String typeName;
    @Transient
    private String reformItemSources;
    @Transient
    private List<WorkOperateLog> logs = new ArrayList<WorkOperateLog>();

    public void setFindTime(Date findTime) {
        if (findTime == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.findTimeStr = format.format(findTime);
        this.findTime = findTime;
    }

    public void setCreateDate(Date createDate) {
        if (createDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.createDateStr = format.format(createDate);
        }
        this.createDate = createDate;
    }

    public ReformItemAcceptanceRecord getAcceptance() {
        if (this.acceptance != null) {
            return this.acceptance;
        }
        if (this.aceptanceList != null && !this.aceptanceList.isEmpty() && this.aceptanceList.size() > 0) {
            return this.getAceptanceList().get(0);
        }
        return this.acceptance;
    }

    public void setGenerationSource(Byte generationSource) {
        String name = ReformGenerationSourceEnum.getNameByValue(generationSource);
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "\u5176\u4ed6";
        }
        this.generationSourceStr = name;
        this.generationSource = generationSource;
    }

    public boolean isMessageEmpty() {
        boolean isEmpty = true;
        if (this.message == null) {
            return isEmpty;
        }
        if (this.message.getReceivers().isEmpty()) {
            return isEmpty;
        }
        if (this.message.getReceivers().get(0).getReveiver() == null) {
            return isEmpty;
        }
        isEmpty = false;
        return isEmpty;
    }

    public String getFinishInfo() {
        if (this.acceptance == null || this.isShowInReformModular != null && !this.isShowInReformModular.booleanValue()) {
            return "\u672a\u5b9e\u65bd";
        }
        if (AcceptanceResultEnum.complete.getValue().equals(this.acceptance.getAcceptanceResult())) {
            return "\u5df2\u5b8c\u6210";
        }
        return "\u6574\u6539\u4e2d";
    }

    private void updateLastUpdate(Date update) {
        if (update == null) {
            return;
        }
        if (this.lastUpdate == null) {
            this.lastUpdate = update;
        } else if (update.getTime() > this.lastUpdate.getTime()) {
            this.lastUpdate = update;
        }
    }

    public void setAceptanceList(List<ReformItemAcceptanceRecord> aceptanceList) {
        this.aceptanceList = aceptanceList;
        if (!this.aceptanceList.isEmpty()) {
            for (ReformItemAcceptanceRecord record : this.aceptanceList) {
                this.updateLastUpdate(record.getUpdateDate());
            }
        }
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
        this.updateLastUpdate(updateDate);
    }

    public Long getId() {
        return this.id;
    }

    public Long getCid() {
        return this.cid;
    }

    public Long getThirdOrgId() {
        return this.thirdOrgId;
    }

    public String getFinderName() {
        return this.finderName;
    }

    public Date getFindTime() {
        return this.findTime;
    }

    public String getName() {
        return this.name;
    }

    public Byte getReformItemSource() {
        return this.reformItemSource;
    }

    public Long getReformItemSourceId() {
        return this.reformItemSourceId;
    }

    public String getReformItemSourceMult() {
        return this.reformItemSourceMult;
    }

    public String getTjBusinessId() {
        return this.tjBusinessId;
    }

    public Byte getGenerationSource() {
        return this.generationSource;
    }

    public Byte getReformItemSourceType() {
        return this.reformItemSourceType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReformItemFiles() {
        return this.reformItemFiles;
    }

    public Date getRequireAcceptanceTime() {
        return this.requireAcceptanceTime;
    }

    public Byte getStatus() {
        return this.status;
    }

    public Byte getLawStatus() {
        return this.lawStatus;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public Long getAreaId1() {
        return this.areaId1;
    }

    public Long getAreaId2() {
        return this.areaId2;
    }

    public Long getAreaId3() {
        return this.areaId3;
    }

    public Long getAreaId4() {
        return this.areaId4;
    }

    public Date getActualFinishTime() {
        return this.actualFinishTime;
    }

    public String getReformDirectorName() {
        return this.reformDirectorName;
    }

    public Date getAcceptanceDate() {
        return this.acceptanceDate;
    }

    public String getAcceptanceDirectorName() {
        return this.acceptanceDirectorName;
    }

    public Byte getDataSource() {
        return this.dataSource;
    }

    public Integer getBatchNum() {
        return this.batchNum;
    }

    public Boolean getIsShowInReformModular() {
        return this.isShowInReformModular;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Long getUpdateBy() {
        return this.updateBy;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public Long getRiskExposeEvaluateId() {
        return this.riskExposeEvaluateId;
    }

    public Long getAccLastId() {
        return this.accLastId;
    }

    public List<ReformItemAcceptanceRecord> getAceptanceList() {
        return this.aceptanceList;
    }

    public String getReformMeasures() {
        return this.reformMeasures;
    }

    public Byte getWarningState() {
        return this.warningState;
    }

    public String getFindTimeStr() {
        return this.findTimeStr;
    }

    public String getCreateDateStr() {
        return this.createDateStr;
    }

    public String getGenerationSourceStr() {
        return this.generationSourceStr;
    }

    public List<SysFileModel> getFinishFileList() {
        return this.finishFileList;
    }

    public List<SysFileModel> getReformItemFileList() {
        return this.reformItemFileList;
    }

    public List<SysFileModel> getAcceptanceFileList() {
        return this.acceptanceFileList;
    }

    public Long getFinder() {
        return this.finder;
    }

    public Long getPid() {
        return this.pid;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getReformItemPosition() {
        return this.reformItemPosition;
    }

    public String getReformItemPositionName() {
        return this.reformItemPositionName;
    }

    public Byte getReformItemLevel() {
        return this.reformItemLevel;
    }

    public Byte getReformItemType() {
        return this.reformItemType;
    }

    public Byte getBusinessStatus() {
        return this.businessStatus;
    }

    public Byte getHarmFactorStatus() {
        return this.harmFactorStatus;
    }

    public String getReformItemSn() {
        return this.reformItemSn;
    }

    public String getReformNotification() {
        return this.reformNotification;
    }

    public Long getEditor() {
        return this.editor;
    }

    public Boolean getIsAutoGeneration() {
        return this.isAutoGeneration;
    }

    public String getBackReason() {
        return this.backReason;
    }

    public Byte getAcceptanceObject() {
        return this.acceptanceObject;
    }

    public Boolean getIsShowInReformXzxg() {
        return this.isShowInReformXzxg;
    }

    public String getReformItemLevelName() {
        return this.reformItemLevelName;
    }

    public Boolean getIsValidateBySource() {
        return this.isValidateBySource;
    }

    public Boolean getIsProcess() {
        return this.isProcess;
    }

    public Message getMessage() {
        return this.message;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public List<ReformProgramme> getProgrammeList() {
        return this.programmeList;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getReformItemSources() {
        return this.reformItemSources;
    }

    public List<WorkOperateLog> getLogs() {
        return this.logs;
    }

    public ReformItemBasic setId(Long id) {
        this.id = id;
        return this;
    }

    public ReformItemBasic setCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public ReformItemBasic setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
        return this;
    }

    public ReformItemBasic setFinderName(String finderName) {
        this.finderName = finderName;
        return this;
    }

    public ReformItemBasic setName(String name) {
        this.name = name;
        return this;
    }

    public ReformItemBasic setReformItemSource(Byte reformItemSource) {
        this.reformItemSource = reformItemSource;
        return this;
    }

    public ReformItemBasic setReformItemSourceId(Long reformItemSourceId) {
        this.reformItemSourceId = reformItemSourceId;
        return this;
    }

    public ReformItemBasic setReformItemSourceMult(String reformItemSourceMult) {
        this.reformItemSourceMult = reformItemSourceMult;
        return this;
    }

    public ReformItemBasic setTjBusinessId(String tjBusinessId) {
        this.tjBusinessId = tjBusinessId;
        return this;
    }

    public ReformItemBasic setReformItemSourceType(Byte reformItemSourceType) {
        this.reformItemSourceType = reformItemSourceType;
        return this;
    }

    public ReformItemBasic setDescription(String description) {
        this.description = description;
        return this;
    }

    public ReformItemBasic setReformItemFiles(String reformItemFiles) {
        this.reformItemFiles = reformItemFiles;
        return this;
    }

    public ReformItemBasic setRequireAcceptanceTime(Date requireAcceptanceTime) {
        this.requireAcceptanceTime = requireAcceptanceTime;
        return this;
    }

    public ReformItemBasic setStatus(Byte status) {
        this.status = status;
        return this;
    }

    public ReformItemBasic setLawStatus(Byte lawStatus) {
        this.lawStatus = lawStatus;
        return this;
    }

    public ReformItemBasic setAreaId(Long areaId) {
        this.areaId = areaId;
        return this;
    }

    public ReformItemBasic setAreaId1(Long areaId1) {
        this.areaId1 = areaId1;
        return this;
    }

    public ReformItemBasic setAreaId2(Long areaId2) {
        this.areaId2 = areaId2;
        return this;
    }

    public ReformItemBasic setAreaId3(Long areaId3) {
        this.areaId3 = areaId3;
        return this;
    }

    public ReformItemBasic setAreaId4(Long areaId4) {
        this.areaId4 = areaId4;
        return this;
    }

    public ReformItemBasic setActualFinishTime(Date actualFinishTime) {
        this.actualFinishTime = actualFinishTime;
        return this;
    }

    public ReformItemBasic setReformDirectorName(String reformDirectorName) {
        this.reformDirectorName = reformDirectorName;
        return this;
    }

    public ReformItemBasic setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
        return this;
    }

    public ReformItemBasic setAcceptanceDirectorName(String acceptanceDirectorName) {
        this.acceptanceDirectorName = acceptanceDirectorName;
        return this;
    }

    public ReformItemBasic setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ReformItemBasic setBatchNum(Integer batchNum) {
        this.batchNum = batchNum;
        return this;
    }

    public ReformItemBasic setIsShowInReformModular(Boolean isShowInReformModular) {
        this.isShowInReformModular = isShowInReformModular;
        return this;
    }

    public ReformItemBasic setCreateBy(Long createBy) {
        this.createBy = createBy;
        return this;
    }

    public ReformItemBasic setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
        return this;
    }

    public ReformItemBasic setIsValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    public ReformItemBasic setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public ReformItemBasic setRiskExposeEvaluateId(Long riskExposeEvaluateId) {
        this.riskExposeEvaluateId = riskExposeEvaluateId;
        return this;
    }

    public ReformItemBasic setAccLastId(Long accLastId) {
        this.accLastId = accLastId;
        return this;
    }

    public ReformItemBasic setAcceptance(ReformItemAcceptanceRecord acceptance) {
        this.acceptance = acceptance;
        return this;
    }

    public ReformItemBasic setReformMeasures(String reformMeasures) {
        this.reformMeasures = reformMeasures;
        return this;
    }

    public ReformItemBasic setWarningState(Byte warningState) {
        this.warningState = warningState;
        return this;
    }

    public ReformItemBasic setFindTimeStr(String findTimeStr) {
        this.findTimeStr = findTimeStr;
        return this;
    }

    public ReformItemBasic setCreateDateStr(String createDateStr) {
        this.createDateStr = createDateStr;
        return this;
    }

    public ReformItemBasic setGenerationSourceStr(String generationSourceStr) {
        this.generationSourceStr = generationSourceStr;
        return this;
    }

    public ReformItemBasic setFinishFileList(List<SysFileModel> finishFileList) {
        this.finishFileList = finishFileList;
        return this;
    }

    public ReformItemBasic setReformItemFileList(List<SysFileModel> reformItemFileList) {
        this.reformItemFileList = reformItemFileList;
        return this;
    }

    public ReformItemBasic setAcceptanceFileList(List<SysFileModel> acceptanceFileList) {
        this.acceptanceFileList = acceptanceFileList;
        return this;
    }

    public ReformItemBasic setFinder(Long finder) {
        this.finder = finder;
        return this;
    }

    public ReformItemBasic setPid(Long pid) {
        this.pid = pid;
        return this;
    }

    public ReformItemBasic setOrgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }

    public ReformItemBasic setReformItemPosition(Long reformItemPosition) {
        this.reformItemPosition = reformItemPosition;
        return this;
    }

    public ReformItemBasic setReformItemPositionName(String reformItemPositionName) {
        this.reformItemPositionName = reformItemPositionName;
        return this;
    }

    public ReformItemBasic setReformItemLevel(Byte reformItemLevel) {
        this.reformItemLevel = reformItemLevel;
        return this;
    }

    public ReformItemBasic setReformItemType(Byte reformItemType) {
        this.reformItemType = reformItemType;
        return this;
    }

    public ReformItemBasic setBusinessStatus(Byte businessStatus) {
        this.businessStatus = businessStatus;
        return this;
    }

    public ReformItemBasic setHarmFactorStatus(Byte harmFactorStatus) {
        this.harmFactorStatus = harmFactorStatus;
        return this;
    }

    public ReformItemBasic setReformItemSn(String reformItemSn) {
        this.reformItemSn = reformItemSn;
        return this;
    }

    public ReformItemBasic setReformNotification(String reformNotification) {
        this.reformNotification = reformNotification;
        return this;
    }

    public ReformItemBasic setEditor(Long editor) {
        this.editor = editor;
        return this;
    }

    public ReformItemBasic setIsAutoGeneration(Boolean isAutoGeneration) {
        this.isAutoGeneration = isAutoGeneration;
        return this;
    }

    public ReformItemBasic setBackReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    public ReformItemBasic setAcceptanceObject(Byte acceptanceObject) {
        this.acceptanceObject = acceptanceObject;
        return this;
    }

    public ReformItemBasic setIsShowInReformXzxg(Boolean isShowInReformXzxg) {
        this.isShowInReformXzxg = isShowInReformXzxg;
        return this;
    }

    public ReformItemBasic setReformItemLevelName(String reformItemLevelName) {
        this.reformItemLevelName = reformItemLevelName;
        return this;
    }

    public ReformItemBasic setIsValidateBySource(Boolean isValidateBySource) {
        this.isValidateBySource = isValidateBySource;
        return this;
    }

    public ReformItemBasic setFinishInfo(String finishInfo) {
        this.finishInfo = finishInfo;
        return this;
    }

    public ReformItemBasic setIsProcess(Boolean isProcess) {
        this.isProcess = isProcess;
        return this;
    }

    public ReformItemBasic setMessage(Message message) {
        this.message = message;
        return this;
    }

    public ReformItemBasic setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    public ReformItemBasic setProgrammeList(List<ReformProgramme> programmeList) {
        this.programmeList = programmeList;
        return this;
    }

    public ReformItemBasic setSourceName(String sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    public ReformItemBasic setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public ReformItemBasic setReformItemSources(String reformItemSources) {
        this.reformItemSources = reformItemSources;
        return this;
    }

    public ReformItemBasic setLogs(List<WorkOperateLog> logs) {
        this.logs = logs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReformItemBasic)) {
            return false;
        }
        ReformItemBasic other = (ReformItemBasic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$cid = this.getCid();
        Long other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !((Object)this$cid).equals(other$cid)) {
            return false;
        }
        Long this$thirdOrgId = this.getThirdOrgId();
        Long other$thirdOrgId = other.getThirdOrgId();
        if (this$thirdOrgId == null ? other$thirdOrgId != null : !((Object)this$thirdOrgId).equals(other$thirdOrgId)) {
            return false;
        }
        Byte this$reformItemSource = this.getReformItemSource();
        Byte other$reformItemSource = other.getReformItemSource();
        if (this$reformItemSource == null ? other$reformItemSource != null : !((Object)this$reformItemSource).equals(other$reformItemSource)) {
            return false;
        }
        Long this$reformItemSourceId = this.getReformItemSourceId();
        Long other$reformItemSourceId = other.getReformItemSourceId();
        if (this$reformItemSourceId == null ? other$reformItemSourceId != null : !((Object)this$reformItemSourceId).equals(other$reformItemSourceId)) {
            return false;
        }
        Byte this$generationSource = this.getGenerationSource();
        Byte other$generationSource = other.getGenerationSource();
        if (this$generationSource == null ? other$generationSource != null : !((Object)this$generationSource).equals(other$generationSource)) {
            return false;
        }
        Byte this$reformItemSourceType = this.getReformItemSourceType();
        Byte other$reformItemSourceType = other.getReformItemSourceType();
        if (this$reformItemSourceType == null ? other$reformItemSourceType != null : !((Object)this$reformItemSourceType).equals(other$reformItemSourceType)) {
            return false;
        }
        Byte this$status = this.getStatus();
        Byte other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Byte this$lawStatus = this.getLawStatus();
        Byte other$lawStatus = other.getLawStatus();
        if (this$lawStatus == null ? other$lawStatus != null : !((Object)this$lawStatus).equals(other$lawStatus)) {
            return false;
        }
        Long this$areaId = this.getAreaId();
        Long other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !((Object)this$areaId).equals(other$areaId)) {
            return false;
        }
        Long this$areaId1 = this.getAreaId1();
        Long other$areaId1 = other.getAreaId1();
        if (this$areaId1 == null ? other$areaId1 != null : !((Object)this$areaId1).equals(other$areaId1)) {
            return false;
        }
        Long this$areaId2 = this.getAreaId2();
        Long other$areaId2 = other.getAreaId2();
        if (this$areaId2 == null ? other$areaId2 != null : !((Object)this$areaId2).equals(other$areaId2)) {
            return false;
        }
        Long this$areaId3 = this.getAreaId3();
        Long other$areaId3 = other.getAreaId3();
        if (this$areaId3 == null ? other$areaId3 != null : !((Object)this$areaId3).equals(other$areaId3)) {
            return false;
        }
        Long this$areaId4 = this.getAreaId4();
        Long other$areaId4 = other.getAreaId4();
        if (this$areaId4 == null ? other$areaId4 != null : !((Object)this$areaId4).equals(other$areaId4)) {
            return false;
        }
        Byte this$dataSource = this.getDataSource();
        Byte other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !((Object)this$dataSource).equals(other$dataSource)) {
            return false;
        }
        Integer this$batchNum = this.getBatchNum();
        Integer other$batchNum = other.getBatchNum();
        if (this$batchNum == null ? other$batchNum != null : !((Object)this$batchNum).equals(other$batchNum)) {
            return false;
        }
        Boolean this$isShowInReformModular = this.getIsShowInReformModular();
        Boolean other$isShowInReformModular = other.getIsShowInReformModular();
        if (this$isShowInReformModular == null ? other$isShowInReformModular != null : !((Object)this$isShowInReformModular).equals(other$isShowInReformModular)) {
            return false;
        }
        Long this$createBy = this.getCreateBy();
        Long other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !((Object)this$createBy).equals(other$createBy)) {
            return false;
        }
        Long this$updateBy = this.getUpdateBy();
        Long other$updateBy = other.getUpdateBy();
        if (this$updateBy == null ? other$updateBy != null : !((Object)this$updateBy).equals(other$updateBy)) {
            return false;
        }
        Boolean this$isValid = this.getIsValid();
        Boolean other$isValid = other.getIsValid();
        if (this$isValid == null ? other$isValid != null : !((Object)this$isValid).equals(other$isValid)) {
            return false;
        }
        Long this$riskExposeEvaluateId = this.getRiskExposeEvaluateId();
        Long other$riskExposeEvaluateId = other.getRiskExposeEvaluateId();
        if (this$riskExposeEvaluateId == null ? other$riskExposeEvaluateId != null : !((Object)this$riskExposeEvaluateId).equals(other$riskExposeEvaluateId)) {
            return false;
        }
        Long this$accLastId = this.getAccLastId();
        Long other$accLastId = other.getAccLastId();
        if (this$accLastId == null ? other$accLastId != null : !((Object)this$accLastId).equals(other$accLastId)) {
            return false;
        }
        Byte this$warningState = this.getWarningState();
        Byte other$warningState = other.getWarningState();
        if (this$warningState == null ? other$warningState != null : !((Object)this$warningState).equals(other$warningState)) {
            return false;
        }
        Long this$finder = this.getFinder();
        Long other$finder = other.getFinder();
        if (this$finder == null ? other$finder != null : !((Object)this$finder).equals(other$finder)) {
            return false;
        }
        Long this$pid = this.getPid();
        Long other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$reformItemPosition = this.getReformItemPosition();
        Long other$reformItemPosition = other.getReformItemPosition();
        if (this$reformItemPosition == null ? other$reformItemPosition != null : !((Object)this$reformItemPosition).equals(other$reformItemPosition)) {
            return false;
        }
        Byte this$reformItemLevel = this.getReformItemLevel();
        Byte other$reformItemLevel = other.getReformItemLevel();
        if (this$reformItemLevel == null ? other$reformItemLevel != null : !((Object)this$reformItemLevel).equals(other$reformItemLevel)) {
            return false;
        }
        Byte this$reformItemType = this.getReformItemType();
        Byte other$reformItemType = other.getReformItemType();
        if (this$reformItemType == null ? other$reformItemType != null : !((Object)this$reformItemType).equals(other$reformItemType)) {
            return false;
        }
        Byte this$businessStatus = this.getBusinessStatus();
        Byte other$businessStatus = other.getBusinessStatus();
        if (this$businessStatus == null ? other$businessStatus != null : !((Object)this$businessStatus).equals(other$businessStatus)) {
            return false;
        }
        Byte this$harmFactorStatus = this.getHarmFactorStatus();
        Byte other$harmFactorStatus = other.getHarmFactorStatus();
        if (this$harmFactorStatus == null ? other$harmFactorStatus != null : !((Object)this$harmFactorStatus).equals(other$harmFactorStatus)) {
            return false;
        }
        Long this$editor = this.getEditor();
        Long other$editor = other.getEditor();
        if (this$editor == null ? other$editor != null : !((Object)this$editor).equals(other$editor)) {
            return false;
        }
        Boolean this$isAutoGeneration = this.getIsAutoGeneration();
        Boolean other$isAutoGeneration = other.getIsAutoGeneration();
        if (this$isAutoGeneration == null ? other$isAutoGeneration != null : !((Object)this$isAutoGeneration).equals(other$isAutoGeneration)) {
            return false;
        }
        Byte this$acceptanceObject = this.getAcceptanceObject();
        Byte other$acceptanceObject = other.getAcceptanceObject();
        if (this$acceptanceObject == null ? other$acceptanceObject != null : !((Object)this$acceptanceObject).equals(other$acceptanceObject)) {
            return false;
        }
        Boolean this$isShowInReformXzxg = this.getIsShowInReformXzxg();
        Boolean other$isShowInReformXzxg = other.getIsShowInReformXzxg();
        if (this$isShowInReformXzxg == null ? other$isShowInReformXzxg != null : !((Object)this$isShowInReformXzxg).equals(other$isShowInReformXzxg)) {
            return false;
        }
        Boolean this$isValidateBySource = this.getIsValidateBySource();
        Boolean other$isValidateBySource = other.getIsValidateBySource();
        if (this$isValidateBySource == null ? other$isValidateBySource != null : !((Object)this$isValidateBySource).equals(other$isValidateBySource)) {
            return false;
        }
        Boolean this$isProcess = this.getIsProcess();
        Boolean other$isProcess = other.getIsProcess();
        if (this$isProcess == null ? other$isProcess != null : !((Object)this$isProcess).equals(other$isProcess)) {
            return false;
        }
        String this$finderName = this.getFinderName();
        String other$finderName = other.getFinderName();
        if (this$finderName == null ? other$finderName != null : !this$finderName.equals(other$finderName)) {
            return false;
        }
        Date this$findTime = this.getFindTime();
        Date other$findTime = other.getFindTime();
        if (this$findTime == null ? other$findTime != null : !((Object)this$findTime).equals(other$findTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$reformItemSourceMult = this.getReformItemSourceMult();
        String other$reformItemSourceMult = other.getReformItemSourceMult();
        if (this$reformItemSourceMult == null ? other$reformItemSourceMult != null : !this$reformItemSourceMult.equals(other$reformItemSourceMult)) {
            return false;
        }
        String this$tjBusinessId = this.getTjBusinessId();
        String other$tjBusinessId = other.getTjBusinessId();
        if (this$tjBusinessId == null ? other$tjBusinessId != null : !this$tjBusinessId.equals(other$tjBusinessId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$reformItemFiles = this.getReformItemFiles();
        String other$reformItemFiles = other.getReformItemFiles();
        if (this$reformItemFiles == null ? other$reformItemFiles != null : !this$reformItemFiles.equals(other$reformItemFiles)) {
            return false;
        }
        Date this$requireAcceptanceTime = this.getRequireAcceptanceTime();
        Date other$requireAcceptanceTime = other.getRequireAcceptanceTime();
        if (this$requireAcceptanceTime == null ? other$requireAcceptanceTime != null : !((Object)this$requireAcceptanceTime).equals(other$requireAcceptanceTime)) {
            return false;
        }
        Date this$actualFinishTime = this.getActualFinishTime();
        Date other$actualFinishTime = other.getActualFinishTime();
        if (this$actualFinishTime == null ? other$actualFinishTime != null : !((Object)this$actualFinishTime).equals(other$actualFinishTime)) {
            return false;
        }
        String this$reformDirectorName = this.getReformDirectorName();
        String other$reformDirectorName = other.getReformDirectorName();
        if (this$reformDirectorName == null ? other$reformDirectorName != null : !this$reformDirectorName.equals(other$reformDirectorName)) {
            return false;
        }
        Date this$acceptanceDate = this.getAcceptanceDate();
        Date other$acceptanceDate = other.getAcceptanceDate();
        if (this$acceptanceDate == null ? other$acceptanceDate != null : !((Object)this$acceptanceDate).equals(other$acceptanceDate)) {
            return false;
        }
        String this$acceptanceDirectorName = this.getAcceptanceDirectorName();
        String other$acceptanceDirectorName = other.getAcceptanceDirectorName();
        if (this$acceptanceDirectorName == null ? other$acceptanceDirectorName != null : !this$acceptanceDirectorName.equals(other$acceptanceDirectorName)) {
            return false;
        }
        Date this$createDate = this.getCreateDate();
        Date other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        Date this$updateDate = this.getUpdateDate();
        Date other$updateDate = other.getUpdateDate();
        if (this$updateDate == null ? other$updateDate != null : !((Object)this$updateDate).equals(other$updateDate)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        ReformItemAcceptanceRecord this$acceptance = this.getAcceptance();
        ReformItemAcceptanceRecord other$acceptance = other.getAcceptance();
        if (this$acceptance == null ? other$acceptance != null : !((Object)this$acceptance).equals(other$acceptance)) {
            return false;
        }
        List<ReformItemAcceptanceRecord> this$aceptanceList = this.getAceptanceList();
        List<ReformItemAcceptanceRecord> other$aceptanceList = other.getAceptanceList();
        if (this$aceptanceList == null ? other$aceptanceList != null : !((Object)this$aceptanceList).equals(other$aceptanceList)) {
            return false;
        }
        String this$reformMeasures = this.getReformMeasures();
        String other$reformMeasures = other.getReformMeasures();
        if (this$reformMeasures == null ? other$reformMeasures != null : !this$reformMeasures.equals(other$reformMeasures)) {
            return false;
        }
        String this$findTimeStr = this.getFindTimeStr();
        String other$findTimeStr = other.getFindTimeStr();
        if (this$findTimeStr == null ? other$findTimeStr != null : !this$findTimeStr.equals(other$findTimeStr)) {
            return false;
        }
        String this$createDateStr = this.getCreateDateStr();
        String other$createDateStr = other.getCreateDateStr();
        if (this$createDateStr == null ? other$createDateStr != null : !this$createDateStr.equals(other$createDateStr)) {
            return false;
        }
        String this$generationSourceStr = this.getGenerationSourceStr();
        String other$generationSourceStr = other.getGenerationSourceStr();
        if (this$generationSourceStr == null ? other$generationSourceStr != null : !this$generationSourceStr.equals(other$generationSourceStr)) {
            return false;
        }
        List<SysFileModel> this$finishFileList = this.getFinishFileList();
        List<SysFileModel> other$finishFileList = other.getFinishFileList();
        if (this$finishFileList == null ? other$finishFileList != null : !((Object)this$finishFileList).equals(other$finishFileList)) {
            return false;
        }
        List<SysFileModel> this$reformItemFileList = this.getReformItemFileList();
        List<SysFileModel> other$reformItemFileList = other.getReformItemFileList();
        if (this$reformItemFileList == null ? other$reformItemFileList != null : !((Object)this$reformItemFileList).equals(other$reformItemFileList)) {
            return false;
        }
        List<SysFileModel> this$acceptanceFileList = this.getAcceptanceFileList();
        List<SysFileModel> other$acceptanceFileList = other.getAcceptanceFileList();
        if (this$acceptanceFileList == null ? other$acceptanceFileList != null : !((Object)this$acceptanceFileList).equals(other$acceptanceFileList)) {
            return false;
        }
        String this$reformItemPositionName = this.getReformItemPositionName();
        String other$reformItemPositionName = other.getReformItemPositionName();
        if (this$reformItemPositionName == null ? other$reformItemPositionName != null : !this$reformItemPositionName.equals(other$reformItemPositionName)) {
            return false;
        }
        String this$reformItemSn = this.getReformItemSn();
        String other$reformItemSn = other.getReformItemSn();
        if (this$reformItemSn == null ? other$reformItemSn != null : !this$reformItemSn.equals(other$reformItemSn)) {
            return false;
        }
        String this$reformNotification = this.getReformNotification();
        String other$reformNotification = other.getReformNotification();
        if (this$reformNotification == null ? other$reformNotification != null : !this$reformNotification.equals(other$reformNotification)) {
            return false;
        }
        String this$backReason = this.getBackReason();
        String other$backReason = other.getBackReason();
        if (this$backReason == null ? other$backReason != null : !this$backReason.equals(other$backReason)) {
            return false;
        }
        String this$reformItemLevelName = this.getReformItemLevelName();
        String other$reformItemLevelName = other.getReformItemLevelName();
        if (this$reformItemLevelName == null ? other$reformItemLevelName != null : !this$reformItemLevelName.equals(other$reformItemLevelName)) {
            return false;
        }
        String this$finishInfo = this.getFinishInfo();
        String other$finishInfo = other.getFinishInfo();
        if (this$finishInfo == null ? other$finishInfo != null : !this$finishInfo.equals(other$finishInfo)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Date this$lastUpdate = this.getLastUpdate();
        Date other$lastUpdate = other.getLastUpdate();
        if (this$lastUpdate == null ? other$lastUpdate != null : !((Object)this$lastUpdate).equals(other$lastUpdate)) {
            return false;
        }
        List<ReformProgramme> this$programmeList = this.getProgrammeList();
        List<ReformProgramme> other$programmeList = other.getProgrammeList();
        if (this$programmeList == null ? other$programmeList != null : !((Object)this$programmeList).equals(other$programmeList)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$reformItemSources = this.getReformItemSources();
        String other$reformItemSources = other.getReformItemSources();
        if (this$reformItemSources == null ? other$reformItemSources != null : !this$reformItemSources.equals(other$reformItemSources)) {
            return false;
        }
        List<WorkOperateLog> this$logs = this.getLogs();
        List<WorkOperateLog> other$logs = other.getLogs();
        return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReformItemBasic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : ((Object)$cid).hashCode());
        Long $thirdOrgId = this.getThirdOrgId();
        result = result * 59 + ($thirdOrgId == null ? 43 : ((Object)$thirdOrgId).hashCode());
        Byte $reformItemSource = this.getReformItemSource();
        result = result * 59 + ($reformItemSource == null ? 43 : ((Object)$reformItemSource).hashCode());
        Long $reformItemSourceId = this.getReformItemSourceId();
        result = result * 59 + ($reformItemSourceId == null ? 43 : ((Object)$reformItemSourceId).hashCode());
        Byte $generationSource = this.getGenerationSource();
        result = result * 59 + ($generationSource == null ? 43 : ((Object)$generationSource).hashCode());
        Byte $reformItemSourceType = this.getReformItemSourceType();
        result = result * 59 + ($reformItemSourceType == null ? 43 : ((Object)$reformItemSourceType).hashCode());
        Byte $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Byte $lawStatus = this.getLawStatus();
        result = result * 59 + ($lawStatus == null ? 43 : ((Object)$lawStatus).hashCode());
        Long $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : ((Object)$areaId).hashCode());
        Long $areaId1 = this.getAreaId1();
        result = result * 59 + ($areaId1 == null ? 43 : ((Object)$areaId1).hashCode());
        Long $areaId2 = this.getAreaId2();
        result = result * 59 + ($areaId2 == null ? 43 : ((Object)$areaId2).hashCode());
        Long $areaId3 = this.getAreaId3();
        result = result * 59 + ($areaId3 == null ? 43 : ((Object)$areaId3).hashCode());
        Long $areaId4 = this.getAreaId4();
        result = result * 59 + ($areaId4 == null ? 43 : ((Object)$areaId4).hashCode());
        Byte $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : ((Object)$dataSource).hashCode());
        Integer $batchNum = this.getBatchNum();
        result = result * 59 + ($batchNum == null ? 43 : ((Object)$batchNum).hashCode());
        Boolean $isShowInReformModular = this.getIsShowInReformModular();
        result = result * 59 + ($isShowInReformModular == null ? 43 : ((Object)$isShowInReformModular).hashCode());
        Long $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : ((Object)$createBy).hashCode());
        Long $updateBy = this.getUpdateBy();
        result = result * 59 + ($updateBy == null ? 43 : ((Object)$updateBy).hashCode());
        Boolean $isValid = this.getIsValid();
        result = result * 59 + ($isValid == null ? 43 : ((Object)$isValid).hashCode());
        Long $riskExposeEvaluateId = this.getRiskExposeEvaluateId();
        result = result * 59 + ($riskExposeEvaluateId == null ? 43 : ((Object)$riskExposeEvaluateId).hashCode());
        Long $accLastId = this.getAccLastId();
        result = result * 59 + ($accLastId == null ? 43 : ((Object)$accLastId).hashCode());
        Byte $warningState = this.getWarningState();
        result = result * 59 + ($warningState == null ? 43 : ((Object)$warningState).hashCode());
        Long $finder = this.getFinder();
        result = result * 59 + ($finder == null ? 43 : ((Object)$finder).hashCode());
        Long $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $reformItemPosition = this.getReformItemPosition();
        result = result * 59 + ($reformItemPosition == null ? 43 : ((Object)$reformItemPosition).hashCode());
        Byte $reformItemLevel = this.getReformItemLevel();
        result = result * 59 + ($reformItemLevel == null ? 43 : ((Object)$reformItemLevel).hashCode());
        Byte $reformItemType = this.getReformItemType();
        result = result * 59 + ($reformItemType == null ? 43 : ((Object)$reformItemType).hashCode());
        Byte $businessStatus = this.getBusinessStatus();
        result = result * 59 + ($businessStatus == null ? 43 : ((Object)$businessStatus).hashCode());
        Byte $harmFactorStatus = this.getHarmFactorStatus();
        result = result * 59 + ($harmFactorStatus == null ? 43 : ((Object)$harmFactorStatus).hashCode());
        Long $editor = this.getEditor();
        result = result * 59 + ($editor == null ? 43 : ((Object)$editor).hashCode());
        Boolean $isAutoGeneration = this.getIsAutoGeneration();
        result = result * 59 + ($isAutoGeneration == null ? 43 : ((Object)$isAutoGeneration).hashCode());
        Byte $acceptanceObject = this.getAcceptanceObject();
        result = result * 59 + ($acceptanceObject == null ? 43 : ((Object)$acceptanceObject).hashCode());
        Boolean $isShowInReformXzxg = this.getIsShowInReformXzxg();
        result = result * 59 + ($isShowInReformXzxg == null ? 43 : ((Object)$isShowInReformXzxg).hashCode());
        Boolean $isValidateBySource = this.getIsValidateBySource();
        result = result * 59 + ($isValidateBySource == null ? 43 : ((Object)$isValidateBySource).hashCode());
        Boolean $isProcess = this.getIsProcess();
        result = result * 59 + ($isProcess == null ? 43 : ((Object)$isProcess).hashCode());
        String $finderName = this.getFinderName();
        result = result * 59 + ($finderName == null ? 43 : $finderName.hashCode());
        Date $findTime = this.getFindTime();
        result = result * 59 + ($findTime == null ? 43 : ((Object)$findTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $reformItemSourceMult = this.getReformItemSourceMult();
        result = result * 59 + ($reformItemSourceMult == null ? 43 : $reformItemSourceMult.hashCode());
        String $tjBusinessId = this.getTjBusinessId();
        result = result * 59 + ($tjBusinessId == null ? 43 : $tjBusinessId.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $reformItemFiles = this.getReformItemFiles();
        result = result * 59 + ($reformItemFiles == null ? 43 : $reformItemFiles.hashCode());
        Date $requireAcceptanceTime = this.getRequireAcceptanceTime();
        result = result * 59 + ($requireAcceptanceTime == null ? 43 : ((Object)$requireAcceptanceTime).hashCode());
        Date $actualFinishTime = this.getActualFinishTime();
        result = result * 59 + ($actualFinishTime == null ? 43 : ((Object)$actualFinishTime).hashCode());
        String $reformDirectorName = this.getReformDirectorName();
        result = result * 59 + ($reformDirectorName == null ? 43 : $reformDirectorName.hashCode());
        Date $acceptanceDate = this.getAcceptanceDate();
        result = result * 59 + ($acceptanceDate == null ? 43 : ((Object)$acceptanceDate).hashCode());
        String $acceptanceDirectorName = this.getAcceptanceDirectorName();
        result = result * 59 + ($acceptanceDirectorName == null ? 43 : $acceptanceDirectorName.hashCode());
        Date $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        Date $updateDate = this.getUpdateDate();
        result = result * 59 + ($updateDate == null ? 43 : ((Object)$updateDate).hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        ReformItemAcceptanceRecord $acceptance = this.getAcceptance();
        result = result * 59 + ($acceptance == null ? 43 : ((Object)$acceptance).hashCode());
        List<ReformItemAcceptanceRecord> $aceptanceList = this.getAceptanceList();
        result = result * 59 + ($aceptanceList == null ? 43 : ((Object)$aceptanceList).hashCode());
        String $reformMeasures = this.getReformMeasures();
        result = result * 59 + ($reformMeasures == null ? 43 : $reformMeasures.hashCode());
        String $findTimeStr = this.getFindTimeStr();
        result = result * 59 + ($findTimeStr == null ? 43 : $findTimeStr.hashCode());
        String $createDateStr = this.getCreateDateStr();
        result = result * 59 + ($createDateStr == null ? 43 : $createDateStr.hashCode());
        String $generationSourceStr = this.getGenerationSourceStr();
        result = result * 59 + ($generationSourceStr == null ? 43 : $generationSourceStr.hashCode());
        List<SysFileModel> $finishFileList = this.getFinishFileList();
        result = result * 59 + ($finishFileList == null ? 43 : ((Object)$finishFileList).hashCode());
        List<SysFileModel> $reformItemFileList = this.getReformItemFileList();
        result = result * 59 + ($reformItemFileList == null ? 43 : ((Object)$reformItemFileList).hashCode());
        List<SysFileModel> $acceptanceFileList = this.getAcceptanceFileList();
        result = result * 59 + ($acceptanceFileList == null ? 43 : ((Object)$acceptanceFileList).hashCode());
        String $reformItemPositionName = this.getReformItemPositionName();
        result = result * 59 + ($reformItemPositionName == null ? 43 : $reformItemPositionName.hashCode());
        String $reformItemSn = this.getReformItemSn();
        result = result * 59 + ($reformItemSn == null ? 43 : $reformItemSn.hashCode());
        String $reformNotification = this.getReformNotification();
        result = result * 59 + ($reformNotification == null ? 43 : $reformNotification.hashCode());
        String $backReason = this.getBackReason();
        result = result * 59 + ($backReason == null ? 43 : $backReason.hashCode());
        String $reformItemLevelName = this.getReformItemLevelName();
        result = result * 59 + ($reformItemLevelName == null ? 43 : $reformItemLevelName.hashCode());
        String $finishInfo = this.getFinishInfo();
        result = result * 59 + ($finishInfo == null ? 43 : $finishInfo.hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Date $lastUpdate = this.getLastUpdate();
        result = result * 59 + ($lastUpdate == null ? 43 : ((Object)$lastUpdate).hashCode());
        List<ReformProgramme> $programmeList = this.getProgrammeList();
        result = result * 59 + ($programmeList == null ? 43 : ((Object)$programmeList).hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $reformItemSources = this.getReformItemSources();
        result = result * 59 + ($reformItemSources == null ? 43 : $reformItemSources.hashCode());
        List<WorkOperateLog> $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
        return result;
    }

    public String toString() {
        return "ReformItemBasic(id=" + this.getId() + ", cid=" + this.getCid() + ", thirdOrgId=" + this.getThirdOrgId() + ", finderName=" + this.getFinderName() + ", findTime=" + this.getFindTime() + ", name=" + this.getName() + ", reformItemSource=" + this.getReformItemSource() + ", reformItemSourceId=" + this.getReformItemSourceId() + ", reformItemSourceMult=" + this.getReformItemSourceMult() + ", tjBusinessId=" + this.getTjBusinessId() + ", generationSource=" + this.getGenerationSource() + ", reformItemSourceType=" + this.getReformItemSourceType() + ", description=" + this.getDescription() + ", reformItemFiles=" + this.getReformItemFiles() + ", requireAcceptanceTime=" + this.getRequireAcceptanceTime() + ", status=" + this.getStatus() + ", lawStatus=" + this.getLawStatus() + ", areaId=" + this.getAreaId() + ", areaId1=" + this.getAreaId1() + ", areaId2=" + this.getAreaId2() + ", areaId3=" + this.getAreaId3() + ", areaId4=" + this.getAreaId4() + ", actualFinishTime=" + this.getActualFinishTime() + ", reformDirectorName=" + this.getReformDirectorName() + ", acceptanceDate=" + this.getAcceptanceDate() + ", acceptanceDirectorName=" + this.getAcceptanceDirectorName() + ", dataSource=" + this.getDataSource() + ", batchNum=" + this.getBatchNum() + ", isShowInReformModular=" + this.getIsShowInReformModular() + ", createBy=" + this.getCreateBy() + ", createDate=" + this.getCreateDate() + ", updateBy=" + this.getUpdateBy() + ", updateDate=" + this.getUpdateDate() + ", isValid=" + this.getIsValid() + ", companyName=" + this.getCompanyName() + ", riskExposeEvaluateId=" + this.getRiskExposeEvaluateId() + ", accLastId=" + this.getAccLastId() + ", acceptance=" + this.getAcceptance() + ", aceptanceList=" + this.getAceptanceList() + ", reformMeasures=" + this.getReformMeasures() + ", warningState=" + this.getWarningState() + ", findTimeStr=" + this.getFindTimeStr() + ", createDateStr=" + this.getCreateDateStr() + ", generationSourceStr=" + this.getGenerationSourceStr() + ", finishFileList=" + this.getFinishFileList() + ", reformItemFileList=" + this.getReformItemFileList() + ", acceptanceFileList=" + this.getAcceptanceFileList() + ", finder=" + this.getFinder() + ", pid=" + this.getPid() + ", orgId=" + this.getOrgId() + ", reformItemPosition=" + this.getReformItemPosition() + ", reformItemPositionName=" + this.getReformItemPositionName() + ", reformItemLevel=" + this.getReformItemLevel() + ", reformItemType=" + this.getReformItemType() + ", businessStatus=" + this.getBusinessStatus() + ", harmFactorStatus=" + this.getHarmFactorStatus() + ", reformItemSn=" + this.getReformItemSn() + ", reformNotification=" + this.getReformNotification() + ", editor=" + this.getEditor() + ", isAutoGeneration=" + this.getIsAutoGeneration() + ", backReason=" + this.getBackReason() + ", acceptanceObject=" + this.getAcceptanceObject() + ", isShowInReformXzxg=" + this.getIsShowInReformXzxg() + ", reformItemLevelName=" + this.getReformItemLevelName() + ", isValidateBySource=" + this.getIsValidateBySource() + ", finishInfo=" + this.getFinishInfo() + ", isProcess=" + this.getIsProcess() + ", message=" + this.getMessage() + ", lastUpdate=" + this.getLastUpdate() + ", programmeList=" + this.getProgrammeList() + ", sourceName=" + this.getSourceName() + ", typeName=" + this.getTypeName() + ", reformItemSources=" + this.getReformItemSources() + ", logs=" + this.getLogs() + ")";
    }
}

