/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.health.entity.base.company;

import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.modules.health.entity.base.company.CompanyAreaBuildingInfo;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name="company_area")
public class CompanyArea
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY, generator="select RIGHT(uuid_short(), 19)")
    private Long id;
    private Long cid;
    private Long pid;
    @DataValida(maxLength="32", minLength="1", nullAble=false, name="\u533a\u57df\u540d\u79f0", group={"add", "edit"})
    @Column(name="area_name")
    private String areaName;
    private Byte level;
    @Column(name="tree_path")
    private String treePath;
    @Transient
    private String treePathName;
    @Column(name="create_date")
    private Date createDate;
    @Column(name="create_by")
    private Long createBy;
    @Column(name="update_date")
    private Date updateDate;
    @Column(name="update_by")
    private Long updateBy;
    @Column(name="is_valid")
    private Boolean isValid;
    private Integer sort;
    @Transient
    private CompanyAreaBuildingInfo buildingInfo;
    @Transient
    private List<CompanyArea> child = new ArrayList<CompanyArea>();
    @Transient
    private List<CompanyArea> parents = new ArrayList<CompanyArea>();
    private static final long serialVersionUID = 1L;
    @Transient
    private String sortNo;

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getTreePathName() {
        return this.treePathName;
    }

    public void setTreePathName(String treePathName) {
        this.treePathName = treePathName;
    }

    public List<CompanyArea> getParents() {
        return this.parents;
    }

    public void setParents(List<CompanyArea> parents) {
        this.parents = parents;
    }

    public CompanyAreaBuildingInfo getBuildingInfo() {
        return this.buildingInfo;
    }

    public void setBuildingInfo(CompanyAreaBuildingInfo buildingInfo) {
        this.buildingInfo = buildingInfo;
    }

    public List<CompanyArea> getChild() {
        return this.child;
    }

    public void setChild(List<CompanyArea> child) {
        this.child = child;
    }

    public String getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(String sortNo) {
        this.sortNo = sortNo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCid() {
        return this.cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName == null ? null : areaName.trim();
    }

    public Byte getLevel() {
        return this.level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public String getTreePath() {
        return this.treePath;
    }

    public void setTreePath(String treePath) {
        this.treePath = treePath == null ? null : treePath.trim();
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public static String creteAreaSortNo(List<CompanyArea> allAreas, Long areaId) {
        CompanyArea area = CompanyArea.getById(allAreas, areaId);
        String sortS = "";
        int sort = 0;
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        while (area != null) {
            sort = area.getSort();
            sortS = decimalFormat.format(sort) + "-" + sortS;
            area = CompanyArea.getById(allAreas, area.getPid());
        }
        return sortS;
    }

    public static String createTreeName(List<CompanyArea> allAreas, Long areaId) {
        CompanyArea area = CompanyArea.getById(allAreas, areaId);
        String s = "";
        while (area != null) {
            s = area.getAreaName() + ">" + s;
            area = CompanyArea.getById(allAreas, area.getPid());
        }
        return s.substring(0, s.length() - 1);
    }

    public static CompanyArea getById(List<CompanyArea> allAreas, Long id) {
        for (CompanyArea area : allAreas) {
            if (!area.getId().equals(id)) continue;
            return area;
        }
        return null;
    }
}

