/**
 * 
 */
package cn.smarthse.modules.health.vo.work.yearplan;

import java.io.Serializable;
import java.util.List;

import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.vo.work.BaseWorkItemVO;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 《年度计划工作》
 * 
 * 
 * @Project:  smarthse-facade1.0
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2017-8-22-上午11:00:25
 */
@EqualsAndHashCode(callSuper=false)
public @Data class PlanYearWorkItemVO extends BaseWorkItemVO implements Serializable{
	private static final long serialVersionUID = 465995217982224502L;
	//年度计划-计划中size
	private Integer yearPlanCount1 = 0;
	//年度计划-待总结size
	private Integer yearPlanCount2 = 0;
	//日常计划-计划中size
	private Integer dailyPlanCount1 = 0;
	//日常计划-待总结size
	private Integer dailyPlanCount2 = 0;
	//待分解的工作计划size
	private Integer decomposePlanCount1 = 0;
	//分解的工作计划待总结size
	private Integer decomposePlanCount2 = 0;
	//待分解的经费size
	private Integer decomposeExpendCount = 0;
	
	/**
	 * 所有的数量
	 */
	private Integer totalPlanCount=0;
	
	//距离上一次年度计划是否超过一年(true-超过一年,false-未超过一年);
	private boolean isExceed = false;
	
	/**
	 * 每个模块完成的工作
	 */
	private List<SysCoreWorkModuleCorrelation> completedWork;
	
}
