package cn.smarthse.modules.health.vo.work.trusteeship;

import lombok.Data;

import java.io.Serializable;

/**
 * 年度第三方托管服务机构列表
 * @author 吴嘉诚
 * @date 2022/4/15 18:35
 * @desc
 */
public @Data
class TrusteeshipOrgParam implements Serializable {

    private Long id;

    private Integer year;       //年份

    private Byte quarter;       //季度

    private Long orgId;         //机构Id

    /**
     * 托管工作状态   请选择、1 已完成、2 进行中、3 未完成、4 未开始
     */
    private Byte status;

    /**
     * 机构状态     请选择、0 正常、1 禁用
     */
    private Byte orgStatus;

    /**
     * 企业名称或者托管机构名称
     */
    private String keyword;

    /**
     * 是否是或查询
     *  true ： status = 3 or orgStatus = 1
     *  false ： 其他情况
     */
    private Boolean orQuery = false;

}
