package cn.smarthse.modules.health.vo.work.trusteeship;

import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 第三方托管核查工作列表
 *
 * @author ShenZQ
 * @since 2022-04-11 18:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class TrusteeshipInfoVo extends TrusteeshipInfo implements Serializable {

    private static final long serialVersionUID = -8692039681327787987L;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 区域id
     */
    private Long areaId;

    /**
     * 区域名称
     */
    private String areaName;

    /**
     * 区域名称（简）
     */
    private String shortAreaName;

    /**
     * 待整改数
     */
    private Integer toReformNum;

    /**
     * 待验收数
     */
    private Integer toAcceptanceNum;

    /**
     * 单位工作地址
     */
    private String address;

    /**
     * 企业ID
     */
    private Long cid;
}
