package cn.smarthse.modules.health.vo.work.trusteeship;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 吴嘉诚
 * @date 2022/4/11 18:10
 * @desc
 */
@Data
public class TrusteeshipInfoQueryVo implements Serializable {

    private Long id;

    private Long trusteeshipOrgId;  //托管机构ID

    private String orgName;  //托管机构名称

    private Integer year;   //核查年份

    private Integer quarter;    //核查季度

    private Date checkTime;     //核查时间

    private String checkPerson;     //核查人

    /**
     * 核查状态（1 未开始，2 已提交，3 未完成/进行中，4 被退回，5 数据补录)
     */
    private Byte status;

    /**
     * 核查结论（1 机构指导整改  2 上报行政主管部门）
     */
    private Byte result;

    private String description;

    private Integer nonConformanceItem = 0;     //发现不符合项数

    private Integer reasonableItem = 0;       //合理缺项数

    private Integer uncheckedItem = 0;      //未检查项数

    private Integer rectifiedingItem = 0;   //待整改项数

    private Integer checkItem = 0;  //待验收项数

    private Integer conformanceItem = 0;    //符合项数

    private String fileStr;        //图像资料

    private String companyName;        //企业名称

    private Byte orgStatus;     //机构状态（0 正常，1 禁用)

}
