package cn.smarthse.modules.health.vo.work.trusteeship;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 第三方托管核查工作列表查询参数
 *
 * @author ShenZQ
 * @since 2022-04-11 19:31
 */
@Data
public class TrusteeshipInfoParam implements Serializable {

    private static final long serialVersionUID = -7153884650015363736L;

    /**
     * 企业id
     */
    private Long cid;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 年份
     */
    private Integer year;
    /**
     * 季度
     */
    private Integer quarter;
    /**
     * 是否选中待整改
     */
    private Boolean reform;
    /**
     * 是否选中待验收
     */
    private Boolean check;
    /**
     * 托管机构名称
     */
    private String orgName;

    /**
     * 企业名称或者托管机构名称
     */
    private String keyword;

    private Long areaId;

    private Byte areaLevel;

    /**
     *  企业是否正常营业或关闭
     */
    private List<Integer> businessStatus;

    /**
     *  核查状态1 未开始，2 已提交，3 未完成/进行中，4 被退回
     */
    private Byte status;

    private Boolean isFinish;

    /**
     * 核查状态列表
     *  核查状态（1 未开始，2 已提交，3 未完成/进行中，4 被退回，5 数据补录)
     */
    private List<Integer> statusList;

    /**
     * 是否企业端，企业端只查询已提交过的数据
     */
    private Boolean isCompany;

}
