package cn.smarthse.modules.health.vo.work.trusteeship;

import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author 吴嘉诚
 * @date 2022/4/12 10:45
 * @desc 核查表详情
 */
@Data
public class TrusteeshipInfoDetailQueryVo implements Serializable {

    private Long id;

    private Long trusteeshipOrgId;  //托管机构ID

    private String orgName;  //托管机构名称

    private Integer year;   //核查年份

    private Integer quarter;    //核查季度

    private Date checkTime;     //核查时间

    private String checkPerson;     //核查人

    /**
     * 核查状态（1 未开始，2 已提交，3 未完成/进行中，4 被退回，5 数据补录)
     */
    private Byte status;

    /**
     * 核查结论（1 机构指导整改  2 上报行政主管部门）
     */
    private Byte result;

    private String fileStr = "";        //图像资料

    private List<TrusteeshipInfoDetailView> detailList;     //托管核查工作详情

    private List<TrusteeshipInfoDetailView> nonConformanceItemList = new ArrayList<TrusteeshipInfoDetailView>();     //不符合项目汇总表核查内容

    private List<TrusteeshipInfoDetailView> uncheckedItemList = new ArrayList<TrusteeshipInfoDetailView>();      //未检查项目汇总表核查内容

    private List<TrusteeshipInfoDetailView> reasonableItemList = new ArrayList<TrusteeshipInfoDetailView>();     //合理缺项目汇总表核查内容

}
