package cn.smarthse.modules.health.vo.work.trusteeship;

import lombok.Data;

import java.io.Serializable;

/**
 * 用人单位托管核查工作列表
 *
 * @author ShenZQ
 * @since 2022-04-22 18:10
 */
@Data
public class TrusteeshipCheckedVo implements Serializable {

    private static final long serialVersionUID = -2723090341974815521L;

    /**
     * 托管信息id
     */
    private Long trusteeshipInfoId;

    /**
     * 年度
     */
    private Integer year;

    /**
     * 周期
     */
    private Integer quarter;

    /**
     * 核查状态
     */
    private Byte status;

    /**
     * 托管机构名称
     */
    private String orgName;

    /**
     * 核查结论（1 机构指导整改  2 上报行政主管部门）
     */
    private Byte result;
}
