package cn.smarthse.modules.health.vo.work.trusteeship;

import lombok.Data;

import java.io.Serializable;

/**
 * 风险预警列表
 *
 * @author ShenZQ
 * @since 2022-04-15 17:04
 */
@Data
public class RiskWarningVo implements Serializable {

    private static final long serialVersionUID = -7105493677782978229L;

    /**
     * 托管核查工作信息id
     */
    private Long trusteeshipInfoId;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 企业名称
     */
    private String name;

    /**
     * 风险类型
     * <p>
     * 1. 机构上报风险
     * 2. 未托管核查
     * 3. 整改超期（超过整改期限30天未整改，进行预警）
     * 4. 已关闭
     * 5. 暂停营业
     */
    private String status;


    /**
     * 托管机构名称
     */
    private String orgName;

    /**
     * 预警的服务周期
     */
    private Integer warningQuarter;
}
