package cn.smarthse.modules.health.vo.work.trusteeship;

import lombok.Data;

import java.io.Serializable;

/**
 * 风险预警列表查询参数
 *
 * @author ShenZQ
 * @since 2022-04-15 17:03
 */
@Data
public class RiskWarningParam implements Serializable {

    private static final Long serialVersionUID = -2729214946708526891L;

    /**
     * 年份
     */
    private Integer year;

    /**
     * 风险类型
     * <p>
     * 1. 机构上报风险
     * 2. 未托管核查
     * 3. 整改超期（超过整改期限30天未整改，进行预警）
     * 4. 已关闭
     * 5. 暂停营业
     */
    private String riskWarningType = "0";

    /**
     * 企业名称
     */
    private String companyName;

    private Long areaId;

    private Byte areaLevel;
}
