package cn.smarthse.modules.health.vo.work.train;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

import cn.smarthse.modules.health.entity.sys.SysCoreWorkModuleCorrelation;
import cn.smarthse.modules.health.vo.work.BaseWorkItemVO;
import cn.smarthse.modules.health.vo.work.yearplan.PlanYearWorkItemVO;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 《》
 * 培训待办事项vo
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author XiaoYi(肖奕) 
 * @since 2017年8月25日-上午9:19:59
 */
@EqualsAndHashCode(callSuper=false)
public @Data class TrainWorkItemVo extends BaseWorkItemVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7604643449237669220L;
   
	/**
	 * 是否显示"点击新增开始一项新的教育培训工作"
	 * true显示，false不显示
	 */
	private Boolean isDislayAdd;
	
	/**
	 * 进行中的教育培训工作数量
	 */
	private Integer numOfUnFinishedTrainPlan;
	
	/**
	 * 进行中的年度培训总结培训工作数量
	 */
	private Integer numOfUnFinishedTrainSumm;
	
	/**
	 * 是否显示"今年还未进行过年度培训总结，是否进行"
	 * true显示，false不显示
	 */
	private Boolean haveTrainSummThisYear;
	
	/**
	 * 是否显示"今年还未进行过职业卫生培训，是否进行"
	 * true显示，false不显示
	 */
	private Boolean haveTrainPlanThisYear;
	
	/**
	 * 是否显示"培训相关资料管理"
	 * true显示，false不显示
	 */
	private Boolean isDisplayTrainFile;
	
	
	/**
	 * 三同时事项
	 */
	private List<SysCoreWorkModuleCorrelation> thirdTimeList;


	//简化版舟山需求培训上报同步到教育培训
	List<SysCoreWorkModuleCorrelation> appearOrgTrainPlanList;
	
	
	/**
	 * 事故数量
	 */
	private Integer  accidentCount;
	
	/**
	 * 提醒数量
	 */
	private Integer  tipNum=0;
	
   
}