package cn.smarthse.modules.health.vo.work.shield;

import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc v2.9版本 防护用品发放统计
 * @since 2019/10/12 0012 9:29
 */
@Data
public class ShieldSendCountVo implements Serializable {
    private String proClass;//防护用品类别
    private String shieldId;//防护用品id
    private String detailName;// 名称
    private String func;//功能
    private String shieldDesc;//说明
    private String proLevel;//保护等级
    private String orgName;//部门
    private Date sendTime;//发放时间
    private String fetchName;//领取人
    private Long num;//数量
    private String countUnit;//单位
    private String unit;//单位
    private String model;//型号
    private String countTime;//统计时间
    private String requiredName;//发放对象

    private Integer realFetchNum; //实际领取数量
    private Date realFetchTime; //领取时间
    public String getUnit() {
        return ShieldCountUnitEnum.getName(this.countUnit);
    }
}
