package cn.smarthse.modules.health.vo.work.shield;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 未及时领取防护用品人员
 * @since 2019/10/10 0010 10:36
 */
public class ShieldExpireUserVo implements Serializable {

    private Long requirerId; // 用户id staffId
    private String requirerName; // 姓名
    private String workNo; //工号
    private String workName;//岗位
    private String organizationName; // 部门名称
    private List<String> shieldDetailNames = new ArrayList<>();// 防护用品名称
    private List<ExpireShield> shieldList;

    public String getWorkName() {
        return workName;
    }

    public void setWorkName(String workName) {
        this.workName = workName;
    }

    public Long getRequirerId() {
        return requirerId;
    }

    public void setRequirerId(Long requirerId) {
        this.requirerId = requirerId;
    }

    public String getRequirerName() {
        return requirerName;
    }

    public void setRequirerName(String requirerName) {
        this.requirerName = requirerName;
    }

    public String getWorkNo() {
        return workNo;
    }

    public void setWorkNo(String workNo) {
        this.workNo = workNo;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    /**
     * 获取防护用品名称
     * @return
     */
    public List<String> getShieldDetailNames() {
        shieldDetailNames.clear();
        getShieldList().forEach((item)->{
            shieldDetailNames.add(item.getShieldDetailName());
        });
        return shieldDetailNames;
    }

    public List<ExpireShield> getShieldList() {
        return shieldList;
    }

    public void setShieldList(List<ExpireShield> shieldList) {
        this.shieldList = shieldList;
    }

    public static class ExpireShield implements Serializable{
        private Long shieldId; // 防护用品id shield_equip_rule_detail
        private String shieldDetailName; // 防护用品名称
        private Integer cycle; // 发放周期
        private String cycleUnit; //周期单位 1年  2季  3月  4周   5日
        private Date sendTime; // 上次发放时间

        private String cycleRule;// 发放周期

        public Long getShieldId() {
            return shieldId;
        }

        public void setShieldId(Long shieldId) {
            this.shieldId = shieldId;
        }

        public String getShieldDetailName() {
            return shieldDetailName;
        }

        public void setShieldDetailName(String shieldDetailName) {
            this.shieldDetailName = shieldDetailName;
        }

        public Integer getCycle() {
            return cycle;
        }

        public void setCycle(Integer cycle) {
            this.cycle = cycle;
        }

        public String getCycleUnit() {
            return cycleUnit;
        }

        public void setCycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
        }

        public Date getSendTime() {
            return sendTime;
        }

        public void setSendTime(Date sendTime) {
            this.sendTime = sendTime;
        }

        public String getCycleRule() {
            return cycleRule;
        }

        public void setCycleRule(String cycleRule) {
            this.cycleRule = cycleRule;
        }
    }
}
