package cn.smarthse.modules.health.vo.work.shield;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.enums.shield.ShieldCycleUnitEnum;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @Project
 * @Module
 * @JDK_Vserion 1.8
 * @Author DengLibin
 * @Email dlb@smarthse.cn
 * @Desc 防护用品功能vo
 * @since 2019/10/11 0011 10:06
 */
public class ShieldDetailVo implements Serializable {

    private String shieldId;//防护用品id

    /**
     * 防护类型
     */
    @Column(name = "Pro_Class")
    private String proClass;

    /**
     * 用途
     */
    @Column(name = "Function")
    private String function;

    /**
     * 注解
     */
    @Column(name = "Remake")
    private String remake;

    private Integer amount;

    private String countUnit;

    private Integer cycle;

    private String cycleUnit;

    private String cycleRule;

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getCountUnit() {
        return countUnit;
    }

    public void setCountUnit(String countUnit) {
        this.countUnit = countUnit;
    }

    public Integer getCycle() {
        return cycle;
    }

    public void setCycle(Integer cycle) {
        this.cycle = cycle;
    }

    public String getCycleUnit() {
        return cycleUnit;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setCycleRule(String cycleRule) {
        this.cycleRule = cycleRule;
    }

    public String getShieldId() {
        return shieldId;
    }

    public void setShieldId(String shieldId) {
        this.shieldId = shieldId;
    }

    public String getProClass() {
        return proClass;
    }

    public void setProClass(String proClass) {
        this.proClass = proClass;
    }

    public String getFunction() {
        return function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getRemake() {
        return remake;
    }

    public void setRemake(String remake) {
        this.remake = remake;
    }

    public String getCycleRule() {
        this.cycleRule = StringUtils.getCycleRule(false, this.amount, ShieldCountUnitEnum.getName(this.countUnit), this.cycle, ShieldCycleUnitEnum.getName(this.cycleUnit));
        return cycleRule;
    }
}
