package cn.smarthse.modules.health.vo.work.reform;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 监管端-风险整改列表-页面展示model
 *
 * @author zhangxu
 * @date 2023-03-15
 */
public @Data
class RiskReformVo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * basic.id
	 */
	private  Long id;

	/**
	 * basic的状态
	 */
	private  Byte status;

	/**
	 * record表的状态
	 */
	private  Byte recordStatus;

	/**
	 * 整改是否超期状态 是否已超期（0、否；1、是；）
	 */
	private Byte overdueStatus;

	/**
	 * 验收是否超期状态
	 */
	private Byte overdueAccStatus;

	/**
	 * 整改和验收合并的超期超期状态
	 */
	private Byte overdueAccAndBasicStatus;

	/**
	 * 整改项来源(页面的哪个来源)
	 */
	private Integer reformItemSource;

	/**
	 * 整改名字
	 */
	private String  name;

	/**
	 * 公司名称
	 */
	private String  companyName;
	/**
	 * 公司地址拼接
	 */
	private String registerAddress;

	/**
	 * 区域名称和id
	 */
	private Long  areaId;
	private String areaName;

	/**
	 * 发现时间
	 */
	private Date findTime;
	private String findTimeStr;

	/**
	 * 实际完成时间(整改时间)
	 */
	private Date actualFinishTime;
	private String actualFinishTimeStr;

	/**
	 * 需要完成时间
	 */
	private Date requireFinishTime;

	/**
	 * 验收日期
	 */
	private Date acceptanceDate;
	private String acceptanceDateStr;

	private Byte companyLevel;
	private Byte generationSource;
}
