package cn.smarthse.modules.health.vo.work.reform;

import lombok.Data;
import java.io.Serializable;
import java.util.List;


/**
 * 监管端-风险整改列表-搜索model
 *
 * @author zhangxu
 * @date 2023-03-15
 */
@Data
public class RiskReformSearchVo implements Serializable {

    private static final long serialVersionUID = -7533000663368852969L;

    /**
     * 整改是否超期状态 是否已超期（0、否；1、是；）
     */
    private Byte overdueStatus;

    /**
     * 验收是否超期状态
     */
    private Byte overdueAccStatus;

    /**
     * 整改和验收合并的超期超期状态
     */
    private Byte overdueAccAndBasicStatus;

    /**
     * 状态 cn.smarthse.modules.health.enums.reform.ReformStatusEnum
     */
    private Byte status;
    /**
     * 风险来源 cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum
     */
    private Integer reformItemSource;

    /**
     * 整改名称/企业名称
     */
    private String keyword;

    private Long cid;

    /**
     * 发现年份
     */
    private Integer findYear;

    /**
     * 开始日期和结束日期
     */
    private String startDate;
    private String endDate;

    /**
     * 行政区划
     */
    private Long areaId;
    private Byte areaLevel;

    /**
     * 超期id
     */
    private List<Long> overTimeIdList;

    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）
     */
    private Integer companyLevel;

    private Boolean isCurrent;

    /**
     * 风险类型
     */
    private Integer riskType;

    /**
     * 是否只统计接害人数小于3的数据
     */
    private Boolean pickupCount= false;

    private Boolean isExistRadioactivity = false;//是否放射单位
}