package cn.smarthse.modules.health.vo.work.reform;

import cn.smarthse.common.framework.jqgrid.JqGridParam;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 *
 * 机构端：风险查询
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/6 9:19
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RiskReformGjSearch extends JqGridParam {

    private static final long serialVersionUID = -1923645181600308863L;
    /**
     * 搜索类型  风险化解清单-0 其他风险清单-1
     */
    private Integer searchType;
    /**
     * 整改项来源 ReformSourceLiteEnum， 默认 服务管家-9
     */
    private Integer reformItemSource = 9;
    /**
     * 区域Id
     */
    private Long areaId;
    /**
     * 区域等级
     */
    private Byte areaLevel;
    /**
     * 是否超期（0-未超期；1：已超期）
     */
    private Byte warningStatus;
    /**
     * 风险整改状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; 监管忽略-6（已废弃）；已终止-10)
     * 未化解-7 （1、2、5）
     *      待整改-1
     *      待验收-2
     *      退回-5
     * 已化解-3
     */
    private Byte reformStatus;
    /**
     * 风险类型 ReformGenerationSourceEnum
     * 100：负责人培训  generation_source in(17, 19, 20)
     *      主要负责人培训无数据
     *      管理人员培训无数据
     * 101：其它 generation_source NOT IN (10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 30, 40, 50, 21)
     * 其他： generation_source = riskType
     */
    private Integer riskType;
    /**
     * 整改项来源
     */
    private Long reformItemSourceId;

    /**
     * 等于true的时候筛选出无需推送
     */
    private Boolean isNoPushRequired = false;
}