package cn.smarthse.modules.health.vo.work.reform;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 *
 * 机构端：风险化解清单
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2023/7/18 9:19
 */
@Data
@Accessors(chain = true)
public class RiskReformGjListVo implements Serializable {

    private static final long serialVersionUID = 1715128131359616920L;
    /**
     * 风险Id
     */
    private Long id;
    /**
     * 风险Id
     */
    private Long sourceId;
    /**
     * 是否超期（0-未超期；1：已超期）
     */
    private Byte warningStatus;
    /**
     * 整改状态(草稿-0; 待整改-1; 待验收-2; 已完成-3; 无需整改-4; 退回-5; 监管忽略-6（已废弃）)
     */
    private Byte status;
    /**
     * 风险类型 ReformGenerationSourceEnum
     */
    private Integer generationSource;
    /**
     * 整改项名称
     */
    private String name;
    /**
     * 风险来源企业cid
     */
    private Long cid;
    /**
     * 风险来源企业name
     */
    private String companyName;
    /**
     * 企业注册地详址
     */
    private String registerAddress;
    /**
     * 发现时间
     */
    private Date findTime;
    /**
     * 整改时间
     */
    private Date actualFinishTime;
    /**
     * 验收时间
     */
    private Date acceptanceDate;

    private String findTimeStr;

    /**
     * 整改人
     */
    private String reformDirectorName;

    /**
     * 验收人
     */
    private String acceptanceDirectorName;

    public void setFindTime(Date findTime) {
        if (findTime == null) return;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.findTimeStr = format.format(findTime);
        this.findTime = findTime;
    }

    private String actualFinishTimeStr;

    public void setActualFinishTime(Date actualFinishTime) {
        if (actualFinishTime == null) return;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.actualFinishTimeStr = format.format(actualFinishTime);
        this.actualFinishTime = actualFinishTime;
    }

    private String acceptanceDateStr;

    public void setAcceptanceDate(Date acceptanceDate) {
        if (acceptanceDate == null) return;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.acceptanceDateStr = format.format(acceptanceDate);
        this.acceptanceDate = acceptanceDate;
    }

    /**
     * 识别时间（生成创建时间）
     */
    private String createDateStr;

    public void setCreateDate(Date createDate) {
        if (createDate == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        this.createDateStr = format.format(findTime);
        this.createDate = createDate;
    }

    /**
     * 创建时间
     */
    private Date createDate;
}