package cn.smarthse.modules.health.vo.work.reform;

import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceChildEnum;
import cn.smarthse.modules.health.enums.reform.ReformDataSourceEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@Accessors(chain = true)
public class ReformAddParam implements Serializable {

    private static final long serialVersionUID = -41409671529980944L;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 机构id (服务管家来源需要)
     */
    private Long thirdOrgId;

    /**
     * 整改发现人姓名（冗余）
     */
    private String finderName;

    /**
     * 发现时间
     */
    private Date findTime;

    /**
     * 整改项名称
     */
    private String name;

    /**
     * 整改项来源 ReformSourceLiteEnum
     */
    private Byte reformItemSource;

    /**
     * 整改项来源业务id（有就设置上）
     */
    private Long reformItemSourceId;

    /**
     * 生成的整改项类型 ReformGenerationSourceEnum
     */
    private Byte generationSource;

    /**
     * 生成的整改项类型generationSource的子项
     * @see  ReformGenerationSourceChildEnum
     */
    private Byte reformItemSourceType;

    /**
     * 整改项描述
     */
    private String description;

    /**
     * 创建人 （有就加上）
     */
    private Long createBy;

    /**
     * 整改措施（有就加上）
     */
    private String reformMeasure;

    /**
     * 数据来源
     * @see ReformDataSourceEnum
     */
    private Byte dataSource;

    /**
     * 整改项附件(有几十条在用，应该可以不要)
     */
    private String reformItemFiles;

    private String tjBusinessId;

}
