package cn.smarthse.modules.health.vo.work.judge;

import java.io.Serializable;

import lombok.Data;

/**
 * 
 * 《》培训证书信息
 * 显示职业卫生培训合格证书的取证人员清单（30-024）中人员类别为主要负责人、职业卫生管理人员的人数，以及证书在有效期内的人数。
 * 
 * 
 * @Project:  smarthse-entity
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.7> 
 * @author horsy(何世壹) [hsy@smarthse.cn]
 * @since 2018年7月31日-下午2:03:37
 */
public @Data class TrainCertificateInfo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 人员证书清单（30-013）中职业卫生培训合格证书数量
	 */
	private int ehsTrainCertificateNum;
	
	/**
	 * 企业主要负责人的培训证书数量
	 */
	private int managerTrainCertificateNum;

	/**
	 * 企业主要负责人的培训证书数量(有效)
	 */
	private int managerTrainCertificateNumValid;
	
	
	/**
	 * 企职业健康管理人员的培训证书数量
	 */
	private int ehsManagerTrainCertificateNum;
	
	/**
	 * 企职业健康管理人员的培训证书数量（有效的）
	 */
	private int ehsManagerTrainCertificateNumValid;
	
}
