package cn.smarthse.modules.health.vo.work.harmfactor;

import cn.smarthse.modules.health.vo.base.company.HarmFactoCheckResultVo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2020/11/5 09:13
 * @desc 岗位危害因素检测结果
 */
@Data
public class WorkHarmFactorVo implements Serializable,Cloneable {


    private Long checkId;//检测id
    private Long id; //危害因素id
    private String hazardSource; // 来源(采样点)
    private String name;// 危害因素名称
    private String type; //危害因素类型
    private Date checkDate;// 检测时间
    private String decision;//结果判定
    private Long workId;// 岗位id
    private Long resultNo;//结果集编号
    /**
     *  危害因素以及检测结果（有多个检测结果，则有这个几个结果的危害因素id相同）
     */
    private List<HarmFactoCheckResultVo> checkResultVos;

    private String sortNo; // 排序字段 （用于对列表进行排序）

    @Override
    public WorkHarmFactorVo clone() {
        WorkHarmFactorVo vo = new WorkHarmFactorVo();
        vo.setWorkId(this.workId);

        vo.setCheckDate(this.checkDate);
        vo.setCheckId(this.checkId);
        vo.setName(this.name);
        vo.setId(this.id);
        vo.setDecision(this.decision);
        vo.setResultNo(this.resultNo);
        vo.setHazardSource(this.hazardSource);
        vo.setSortNo(this.sortNo);
        vo.setCheckResultVos(this.checkResultVos);
        vo.setType(this.type);
        return vo;
    }
}
