package cn.smarthse.modules.health.vo.work.harmfactor;

import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: HarmRiskDataVo
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 35
 * @since 2020/10/13-10:35
 */
@Data
public class HarmRiskDataVo implements Serializable {
    private Long harmWorkId;
    /**
     * 接触方式1:定点；2：巡检
     */
    private Byte contactType;
    /**
     * 部门
     */
    private String detpName;
    /**
     * 区域
     */
    private Long workId;
    /**
     * 工种
     */
    private String workName;
    /**
     * 区域
     */
    private Long areaId;
    /**
     * 区域
     */
    private String areaName;
    /**
     * 危害名称
     */
    private String harmName;
    private Long harmId;
    private Long checkPlanId;
    /**
     * 危害种类
     */
    private String harmCategory;
    /**
     * 危害信息描述
     */
    private String harmDesc;
    /**
     * 风险描述
     */
    private String riskDesc;
    /**
     * 风险种类
     */
    private String riskCategory;
    /**
     * 风险范畴
     */
    private String riskScope;
    /**
     * 可能暴露于风险的人员、设备等其他信息
     */
    private String riskMaybeInfo;
    /**
     * 现有的控制措施
     */
    private String nowControlMeasures;
    /**
     * 风险等级分析 后果
     */
    private String aftermath;
    /**
     * 风险等级分析 暴露
     */
    private String reveal;
    /**
     * 风险等级分析 可能性
     */
    private String possibility;
    /**
     * 风险等级分析 风险值
     */
    private String riskValue;
    /**
     * 风险等级分析 风险等级
     */
    private String riskLevel;
    /**
     * 建议采取的控制措施
     */
    private String proposedControlMeasures;
}
