package cn.smarthse.modules.health.vo.work.evaluate;

import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.health.entity.work.evaluate.Evaluate;
import cn.smarthse.modules.health.entity.work.evaluate.EvaluateThird;
import cn.smarthse.modules.health.enums.evaluate.EvaluateTypeEnum;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Transient;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: EvaluateThirdModel
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 03
 * @since 2019/9/3-15:03
 */
public @Data
class EvaluateThirdModel extends Evaluate implements Serializable {



    /**
     * 检测点
     */
    private Integer checkPointCount;

    /**
     * 合格点
     */
    private Integer qualifiedPointCount;

    /**
     * 超标点
     */
    private Integer  notStandardPointCount;

    /**
     * 上报预评项目数量（XX）
     */
    private Integer  uploadPreEvaluateCount=0;
    /**
     * 上报控评项目数量（XX）
     */
    private Integer  uploadContrEvaluateCount=0;


    /**
     * 超标率
     */
    private String notStandardRate;

    private String workName;

    /**
     * 评价类型
     */
    private Byte evaluateType;

    /**
     * 检测ID
     */
    private Long checkplanId;

    private Long targetStandardId; //检测使用的标准id

    /**
     * 职业病危害类别   1一般  2较重    3严重
     */
    private Byte occType;
    /**
     * 评价类型
     */
    private String evaluateTypeName;
    private String proxyCname;
    private String evaluateOrgCname;
    private Date uploadDate;
    private String uploadPerson;

    private Byte uploadState;
    /**
     * 状态
     */
    private String uploadStateName;

    /**
     *
     */
    private String occTypeName;


    /**
     * 项目联系人
     */
    private String projectContact;

    /**
     * 联系电话
     */
    private String projectContactTel;
    private Long projectAreaId;
    private String projectAreaAddress;
    /**
     * 检测 存在的危害因素
     */
    private String hcCheckHarms;

    /**
     * 不符合项数量
     */
    private Integer overproofCount;
    public String getUploadStateName() {
        if (this.getUploadState() != null) {
            if (this.getUploadState() == 1) {
                return "草稿";
            }else if (this.getUploadState() == 2) {
                return "已上报";
            }else if (this.getUploadState() == 3) {
                return "被退回";
            }
        }

        return "";
    }

    public String getOccTypeName() {
        if (this.getOccType() == null) {
            return "";
        }else {
            return CompanyOccTypeEnum.getName(this.getOccType().intValue());
        }

    }

    public String getEvaluateTypeName() {
        if (this.getEvaluateType() != null) {

            return EvaluateTypeEnum.getEvaluateTypeName(this.getEvaluateType());

        }

        return "";
    }
}
