package cn.smarthse.modules.health.vo.summary;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ReformSearchVo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * 企业ID，不能为空
	 */
	private Long cid;
	
	/**
	 * 第几页,大于0
	 */
    private int pageNum;

    /**
     * 每页数量，大于0，如果是：Integer.MAX_VALUE，则返回所有
     */
    private int pageSize;
	
	/**
	 * 隐患编号，可以为空
	 */
	private String reformSn;
	
	/**
	 * 隐患类型，见枚举：ReformItemTypeEnum，可以为空
	 */
	private List<Byte> reformType;
	
	/**
	 * 隐患等级，见枚举：ReformItemLevelEnum，可以为空
	 */
	private List<Byte> reformLevel;
	
	/**
	 * 隐患发现时间：开始，可以为空
	 */
	private Date findDateStart;
	
	/**
	 * 隐患发现时间：结束，可以为空
	 */
	private Date findDateEnd;
	
	/**
	 * 隐患来源：见枚举ReformSourceEnum，可以为空
	 */
	private List<Byte> reformSource;
	
	/**
	 * 是否整改完成，空：则返回所有，true：返回完成整改，false：返回整改未完成。
	 */
	private Boolean isReformFinished;

	public int getPageNum() {
		return pageNum;
	}

	public void setPageNum(int pageNum) {
		this.pageNum = pageNum;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public String getReformSn() {
		return reformSn;
	}

	public void setReformSn(String reformSn) {
		this.reformSn = reformSn;
	}

	public List<Byte> getReformType() {
		return reformType;
	}

	public void setReformType(List<Byte> reformType) {
		this.reformType = reformType;
	}

	public List<Byte> getReformLevel() {
		return reformLevel;
	}

	public void setReformLevel(List<Byte> reformLevel) {
		this.reformLevel = reformLevel;
	}

	public Date getFindDateStart() {
		return findDateStart;
	}

	public void setFindDateStart(Date findDateStart) {
		this.findDateStart = findDateStart;
	}

	public Date getFindDateEnd() {
		return findDateEnd;
	}

	public void setFindDateEnd(Date findDateEnd) {
		this.findDateEnd = findDateEnd;
	}

	public List<Byte> getReformSource() {
		return reformSource;
	}

	public void setReformSource(List<Byte> reformSource) {
		this.reformSource = reformSource;
	}

	public Boolean getIsReformFinished() {
		return isReformFinished;
	}

	public void setIsReformFinished(Boolean isReformFinished) {
		this.isReformFinished = isReformFinished;
	}

	public Long getCid() {
		return cid;
	}

	public void setCid(Long cid) {
		this.cid = cid;
	}
	
}
