package cn.smarthse.modules.health.vo.riskResolve;


import cn.smarthse.modules.health.enums.reform.ReformResolveStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author 覃浩云 1770126791@qq.com
 * @version 1.0
 * @description 风险化解示警清单Vo
 * @date 2023/5/15 13:00
 */
@Data
public class RiskWarnFormVo implements Serializable {
    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省id
     */
    private Long provinceId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 城市id
     */
    private Long cityId;

    /**
     * 区域名称
     */
    private String areaName;

    /**
     * 区域id
     */
    private Long areaId;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道id
     */
    private Long streetId;

    /**
     * 区域等级
     */
    private Byte areaLevel;

    /**
     * 已化解风险数量(已化解风险需要累加）
     */
    private Integer riskResolvedNum;

    /**
     * 示警状态
     */
    private Byte warnStatus;

    /**
     * 风险数量
     */
    private Integer riskNum=0;

    /**
     * 首次推送数量
     */
    private Integer firstPushNum=0;

    /**
     * 黄色预警数量
     */
    private Integer yellowAlertNum=0;

    /**
     * 红色预警数量
     */
    private Integer redAlertNum=0;

    /**
     * 启动执法数量
     */
    private Integer exLawNum=0;

    /**
     * 更新时间
     */
    private Date updateDate;


    public void setValue(Byte type, Integer riskNum) {
        switch (Objects.requireNonNull(ReformResolveStatusEnum.getByType(type))) {
            case FIRSTPUSH:
                this.firstPushNum = riskNum;
                break;
            case YELLOWWARN:
                this.yellowAlertNum = riskNum;
                break;
            case REDWARN:
                this.redAlertNum = riskNum;
                break;
            case STARTPUNISH:
                this.exLawNum = riskNum;
                break;
            default:
                break;
        }
    }
}
