package cn.smarthse.modules.health.vo.riskResolve;

import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceChildEnum;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import lombok.Data;

import javax.persistence.Transient;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author 覃浩云 1770126791@qq.com
 * @version 1.0
 * @description 风险化解结果验收清单
 * @date 2023/5/10 18:18
 */
@Data
public class RiskResolveResInfoVo implements Serializable {
    /**
     * 企业id
     */
    private Long cid;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;

    /**
     * 是否存在放射性（是否非医用放射单位）
     */
    private Boolean isExistRadioactivity;

    /**
     * 营业状态（1-正常，2-暂停营业，0-关闭）
     */
    private Integer businessState;

    /**
     * 企业注册地详址
     */
    private String registerAddress;

    /**
     * 直属企业类型（0-非直属，1-省直属，2-市属）
     */
    private Integer companyLevel;

    /**
     * 职业卫生管理联系人
     */
    private String occManagerName;

    /**
     * 职业卫生管理联系人电话
     */
    private String occManagerTel;

    /**
     * 企业主要负责人
     */
    private String mainLeaderName;

    /**
     * 负责人手机号码
     */
    private String mainLeaderTel;

    /**
     * 风险Id
     */
    private Long id;

    /**
     * 风险名称
     */
    private String name;

    /**
     * 整改项来源（关键因素画像..)
     */
    private Byte reformItemSource;

    /**
     * 整改项来源Id
     */
    private Long reformItemSourceId;

    /**
     * 生成来源（风险类型） ReformSourceLiteEnum
     */
    private Byte generationSource;
    /**
     * 生成的整改项类型generationSource的子项
     * @see  ReformGenerationSourceChildEnum
     */
    private Byte reformItemSourceType;
    /**
     * 发现时间
     */
    private Date findTime;

    private String findTimeStr;

    public void setFindTime(Date findTime) {
        if (findTime!=null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.findTimeStr = format.format(findTime);
        }
        this.findTime = findTime;
    }



    /**
     * 发现人
     */
    private String finderName;

    /**
     * 整改状态
     */
    private Byte status;

    /**
     * 是否自动生成的整改项
     */
    private Byte autoGeneration;

    /**
     * 风险描述
     */
    private String description;

    /**
     * 是否在整改模块列表显示（true 代表非已完成状态同类型显示一条）
     */
    private Boolean showInReform;

    /**
     * 示警状态
     */
    private Byte warningStatus;

    /**
     * 整改时间
     */
    private Date actualFinishTime;

    private String actualFinishTimeStr;

    public void setActualFinishTime(Date actualFinishTime) {
        if (actualFinishTime!=null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.actualFinishTimeStr = format.format(actualFinishTime);
        }
        this.actualFinishTime = actualFinishTime;
    }

    /**
     * 验收时间
     */
    private Date acceptanceDate;

    /**
     * 整改负责人姓名
     */
    private String reformDirectorName;

    /**
     * 验收负责人姓名
     */
    private String acceptanceDirectorName;

    private String acceptanceDateStr;

    public void setAcceptanceDate(Date acceptanceDate) {
        if (acceptanceDate!=null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.acceptanceDateStr = format.format(acceptanceDate);
        }
        this.acceptanceDate = acceptanceDate;
    }

    @Transient
    private ZjArchiveCountView archiveCountView;

    /**
     * 整改验收记录列表
     */
    private List<ReformItemAcceptanceRecord> reformItemAcceptanceRecordList;

    //三同时相关数量
    private Integer threeTimeDys;//待验收
    private Integer threeTimeCg;//草稿
    private Integer threeTimeBack;//退回
}
