package cn.smarthse.modules.health.vo.riskResolve;

import cn.smarthse.modules.health.enums.reform.ReformGenerationSourceEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author 覃浩云 1770126791@qq.com
 * @version 1.0
 * @description 监管端可视化-风险化解-待验收+其他风险化解，未化解风险（11项）
 * @date 2023/5/15 17:05
 */
@Data
public class RiskResolveInfoVo implements Serializable {
    /**
     * 统计数据（xx)
     */
    private Integer countNum;

    /**
     * 首次预警
     */
    private Integer firstAlert;
    /**
     * 黄色预警
      */ 
    private Integer yellowAlert;
    /**
     * 红色预警
     */
    private Integer redAlert;
    /**
     * 启动执法
     */
    private Integer executeLaw;

    /**
     * 类型
     */
    private Byte type;

    /**
     * 职业病危害申报
     */
    private Integer declareNum = 0;

    /**
     * 职业健康检查
     */
    private Integer healthCheckNum = 0;

    /**
     * 职业病危害因素检测
     */
    private Integer hazardFactorsNum = 0;

    /**
     * 企业负责人培训
     */
    private Integer trainNum = 0;

    /**
     * 三同时
     */
    private Integer threeNum = 0;

    /**
     * 防护用品
     */
    private Integer protectNum = 0;

    /**
     * 警示标识
     */
    private Integer warnSignNum = 0;

    /**
     * 卫生档案
     */
    private Integer healthArchivesNum = 0;

    /**
     * 检测超标整改
     */
    private Integer overTestNum = 0;

    /**
     * 禁忌症
     */
    private Integer contraindicationsNum = 0;

    /**
     * 疑似职业病
     */
    private Integer occupationalDiseaseNum = 0;

    /**
     * 体检结果异常整改(禁忌症+疑似职业病）
     */
    private Integer physicalResultNum = 0;

    /**
     * 监测结果超标整改
     */
    private Integer monitorResultOverNum = 0;

    public void setValue(Byte type, Integer typeNum) {
        switch (Objects.requireNonNull(ReformGenerationSourceEnum.getByType(type))) {
            case DECLARE:
                this.declareNum = typeNum;
                break;
            case TJ:
                this.healthCheckNum = typeNum;
                break;
            case DETECTION:
                this.hazardFactorsNum = typeNum;
                break;
            case TRAIN:
                this.trainNum = typeNum;
                break;
            case THREE_TIME:
                this.threeNum = typeNum;
                break;
            case PROTECTION:
                this.protectNum = typeNum;
                break;
            case WARNING_SIGNS:
                this.warnSignNum = typeNum;
                break;
            case ARCHIVES:
                this.healthArchivesNum = typeNum;
                break;
            case JCCB:
                this.overTestNum = typeNum;
                break;
            case JCCBZG:
                this.monitorResultOverNum = typeNum;
                break;
            case JJZ:
                this.contraindicationsNum = typeNum;
                break;
            case YSZYB:
                this.occupationalDiseaseNum = typeNum;
                break;
            default: break;
        }
    }

}
