package cn.smarthse.modules.health.vo.riskResolve;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: DengJia
 * @Date: 2023/9/6
 * @Description: 行政区划风险数量统计（汇总）
 */

@Data
@Accessors(chain = true)
public class RegionRiskStatisticsVo implements Serializable {
    private static final long serialVersionUID = 8615244462023325723L;

    /**
     * 当前信息页面上级行政区划id
     */
    private Long nowInfoPageParentId;

    /**
     * 当前信息页面上级行政区划名称
     */
    private String nowInfoPageParentName;

    /**
     * 已化解风险总数
     */
    private Long totalResolveNum;

    /**
     * 已化解风险企业总数
     */
    private Long totalResolveComNum;

    /**
     * （合计）轻微不处罚减免罚金[下限]（百万元）
     */
    private BigDecimal lessImpunityDecreaseCostSum;

    /**
     * （合计）轻微不处罚减免罚金[上限]（百万元）
     */
    private BigDecimal mostImpunityDecreaseCostSum;

    /**
     * （合计）风险化解减免罚金[下限]（百万元）
     */
    private BigDecimal lessRiskSolveDecreaseCostSum;

    /**
     * （合计）风险化解减免罚金[上限]（百万元）
     */
    private BigDecimal mostRiskSolveDecreaseCostSum;

    /**
     * 合计减免行政处罚成本（百万元）
     */
    private BigDecimal lessDecreasePunishmentCostSum;

    /**
     * 合计减免行政处罚成本（百万元）
     */
    private BigDecimal mostDecreasePunishmentCostSum;

    /**
     * 最低减免行政处罚额度区域总数（万）
     */
    private BigDecimal lessFreePunishAmountSum;

    /**
     * 最高减免行政处罚额度区域总数（万）
     */
    private BigDecimal mostFreePunishAmountSum;

    /**
     * 免于处罚额度 汇总
     */
    private BigDecimal totalFreePunishAmount;

    /**
     * 当年累计避免行政处罚额度，往前半年备份数据+当前页面统计的实时数据（换算单位后的数值）
     */
    private String freePunishAmount;

    private List<RegionRiskNumInfoVo> regionRiskNumInfoVoList;
}
