package cn.smarthse.modules.health.vo.riskResolve;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: DengJia
 * @Date: 2023/9/6
 * @Description: 行政区划风险数量统计
 */

@Data
@Accessors(chain = true)
public class RegionRiskNumInfoVo implements Serializable {
    private static final long serialVersionUID = -6505595132040681742L;

    /**
     * 行政区划id
     */
    private Long regionId;

    /**
     * 行政区划名称
     */
    private String regionName;

    /**
     * 申报 统计数量
     */
    private Integer declare;

    /**
     * 体检 统计数量
     */
    private Integer tj;

    /**
     * 检测 统计数量
     */
    private Integer detection;

    /**
     * 培训 统计数量
     */
    private Integer train;

    /**
     * “三同时” 统计数量
     */
    private Integer threeTime;

    /**
     * 个人防护用品 统计数量
     */
    private Integer protection;

    /**
     * 警示标识 统计数量
     */
    private Integer warningSigns;

    /**
     * 档案 统计数量
     */
    private Integer archives;

    /**
     * 已化解风险企业数
     */
    private Long resolveComNum;

    /**
     * 未推送风险企业数
     */
    private Long noPushComNum;

    /**
     * 已化解的单个培训（存在“培训风险”，且不存在“体检风险”）的企业数
     */
    private Long singleResolvePxNum;

    /**
     * 已化解的单个体检（存在“体检风险”，且不存在“培训风险”）的企业数
     */
    private Long singleResolveTjNum;

    /**
     * 已化解的2个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve2Num;

    /**
     * 已化解的3个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve3Num;

    /**
     * 已化解的4个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve4Num;

    /**
     * 已化解的5个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve5Num;

    /**
     * 已化解的6个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve6Num;

    /**
     * 已化解的7个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve7Num;

    /**
     * 已化解的8个风险数（存在“培训风险”且存在“体检风险”）的企业数
     */
    private Long multipleResolve8Num;

    /**
     * 轻微不处罚减免罚金[下限]（百万元）
     */
    private BigDecimal lessImpunityDecreaseCost;

    /**
     * 轻微不处罚减免罚金[上限]（百万元）
     */
    private BigDecimal mostImpunityDecreaseCost;

    /**
     * 风险化解减免罚金[下限]（百万元）
     */
    private BigDecimal lessRiskSolveDecreaseCost;

    /**
     * 风险化解减免罚金[上限]（百万元）
     */
    private BigDecimal mostRiskSolveDecreaseCost;

    /**
     * 至少减免行政处罚成本（百万元）
     */
    private BigDecimal lessDecreasePunishmentCost;

    /**
     * 最多减免行政处罚成本（百万元）
     */
    private BigDecimal mostDecreasePunishmentCost;

    /**
     * 最低减免行政处罚额度（万）
     */
    private BigDecimal lessFreePunishAmount;

    /**
     * 最高减免行政处罚额度（万）
     */
    private BigDecimal mostFreePunishAmount;

    /**
     * 免于处罚额度
     */
    private BigDecimal freePunishAmount;
}
