package cn.smarthse.modules.health.vo.riskResolve;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Author: DengJia
 * @Date: 2024/12/10
 * @Description: 历史记录，避免行政处罚经济账统计数据。
 */

@Data
@Accessors(chain = true)
public class RegionHistoryPunishInfo implements Serializable {
    private static final long serialVersionUID = 3088136981660850582L;

    /**
     * 此字段入参用，查询年份（若多个，逗号分隔）对应的累计避免行政处罚额度。
     */
    private String yearParams;

    /**
     * 行政区划id
     */
    private Long areaId;

    /**
     * 行政区划等级
     */
    private Byte areaLevel;

    /**
     * 是否本级
     */
    private Boolean isCurrent;

    /**
     * 是否粉尘一体化企业（1是 0否）
     */
    private Integer isFcImportanceCompany;

    /**
     * 单个年份，比如：2024上半年（202401），2024下半年（202402）。
     */
    private Integer year;

    /**
     * 结算截止日期
     */
    private String closingDate;

    /**
     * 对应年份累计避免行政处罚额度（换算单位后的数值）
     */
    private String freePunishAmount;
}
