package cn.smarthse.modules.health.vo.outdata.evaluate;

import cn.smarthse.common.util.valid.DataValida;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: EvaluateInfo
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 17
 * @since 2022/2/16-16:17
 */
@Data
public class EvaluateInfo implements Serializable {
    /**
     * 评价委托时间
     */
    @DataValida(name= "评价委托时间",nullAble = false)
    private String proxyDateStr;
    /**
     * 报告评审时间
     */
    @DataValida(name= "报告评审时间",nullAble = false)
    private String reviewDateStr;
    /**
     * 职业病危害类别
     */
    @DataValida(name= "职业病危害类别",nullAble = false)
    private String occTypeName;
    /**
     * 现状评价报告出具时间
     */
    @DataValida(name= "现状评价报告出具时间",nullAble = false)
    private String reportIssueDateStr;

    /**
     * 职业病防护设施验收时间
     */
    @DataValida(name= "职业病防护设施验收时间",nullAble = false)
    private String occShieldCheckTimeStr;
    /**
     * 存在的主要职业病危害因素
     */
    private String mainOccHazards;
    /**
     * 报告评审意见
     */
    private String reportReviewComments;
    /**
     * 评价委托书
     */
    private String evaluateProxyAttrUrl;
    /**
     * 评审人员签名表
     */
    private String reviewerSignAttrUrl;
    /**
     * 评审意见及评审意见修改说明
     */
    private String reportReviewCommentsModiDesc;
    /**
     * 控评报告电子版
     */
    private String reportAttrUrl;
}
