package cn.smarthse.modules.health.vo.outdata.evaluate;

import cn.smarthse.common.util.valid.DataValida;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: BaseInfo
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 17
 * @since 2022/2/16-16:17
 */
@Data
public class EvaluateBaseInfo implements Serializable {
    /**
     * 现状评价项目id
     */
    private Long evaluateId;
    /**
     * 现状评价项目名称
     */
    private String projectName;
    /**
     * 委托企业名称:new
     */
    @DataValida(name= "委托企业名称",nullAble = false)
    private String proxyCompanyName;
    /**
     * 委托企业的统一社会信用代码
     */

    @DataValida(name= "委托企业的统一社会信用代码",nullAble = false)
    private String proxyCompanySocialCc;
    /**
     * 项目地址格式: 浙江省>杭州市>江干区 ：new
     */
//    @DataValida(name= "项目地址",nullAble = false)
    private String projectArea;
    /**
     * 项目详细地址
     */
    private String projectAddress;
    /**
     * 评价报告编制单位名称
     */
    private String reportEditOrgName;
    /**
     * 评价报告编制单位统一社会信用代码
     */
    private String editOrgSocialCc;
    /**
     * 上传人 :new
     */
    private String uploadPerson;
    /**
     * 项目联系人
     */
    private String projectContact;
    /**
     * 项目联系人电话
     */
    private String projectContactTel;
}
