package cn.smarthse.modules.health.vo.outdata.company;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: CompanyInfo
 * @Project:
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 53
 * @since 2022/2/28-16:53
 */
@Data
public class CompanyInfo implements Serializable {
    /**
     * 企业名称
     */
    private String name;
    /**
     * 企业类型：用人单位， 外包单位
     */
    private String companyTypeName;
    /**
     * 企业名称简称
     */
    private String shortName;
    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;
    /**
     * 企业联系电话
     */
    private String companyContactTel;
    /**
     * 企业电子邮箱
     */
    private String companyContactEmail;
    /**
     * 企业注册地详址
     */
    private String registerAddress;
    /**
     * 工作产所地址（省市区，-分割。如：浙江省-杭州市-西湖区）
     */
    private String workarea;
    /**
     * 工作产所地址详细地址
     */
    private String workAddress;
    /**
     * 注册类型
     */
    private String registerTypeName;
    /**
     * 行业分类
     */
    private String industryCategoryName;
    /**
     * 职业病危害类别：严重、较重、一般
     */
    private String occupationalRiskClassifyName;
    /**
     * 在岗职工人数
     */
    private String staffCount;
    /**
     * 接害人数（不重复计）
     */
    private String pickupCount;
    /**
     * 主营营业收入（万元）
     */
    private String mainOperaIncome;
    /**
     * 企业规模：大型企业、中型企业、小型企业、微型企业
     */
    private String scaleName;
    /**
     * 法人代表姓名
     */
    private String legalName;
    /**
     * 法人代表联系电话
     */
    private String legalTel;
    /**
     * 化学事故应急咨询服务电话
     */
    private String chemicalEmergencyPhone;
    /**
     * 企业主要负责人
     */
    private String mainLeaderName;
    /**
     * 负责人手机号码
     */
    private String mainLeaderTel;
    /**
     * 职业卫生管理联系人
     */
    private String occManagerName;
    /**
     * 职业卫生管理联系人电话
     */
    private String occManagerTel;
}
