package cn.smarthse.modules.health.vo.litearchive;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2021/4/27 15:28
 * @desc 档案文件-附件详情
 */
@Data
public class LiteArchiveFileDetailVo implements Serializable {

    private static final long serialVersionUID = 4032978638523364903L;

    private Long cid;
    /** 档案id */
    private Long liteArchiveId;
    private Long itemId;
    private Long fileNameId;//文件名id
    private String title; //文件名
    private String fileName; //文件名
    private String fileIds;//附件id，多个
    private String referFileIds;//参考资料附件id，多个refer_file_ids
    private List<SysFileModel> fileList = new LinkedList<>();//附件对象列表
    private List<SysFileModel> referFileList = new LinkedList<>();//参考资料附件对象列表
    private String templatePath;//附件模板下载地址
    private Long uploadStaffId;//上传人id
    private String uploadStaffName;//上传人姓名
    private Date uploadDate; ////上传时间
    private Integer archiveType;//第几个档案


    //是否需要纳入统计， 默认0  不统计
    private Boolean needCollect;
    /**
     * 是否需要存放位置， 默认0  不统计
     */
    private Boolean needStorageLocation;
    private String storageLocation;



    private Integer hgDataState;
    /**
     * 1 必填，  0 非必填，  其他状态待定所以使用Integer 类型
     */
    private Integer isRequired;
    private Integer hgIsRequired;
    /**
     * 数据状态， 1完整， 0未完整
     */
    private Integer dataState=0;
    private String jumpUrl;
    private Integer needUpload;
    /**
     * 合规企业 是否上传附件
     */
    private Integer hgNeedUpload;
    private Integer sort;
    private String groupName;
    private String tipInfo;
    //内容处显示的文字
    private String content;
    //参考资料处显示的文字
    private String reference;
}
