package cn.smarthse.modules.health.vo.base.selfjudge;

import cn.smarthse.common.annotation.excel.ColMetaData;
import cn.smarthse.common.annotation.excel.ExcelFormatterValid;
import cn.smarthse.common.annotation.excel.ExcelValid;
import cn.smarthse.common.annotation.excel.ImportCol;
import lombok.Data;

import java.io.Serializable;

@Data
public class SelfJudgeSituationVo  implements Serializable {

    @ExcelValid(simple = true)
    @ImportCol(colMetaData = {@ColMetaData(sheetName = "合理缺项情况说明",colName = "企业名称",colIndex = 0),@ColMetaData(sheetName = "未达到完全符合的整改措施",colName = "企业名称",colIndex = 0)})
    private String companyName;

//    private String companySysName; //这是通过系统查询出来的 放到这里的

    private Long cid;

    @ExcelFormatterValid(regexExp = "^(\\d|\\D){18}$", errMsg = "统一社会信用代码不是18位")
    @ExcelValid(simple = true)
    @ImportCol(colMetaData = {@ColMetaData(sheetName = "合理缺项情况说明",colName = "统一社会信用代码",colIndex = 1),@ColMetaData(sheetName = "未达到完全符合的整改措施",colName = "统一社会信用代码",colIndex = 1)})
    private String unifyCode;

    @ImportCol(colMetaData = {@ColMetaData(sheetName = "合理缺项情况说明",colName = "项目编号",colIndex = 2),@ColMetaData(sheetName = "未达到完全符合的整改措施",colName = "项目编号",colIndex = 2)})
    private Integer termNo;

    @ImportCol(colMetaData = {@ColMetaData(sheetName = "合理缺项情况说明",colName = "情况说明",colIndex = 3),@ColMetaData(sheetName = "未达到完全符合的整改措施",colName = "情况说明",colIndex = 3)})
    private String situation;
}
