package cn.smarthse.modules.health.vo.base.company.gradev3;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class SelfReportCollectVo implements Serializable {
    public SelfReportCollectVo() {

    }
    public SelfReportCollectVo(Long cid) {
        this.cid = cid;
    }

    private Long cid;

    private String evaluateChangeReason; //默认值

    //==================================业务主键ID====================
    //调查风险评估表id
    private Long riskId;
    //防治责任自查等级id
    private Long selfId;
    //评估id
    private Long evaluateId;
    private Integer evaluateType=1; //默认值



    //==================================评估等级====================
    //职业病危害暴露风险等级(风险判定结论) 0:未评定  1:低风险2:中风险3:高风险
    private Integer riskLevel;
    //防治责任自查等级,0:未评定 1:A级 2:B级 3:C级
    private Integer judgeLevel;
    private Integer realJudgelevel;
    //综合风险类别,0:未评定 1:甲 2:乙 3:丙
    private Integer  gradeLevel;



    //==================================更新时间====================
    //暴露风险评估  更新时间
    private Date riskUpdateDate;
    //防治责任自查 更新时间
    private Date judgeUpdateDate;
    //评估报告 更新时间
    private Date evaluateUpdateDate;


    //==================================审核状态====================
    //暴露风险评估审核状态，  -1：已退回， 0：待审核， 1已审核
    private Integer riskCheckState;
    //防治责任自查审核状态，  -1：已退回， 0：待审核， 1已审核
    private Integer judgeCheckState;
    //评估报告审核状态，  -1：已退回， 0：待审核， 1已审核
    private Integer evaluateCheckState;


    //==================================是否有更新====================
    //暴露风险评估 是否有更新
    private Boolean riskHasUpdate=false;
    //防治责任自查 是否有更新
    private Boolean judgeHasUpdate=false;

}
