package cn.smarthse.modules.health.vo.base.company.gradev3;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import lombok.Data;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

@Data
public class GradeSearchV314 implements Serializable {
    /**
     * @Comments: <分级分类V311>
     * @author BinXu(徐斌) [784514607@qq.com]
     * @param type 1:occupationalRiskClassify (subType=职业病危害风险分类 0-严重、1-较重、2-一般 3-未细分 4-未划分 )
     * 2:judgeLevel (subType=职业健康管理状况等级 0:未评定 1:A级 2:B级 3:C级)
     * 3:riskLevel (subType=职业病危害暴露风险等级 0:未评定 1:低风险2:中风险3:高风险)
     * 4:riskClassify (subType=职业病危害综合风险类别 0:未评定 1:甲类2:乙类3:丙类)
     * @since 下午4:12 2022/1/12
     **/
    private Integer type;

    private Integer subType;
    /**
     * 综合风险类别
     */
    private Integer gradeLevel;

    /**
     * 评估类型
     */
    private Integer evaluateType;

    /**
     * 职业病危害综合风险类别
     */
    private Integer riskClassify;

    private Long areaId;
    private Byte areaLevel;
    private Long orgAreaId;
    private Byte orgAreaLevel;
    /**
     * 未评估企业
     */
    private Boolean noEvaluate;
    /**
     * 暴露风险评估数据有更新的企业
     */
    private Boolean hasNewRiskData;
    /**
     *
     */
    private Boolean onlySelfReport;
    /**
     * 重点核查对象  重要
     */
    private Boolean majorCheckTarget;
    /**
     * 仅显示本级企业
     */
    private Boolean onlyThislevel;

    /**
     * 含行业分类结果
     */
    private Boolean byInduCollect;
    /**
     * 无职业病危害风险类别企业
     */
    private Boolean noOccType;
    /**
     * 建议关注企业:接害＜3，且企业规模是大型和中型的
     */
    private Boolean suggestFollow;
    /**
     * 审核状态
     */
    private Integer check;
    private Integer checkState;

    /**
     * 选择自查表状态
     */
    private Integer selfSubmitState;

    /**
     * 选择自查表状态
     */
    private Integer riskSubmitState;

    /**
     * 选择综合评估报告状态
     */
    private Integer evaluateSubmitState;
    /**
     * 企业名称
     */
    private String companyName;
    /**
     * 包含 未评定企业
     */
    private Boolean containUnEvaluate = false;
    private Boolean containLess3Result ;

    /**
     * 数据范围 <option value="0" data-tip="统计范围：" selected>本年度分类企业数据</option>
     * <option value="1">历年分类企业数据</option>
     * 1历年分类企业数据 0 本年度分类企业数据
     */
    private Byte dataRange;

    /**
     * 经营状态
     * -1 全部（正常+暂停） 0 关闭 1 正常营业 2 暂停营业
     */
    private Byte businessState;

    /**
     * 重点行业
     * -1 > 全部重点行业
     * 1 > 矿山行业
     * 2 > 冶金行业
     * 3 > 化工行业
     * 4 > 建材行业
     * 0 > 非重点行业
     */
    private String impIndustry;

    /**
     * 健康企业
     */
    private Byte isBest;
    /**
     * 分类统计时间
     */
    private Integer gradeYear;

    private Integer calcBelongType = 0;


    /**
     * 是否新申报企业
     */
    private Integer isNewDeclared;

    /**
     * 1仅显示劳务派遣单位
     * 0 仅显示非劳务派遣单位
     */
    private Integer onlyLaborDispatch;

    /**
     * 接害人数的筛选条件：1:＜3人；2:≥3人
     * '<3人', '≥3人', '无数据'
     */
    private String pickupCount3;
    /**
     * 组织架构
     */
    private String organizationId;
    private String orgTreePath;
    private List orgIdList;

    /**
     * 企业规模
     */
    private Byte scale;
    /**
     * 分类对象入库时间
     */
    private Integer companyCreateDate;
    /**
     * 分类依据：0无来源， 1接害三人以下企业 2 分类自查 3 根据行业划分  4 依据容错自纠调整
     */
    private String gradeSource;
    private Date companyCreateDateStart;
    private Date companyCreateDateEnd;

    /**
     * 导入批号
     */
    private String importBatchNo;
    private String importBatchNoMonth;

    /**
     * 是否粉尘一体化企业   1是， 0否
     */
    private Integer isFcImportanceCompany;
    /**
     * @description 新增申报企业
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/2/19 16:17
     */
    private String addDeclareCompany;

    /**
     * 是否批量查询标识：
     * 为 `true` 时，查询当前行政区划的所有子行政区划，符合查询条件的【用人单位职业病危害综合风险分类列表】中的企业数量。
     */
    private Boolean batchSubRegionSearch;
    /**
     * 纳入分类原因,见CompanyGradeReasonEnum
     */
    private String enterDecReason;
    private List<Long> enterDecReasonList;
    private List<Long> specialEnterDecReasonList;
    /**
     * @description
     * @return java.util.List<java.lang.Integer>
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/4/30 8:51
     */
    public List<Long> getEnterDecReasonList() {
        Set<Long> reasonSet = CommonUtil.str2LongSet(enterDecReason, ",");
        if (CollUtil.isEmpty(reasonSet)) {
            return null;
        }
        if (reasonSet.contains(1L)) {
            // 2024 特殊处理
            if (Objects.equals(enterDecYear, "2024")) {
                reasonSet.remove(1L);
            }else if (Objects.equals(enterDecYear, "2023") || StringUtils.isBlank(enterDecYear)) {
                reasonSet.add(7L);
            }
        }
        return reasonSet.stream().collect(Collectors.toList());
    }
    public List<Long> getSpecialEnterDecReasonList() {
        Set<Long> reasonSet = CommonUtil.str2LongSet(enterDecReason, ",");
        if (CollUtil.isEmpty(reasonSet)) {
            return null;
        }
        if (reasonSet.contains(1L)) {
            if (Objects.equals(enterDecYear, "2024")) {
                return Arrays.asList(1L);
            }
        }
        return null;
    }

    /**
     * 纳入分类年份
     */
    private String enterDecYear;
}
