package cn.smarthse.modules.health.vo.base.company.gradev3;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.enums.CompanyOccTypeEnum;
import cn.smarthse.modules.datacentre.enums.CompanySizeEnum;
import cn.smarthse.modules.health.entity.base.company.grade.CompanyGradeV3;
import cn.smarthse.modules.health.enums.home.grade.CompanyGradeEnum;
import cn.smarthse.modules.health.enums.home.grade.GradeSourceEnum;
import cn.smarthse.modules.health.enums.selfjudge.HazardsExposureRiskLevelEnum;
import cn.smarthse.modules.health.enums.selfjudge.JudgeResultLevelEnum;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 企业信息-分级分类表-第三版
 * </p>
 *
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @since 2022-01-10
 */
@Data
public class CompanyGradeVoV314 extends CompanyGradeV3 {
    private long inx=1;

    private String companyName;
    private String unifiedSocialCc;


    private  Long  areaId;


    private String provinceName;

    private String  cityName;

    private  String areaName;

    private String streetName;

    private String areaFullName;
    private String workAddress;
    private String registerAddress;

    private String industryCategoryName;


    //是否重点核查对象
    private String isRiskType;
    //是否重点核查对象
    private String importantCheckName;

    /**
     * 综合风险分类
     */
    private String gradeName;

    /**
     * 已审核的分类结果
     */
    private Integer rgrade;
    private String rgradeName;
    private Integer gradeSource;
    private String gradeSourceName;

    /**
     * 评估报告 审核状态
     */
//    private String evaluateCheckStateName;

    /**
     * 职业健康管理状况等级
     */
    private String judgeLevelName;

    /*
     * @description 级别+审核状态
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/5/13 14:32
     */
    private String judgeLevelAddStateName;
    /**
     * 职业健康管理状况 审核状态
     */
    private String judgeCheckStateName;


    /**
     * 职业病危害暴露风险等级
     */
    private String riskLevelName;
    /*
     * @description 级别+审核状态
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/5/13 14:32
     */
    private String riskLevelAddStateName;
    /**
     * 暴露风险等级- 审核状态
     */
    private String riskLevelCheckStateName;
    /**
     * 职业病危害综合风险类别
     */
    private String riskClassifyName;

    /**
     * 企业职业病危害风险类别
     */
    private String occTypeName;
    /**
     * 数据更新时间
     */
    private String dataUpdateTime;
    //经济类型(导出使用
    private String registerTypeName;
    private String scale;
    private String scaleName;
    private String selfStaffName;
    private String contactNumber;
    private String legalName;
    private String legalTel;
    private String mainLeaderName;
    private String mainLeaderTel;
    private String occManagerName ;
    private String occManagerTel;
    /**
     *  0非直属， 1省直属，2市属
     */
    private Integer belongType;
    /**
     * 接害人数
     */
    private Integer pickupCount;
    private String belongTypeName;

    /**
     * 是否可以审核
     */
    private Boolean canAudit = true;

    /**
     * 数据范围
     * 0 历年分类企业数据 1 本年度分类企业数据
     */
    private Byte dataRange;

    private String dataRangeStr;

    /**
     * 经营状态
     * -1 全部（正常+暂停） 0 关闭 1 正常营业 2 暂停营业
     */
    private Byte businessState;

    private String businessStateStr;

    /**
     * 是否四重点行业
     *  0 不是 1 是
     * @return
     */
    private Byte isImpIndustry;

    //是否四重点行业字符串
    private String isImpIndustryStr;

    /**
     * 是否存在放射性
     */
    private Boolean isExistRadioactivity;

    /**
     * 是否健康企业
     * 0 否 1 是
     */
    private Byte isBest;

    /**
     * 最近一次体检机构
     */
    private String lastPhyOrgName;
    /**
     * 最近一次体检机构时间
     */
    private Date lastPhyOrgDate;
    private Integer phyType;
    private String lastPhyOrgDateStr;
    /**
     * 最近一次检测机构
     */
    private String lastCheckOrgName;
    /**
     * 最近一次体检机构时间
     */
    private Date lastCheckOrgDate;
    private String lastCheckOrgDateStr;
    private Integer creditSupervise;

    /**
     * 粉尘重点企业
     */
    private Integer isFcyth;

    /**
     * @description 实际接害人数
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @date 2025/1/7 14:28
     */
    private Integer identifyRealNum;
    public void setDataRange(Byte dataRange) {
        if (dataRange == 0) {
            this.setDataRangeStr("历年分类企业数据");
        }else {
            this.setDataRangeStr("本年度分类企业数据");
        }
        this.dataRange = dataRange;
    }

    public void setBusinessState(Byte businessState) {
        if (businessState == 0) {
            this.setBusinessStateStr("关闭");
        }else if(businessState == 1) {
            this.setBusinessStateStr("正常营业");
        }else {
            this.setBusinessStateStr("暂停营业");
        }
        this.businessState = businessState;
    }

    public void setIsImpIndustry(Byte isImpIndustry) {
        if (isImpIndustry == 1) {
            this.setIsImpIndustryStr("是");
        }else {
            this.setIsImpIndustryStr("否");
        }
        this.isImpIndustry = isImpIndustry;
    }

    public String getScaleName() {
        if (scale != null&&StringUtils.isNumber(scale)) {
            return CompanySizeEnum.getName(Integer.parseInt(scale));
        }
        return "";
    }

    /*public String getAreaFullName() {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank(provinceName)) {
            sb.append(provinceName);
        }
        if (StringUtils.isNotBlank(cityName)) {
            sb.append(cityName);
        }
        if (StringUtils.isNotBlank(areaName)) {
            sb.append(areaName);
        }
        if (StringUtils.isNotBlank(streetName)) {
            sb.append(streetName);
        }
        return sb.toString();
    }*/

    public String getJudgeLevelName() {
        if (this.getJudgeLevel() != null) {
            return JudgeResultLevelEnum.getNameByCode(this.getJudgeLevel());
        }
        return "未评定";
    }

    public String getRiskTypeName() {
        if (this.getRiskType() != null) {
            return "";
        }
        return "";
    }

    public String getIsRiskType() {
        if (this.getRiskType() != null) {
            return "是";
        }
        return "否";
    }

    public String getImportantCheckName() {
        if (this.getImportantCheck()!=null && (this.getImportantCheck()==1 || this.getImportantCheck()==2)) {
            return "是";
        }
        return "否";
    }

    public String getRiskLevelName() {
        if (this.getRiskLevel() != null) {
            return HazardsExposureRiskLevelEnum.getNameByCode(this.getRiskLevel());
        }
        return "未评定";
    }

    public String getRiskClassifyName() {
        if (this.getRiskClassify() != null) {
            for (CompanyGradeEnum c : CompanyGradeEnum.values()) {
                if (Objects.equals(c.getValue().intValue(), this.getRiskClassify())) {
                    return c.getName();
                }
            }
        }
        if (this.getGrade() != null) {
            return CompanyGradeEnum.getName(this.getGrade().byteValue());
        }
        return "未评定";
    }

    public String getOccTypeName() {
        if (this.getOccType() != null) {
            Integer occType = this.getOccType();
            return CompanyOccTypeEnum.getName(this.getOccType());
        }
        return "未划分";
    }

    public String getGradeName() {
        if (StringUtils.isNotBlank(this.gradeName)) {
            return this.gradeName;
        }
        if (this.getGrade() != null) {
            String name = CompanyGradeEnum.getName(this.getGrade().byteValue());
            if ("未评定".equals(name)) {
                return "/";
            }
            return name;
        }
        return "/";
    }

    public String getRgradeName() {
        if (this.getRgrade() != null) {
            String name = CompanyGradeEnum.getName(this.getRgrade().byteValue());
            return name;
        }
        return "未评定";
    }

    public String getBelongTypeName() {
        if (Objects.equals(2, this.getBelongType())) {
            return "是";
        }
        return "否";
    }

    public String getGradeSourceName() {
        if (this.getGradeSource() != null) {
            String name = GradeSourceEnum.getName(this.getGradeSource());
            return name;
        }
        return "";
    }

    public String getRiskLevelAddStateName() {
        if (this.getRiskId() != null) {
            if (Objects.equals(this.getRiskCheckState(), 0)) {
                return HazardsExposureRiskLevelEnum.getNameByCode(this.getRiskLevel())+"(待审核)";
            }else if (Objects.equals(this.getRiskCheckState(), -1)) {
                return HazardsExposureRiskLevelEnum.getNameByCode(this.getRiskLevel())+"(已退回)";
            }
            return HazardsExposureRiskLevelEnum.getNameByCode(this.getRiskLevel());
        }
        return "未提交";
    }

    public String getJudgeLevelAddStateName() {
        if (this.getSelfId() != null) {
            if (Objects.equals(this.getJugdeCheckState(), 0)) {
                return JudgeResultLevelEnum.getNameByCode(this.getJudgeLevel())+"(待审核)";
            }else if (Objects.equals(this.getJugdeCheckState(), -1)) {
                return JudgeResultLevelEnum.getNameByCode(this.getJudgeLevel())+"(已退回)";
            }
            return JudgeResultLevelEnum.getNameByCode(this.getJudgeLevel());
        }
        return "未提交";
    }

}
